/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.keysearch;

import edu.rit.crypto.blockcipher.AES256Cipher;
import edu.rit.mp.Buf;
import edu.rit.pj.Comm;
import edu.rit.pj.CommRequest;
import edu.rit.util.Hex;
import edu.rit.util.Range;

public class FindKeyClu2 {
    static byte[] plaintext;
    static byte[] ciphertext;
    static byte[] partialkey;
    static int n;
    static int keylsbs;
    static int maxcounter;
    static byte[] foundkey;
    static byte[] trialkey;
    static byte[] trialciphertext;
    static AES256Cipher cipher;

    private FindKeyClu2() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        Comm comm = Comm.world();
        int n = comm.size();
        int n2 = comm.rank();
        if (stringArray.length != 4) {
            FindKeyClu2.usage();
        }
        plaintext = Hex.toByteArray(stringArray[0]);
        ciphertext = Hex.toByteArray(stringArray[1]);
        partialkey = Hex.toByteArray(stringArray[2]);
        FindKeyClu2.n = Integer.parseInt(stringArray[3]);
        if (FindKeyClu2.n < 0) {
            System.err.println("n = " + FindKeyClu2.n + " is too small");
            System.exit(1);
        }
        if (FindKeyClu2.n > 30) {
            System.err.println("n = " + FindKeyClu2.n + " is too large");
            System.exit(1);
        }
        keylsbs = (partialkey[28] & 0xFF) << 24 | (partialkey[29] & 0xFF) << 16 | (partialkey[30] & 0xFF) << 8 | partialkey[31] & 0xFF;
        maxcounter = 1 << FindKeyClu2.n;
        trialkey = new byte[32];
        System.arraycopy(partialkey, 0, trialkey, 0, 32);
        trialciphertext = new byte[16];
        cipher = new AES256Cipher(trialkey);
        Range range = new Range(0, maxcounter - 1).subrange(n, n2);
        int n3 = range.lb();
        int n4 = range.ub();
        CommRequest commRequest = new CommRequest();
        comm.floodReceive(Buf.emptyBuffer(), commRequest);
        for (int i = n3; i <= n4; ++i) {
            int n5 = keylsbs | i;
            FindKeyClu2.trialkey[28] = (byte)(n5 >>> 24);
            FindKeyClu2.trialkey[29] = (byte)(n5 >>> 16);
            FindKeyClu2.trialkey[30] = (byte)(n5 >>> 8);
            FindKeyClu2.trialkey[31] = (byte)n5;
            cipher.setKey(trialkey);
            cipher.encrypt(plaintext, trialciphertext);
            if (FindKeyClu2.match(ciphertext, trialciphertext)) {
                foundkey = new byte[32];
                System.arraycopy(trialkey, 0, foundkey, 0, 32);
                comm.floodSend(Buf.emptyBuffer());
            }
            if (commRequest.isFinished()) break;
        }
        if (foundkey != null) {
            System.out.println(Hex.toString(foundkey));
        }
        long l2 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec (" + n2 + ")");
    }

    private static boolean match(byte[] byArray, byte[] byArray2) {
        boolean bl = true;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            bl = bl && byArray[i] == byArray2[i];
        }
        return bl;
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<K> edu.rit.clu.keysearch.FindKeyClu2 <plaintext> <ciphertext> <partialkey> <n>");
        System.err.println("<K> = Number of parallel processes");
        System.err.println("<plaintext> = Plaintext (128-bit hexadecimal number)");
        System.err.println("<ciphertext> = Ciphertext (128-bit hexadecimal number)");
        System.err.println("<partialkey> = Partial key (256-bit hexadecimal number)");
        System.err.println("<n> = Number of key bits to search for");
        System.exit(1);
    }
}

