/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.fractal;

import edu.rit.color.HSB;
import edu.rit.image.SyncColorImage;
import edu.rit.mp.IntegerBuf;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.ParallelTeam;
import edu.rit.util.Range;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;

public class MandelbrotSetClu3 {
    static Comm world;
    static int size;
    static int rank;
    static int width;
    static int height;
    static double xcenter;
    static double ycenter;
    static double resolution;
    static int maxiter;
    static double gamma;
    static File filename;
    static int xoffset;
    static int yoffset;
    static int[][] matrix;
    static SyncColorImage image;
    static int[] huetable;
    static ParallelSection masterSection;
    static ParallelSection workerSection;
    static ParallelSection outputSection;

    private MandelbrotSetClu3() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length != 8) {
            MandelbrotSetClu3.usage();
        }
        width = Integer.parseInt(stringArray[0]);
        height = Integer.parseInt(stringArray[1]);
        xcenter = Double.parseDouble(stringArray[2]);
        ycenter = Double.parseDouble(stringArray[3]);
        resolution = Double.parseDouble(stringArray[4]);
        maxiter = Integer.parseInt(stringArray[5]);
        gamma = Double.parseDouble(stringArray[6]);
        filename = new File(stringArray[7]);
        xoffset = -(width - 1) / 2;
        yoffset = (height - 1) / 2;
        if (rank == 0) {
            matrix = new int[height][width];
            image = new SyncColorImage(matrix);
        }
        huetable = new int[maxiter + 1];
        for (int i = 0; i < maxiter; ++i) {
            MandelbrotSetClu3.huetable[i] = HSB.pack((float)Math.pow((double)i / (double)maxiter, gamma), 1.0f, 1.0f);
        }
        MandelbrotSetClu3.huetable[MandelbrotSetClu3.maxiter] = HSB.pack(1.0f, 1.0f, 0.0f);
        masterSection = new ParallelSection(){

            public void run() throws Exception {
                new ParallelTeam(size).execute(new ParallelRegion(){

                    public void run() throws Exception {
                        this.execute(0, height - 1, NO_WAIT, new IntegerForLoop(){
                            int worker;
                            Range range;
                            ObjectItemBuf<Range> rangebuf;

                            public void start() {
                                this.worker = this.getThreadIndex();
                                this.rangebuf = new ObjectItemBuf();
                            }

                            public void run(int n, int n2) throws Exception {
                                this.range = new Range(n, n2);
                                this.rangebuf.item = this.range;
                                world.send(this.worker, this.rangebuf);
                                IntegerBuf integerBuf = IntegerBuf.rowSliceBuffer(matrix, this.range);
                                world.receive(this.worker, integerBuf);
                                image.rowsProduced(this.range);
                            }

                            public void finish() throws Exception {
                                this.rangebuf.item = null;
                                world.send(this.worker, this.rangebuf);
                            }
                        });
                    }
                });
            }
        };
        workerSection = new ParallelSection(){

            public void run() throws Exception {
                Range range = null;
                ObjectItemBuf objectItemBuf = new ObjectItemBuf();
                int[][] nArray = null;
                IntegerBuf integerBuf = null;
                while (true) {
                    world.receive(0, objectItemBuf);
                    range = (Range)objectItemBuf.item;
                    if (range == null) break;
                    if (nArray == null || nArray.length < range.length()) {
                        nArray = new int[range.length()][width];
                    }
                    integerBuf = IntegerBuf.rowSliceBuffer(nArray, new Range(0, range.length() - 1));
                    int n = range.lb();
                    int n2 = range.ub();
                    for (int i = n; i <= n2; ++i) {
                        double d = ycenter + (double)(yoffset - i) / resolution;
                        for (int j = 0; j < width; ++j) {
                            int n3;
                            double d2 = xcenter + (double)(xoffset + j) / resolution;
                            double d3 = 0.0;
                            double d4 = 0.0;
                            double d5 = 0.0;
                            double d6 = 0.0;
                            double d7 = 0.0;
                            for (n3 = 0; n3 < maxiter && d7 <= 4.0; ++n3) {
                                d5 = d3 * d3 - d4 * d4 + d2;
                                d6 = 2.0 * d3 * d4 + d;
                                d7 = d5 * d5 + d6 * d6;
                                d3 = d5;
                                d4 = d6;
                            }
                            nArray[i - n][j] = huetable[n3];
                        }
                    }
                    world.send(0, integerBuf);
                }
            }
        };
        outputSection = new ParallelSection(){

            public void run() throws Exception {
                ImageIO.write((RenderedImage)image, "png", new BufferedOutputStream(new FileOutputStream(filename)));
            }
        };
        if (rank == 0) {
            new ParallelTeam(3).execute(new ParallelRegion(){

                public void run() throws Exception {
                    this.execute(masterSection, workerSection, outputSection);
                }
            });
        } else {
            workerSection.run();
        }
        long l2 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec total " + rank);
    }

    private static void usage() {
        System.err.println("Usage: -Dpj.np=<K> java edu.rit.clu.fractal.MandelbrotSetClu3 <width> <height> <xcenter> <ycenter> <resolution> <maxiter> <gamma> <filename>");
        System.err.println("<K> = Number of parallel processes");
        System.err.println("<width> = Image width (pixels)");
        System.err.println("<height> = Image height (pixels)");
        System.err.println("<xcenter> = X coordinate of center point");
        System.err.println("<ycenter> = Y coordinate of center point");
        System.err.println("<resolution> = Pixels per unit");
        System.err.println("<maxiter> = Maximum number of iterations");
        System.err.println("<gamma> = Used to calculate pixel hues");
        System.err.println("<filename> = PNG image file name");
        System.exit(1);
    }
}

