/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.fractal;

import edu.rit.color.HSB;
import edu.rit.image.ColorImage;
import edu.rit.mp.IntegerBuf;
import edu.rit.pj.Comm;
import edu.rit.util.Range;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;

public class MandelbrotSetClu {
    static Comm world;
    static int size;
    static int rank;
    static int width;
    static int height;
    static double xcenter;
    static double ycenter;
    static double resolution;
    static int maxiter;
    static double gamma;
    static File filename;
    static int xoffset;
    static int yoffset;
    static Range[] ranges;
    static Range myrange;
    static int mylb;
    static int myub;
    static int[][] matrix;
    static ColorImage image;
    static IntegerBuf[] slices;
    static IntegerBuf myslice;
    static int[] huetable;

    private MandelbrotSetClu() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length != 8) {
            MandelbrotSetClu.usage();
        }
        width = Integer.parseInt(stringArray[0]);
        height = Integer.parseInt(stringArray[1]);
        xcenter = Double.parseDouble(stringArray[2]);
        ycenter = Double.parseDouble(stringArray[3]);
        resolution = Double.parseDouble(stringArray[4]);
        maxiter = Integer.parseInt(stringArray[5]);
        gamma = Double.parseDouble(stringArray[6]);
        filename = new File(stringArray[7]);
        xoffset = -(width - 1) / 2;
        yoffset = (height - 1) / 2;
        ranges = new Range(0, height - 1).subranges(size);
        myrange = ranges[rank];
        mylb = myrange.lb();
        myub = myrange.ub();
        if (rank == 0) {
            matrix = new int[height][width];
            image = new ColorImage(matrix);
            slices = IntegerBuf.rowSliceBuffers(matrix, ranges);
            myslice = slices[rank];
        } else {
            matrix = new int[myrange.length()][width];
            myslice = IntegerBuf.buffer(matrix);
        }
        huetable = new int[maxiter + 1];
        for (int i = 0; i < maxiter; ++i) {
            MandelbrotSetClu.huetable[i] = HSB.pack((float)Math.pow((double)i / (double)maxiter, gamma), 1.0f, 1.0f);
        }
        MandelbrotSetClu.huetable[MandelbrotSetClu.maxiter] = HSB.pack(1.0f, 1.0f, 0.0f);
        long l2 = System.currentTimeMillis();
        for (int i = mylb; i <= myub; ++i) {
            double d = ycenter + (double)(yoffset - i) / resolution;
            for (int j = 0; j < width; ++j) {
                int n;
                double d2 = xcenter + (double)(xoffset + j) / resolution;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                for (n = 0; n < maxiter && d7 <= 4.0; ++n) {
                    d5 = d3 * d3 - d4 * d4 + d2;
                    d6 = 2.0 * d3 * d4 + d;
                    d7 = d5 * d5 + d6 * d6;
                    d3 = d5;
                    d4 = d6;
                }
                MandelbrotSetClu.matrix[i - MandelbrotSetClu.mylb][j] = huetable[n];
            }
        }
        long l3 = System.currentTimeMillis();
        world.gather(0, myslice, slices);
        if (rank == 0) {
            ImageIO.write((RenderedImage)image, "png", new BufferedOutputStream(new FileOutputStream(filename)));
        }
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre " + rank);
        System.out.println(l3 - l2 + " msec calc " + rank);
        System.out.println(l4 - l3 + " msec post " + rank);
        System.out.println(l4 - l + " msec total " + rank);
    }

    private static void usage() {
        System.err.println("Usage: -Dpj.np=<K> java edu.rit.clu.fractal.MandelbrotSetClu <width> <height> <xcenter> <ycenter> <resolution> <maxiter> <gamma> <filename>");
        System.err.println("<K> = Number of parallel processes");
        System.err.println("<width> = Image width (pixels)");
        System.err.println("<height> = Image height (pixels)");
        System.err.println("<xcenter> = X coordinate of center point");
        System.err.println("<ycenter> = Y coordinate of center point");
        System.err.println("<resolution> = Pixels per unit");
        System.err.println("<maxiter> = Maximum number of iterations");
        System.err.println("<gamma> = Used to calculate pixel hues");
        System.err.println("<filename> = PNG image file name");
        System.exit(1);
    }
}

