/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.antimatter;

import edu.rit.pj.Comm;
import edu.rit.util.Random;
import edu.rit.vector.Vector2D;

public class AntiprotonSeq {
    static final double QP = 3.0;
    static final double QT = 3.0;
    static Vector2D[] f;
    static Vector2D[] v;
    static Vector2D[] p;

    private AntiprotonSeq() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = -System.currentTimeMillis();
        Comm.init(stringArray);
        Vector2D vector2D = new Vector2D();
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length && stringArray[n].charAt(0) == '-') {
            if (stringArray[n].equals("-p")) {
                bl = true;
                ++n;
                continue;
            }
            AntiprotonSeq.usage();
        }
        if (stringArray.length - n != 5) {
            AntiprotonSeq.usage();
        }
        long l2 = Long.parseLong(stringArray[n]);
        double d = Double.parseDouble(stringArray[n + 1]);
        double d2 = Double.parseDouble(stringArray[n + 2]);
        int n2 = Integer.parseInt(stringArray[n + 3]);
        int n3 = Integer.parseInt(stringArray[n + 4]);
        double d3 = 0.5 * d2 * d2;
        double d4 = 9.0;
        double d5 = 9.0;
        Random random = Random.getInstance(l2);
        f = new Vector2D[n3];
        v = new Vector2D[n3];
        p = new Vector2D[n3];
        for (n = 0; n < n3; ++n) {
            AntiprotonSeq.f[n] = new Vector2D();
            AntiprotonSeq.v[n] = new Vector2D();
            AntiprotonSeq.p[n] = new Vector2D(random.nextDouble() * d, random.nextDouble() * d);
        }
        AntiprotonSeq.printPositions(bl);
        for (int i = 0; i < n2; ++i) {
            Vector2D vector2D2;
            Vector2D vector2D3;
            Vector2D vector2D4;
            for (n = 0; n < n3; ++n) {
                double d6;
                int n4;
                vector2D4 = f[n];
                vector2D3 = p[n];
                for (n4 = 0; n4 < n; ++n4) {
                    vector2D2 = p[n4];
                    vector2D.assign(vector2D3);
                    vector2D.sub(vector2D2);
                    d6 = vector2D.mag();
                    vector2D.mul(d4 / (d6 * d6 * d6));
                    vector2D4.add(vector2D);
                }
                for (n4 = n + 1; n4 < n3; ++n4) {
                    vector2D2 = p[n4];
                    vector2D.assign(vector2D3);
                    vector2D.sub(vector2D2);
                    d6 = vector2D.mag();
                    vector2D.mul(d4 / (d6 * d6 * d6));
                    vector2D4.add(vector2D);
                }
            }
            for (n = 0; n < n3; ++n) {
                vector2D4 = f[n];
                vector2D3 = v[n];
                vector2D2 = p[n];
                double d7 = vector2D2.x;
                double d8 = d7 * d7;
                double d9 = vector2D2.x - d;
                double d10 = d9 * d9;
                double d11 = vector2D2.y;
                double d12 = d11 * d11;
                vector2D4.x += d5 * (1.0 / Math.sqrt(d10 + d12) - 1.0 / Math.sqrt(d8 + d12));
                vector2D4.y += d5 / d11 * (-d9 / Math.sqrt(d10 + d12) + d7 / Math.sqrt(d8 + d12));
                d11 = vector2D2.y - d;
                d12 = d11 * d11;
                vector2D4.x += d5 * (1.0 / Math.sqrt(d10 + d12) - 1.0 / Math.sqrt(d8 + d12));
                vector2D4.y += d5 / d11 * (-d9 / Math.sqrt(d10 + d12) + d7 / Math.sqrt(d8 + d12));
                double d13 = vector2D2.y;
                double d14 = d13 * d13;
                double d15 = vector2D2.y - d;
                double d16 = d15 * d15;
                double d17 = vector2D2.x;
                double d18 = d17 * d17;
                vector2D4.y += d5 * (1.0 / Math.sqrt(d16 + d18) - 1.0 / Math.sqrt(d14 + d18));
                vector2D4.x += d5 / d17 * (-d15 / Math.sqrt(d16 + d18) + d13 / Math.sqrt(d14 + d18));
                d17 = vector2D2.x - d;
                d18 = d17 * d17;
                vector2D4.y += d5 * (1.0 / Math.sqrt(d16 + d18) - 1.0 / Math.sqrt(d14 + d18));
                vector2D4.x += d5 / d17 * (-d15 / Math.sqrt(d16 + d18) + d13 / Math.sqrt(d14 + d18));
                vector2D.assign(vector2D3);
                vector2D2.add(vector2D.mul(d2));
                vector2D.assign(vector2D4);
                vector2D2.add(vector2D.mul(d3));
                vector2D.assign(vector2D4);
                vector2D3.add(vector2D.mul(d2));
                vector2D4.clear();
            }
        }
        AntiprotonSeq.printPositions(bl);
        System.out.println((l += System.currentTimeMillis()) + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.clu.antimatter.AntiprotonSeq [-p] <seed> <side> <dt> <steps> <N>");
        System.exit(1);
    }

    private static void printPositions(boolean bl) {
        if (bl) {
            int n = p.length;
            for (int i = 0; i < n; ++i) {
                Vector2D vector2D = p[i];
                System.out.print(i);
                System.out.print('\t');
                System.out.print(vector2D.x);
                System.out.print('\t');
                System.out.print(vector2D.y);
                System.out.println();
            }
        }
    }
}

