/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.antimatter;

import edu.rit.mp.Buf;
import edu.rit.pj.Comm;
import edu.rit.util.Random;
import edu.rit.util.Range;
import edu.rit.vector.Vector2D;

public class AntiprotonClu2 {
    static final double QP = 3.0;
    static final double QT = 3.0;
    static Comm world;
    static int size;
    static int rank;
    static Range[] ranges;
    static Range myrange;
    static int mylb;
    static int myub;
    static int mylength;
    static Vector2D[] f;
    static Vector2D[] v;
    static Vector2D[] p;
    static Vector2D[] otherp;
    static Buf p_buf;
    static Buf otherp_buf;

    private AntiprotonClu2() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = -System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        Vector2D vector2D = new Vector2D();
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length && stringArray[n].charAt(0) == '-') {
            if (stringArray[n].equals("-p")) {
                bl = true;
                ++n;
                continue;
            }
            AntiprotonClu2.usage();
        }
        if (stringArray.length - n != 5) {
            AntiprotonClu2.usage();
        }
        long l2 = Long.parseLong(stringArray[n]);
        double d = Double.parseDouble(stringArray[n + 1]);
        double d2 = Double.parseDouble(stringArray[n + 2]);
        int n2 = Integer.parseInt(stringArray[n + 3]);
        int n3 = Integer.parseInt(stringArray[n + 4]);
        double d3 = 0.5 * d2 * d2;
        double d4 = 9.0;
        double d5 = 9.0;
        ranges = new Range(0, n3 - 1).subranges(size);
        myrange = ranges[rank];
        mylb = myrange.lb();
        myub = myrange.ub();
        mylength = myrange.length();
        Random random = Random.getInstance(l2);
        random.skip(2 * mylb);
        f = new Vector2D[mylength];
        v = new Vector2D[mylength];
        p = new Vector2D[mylength];
        for (n = 0; n < mylength; ++n) {
            AntiprotonClu2.f[n] = new Vector2D();
            AntiprotonClu2.v[n] = new Vector2D();
            AntiprotonClu2.p[n] = new Vector2D(random.nextDouble() * d, random.nextDouble() * d);
        }
        int n4 = 0;
        for (n = 0; n < size; ++n) {
            n4 = Math.max(n4, ranges[n].length());
        }
        otherp = new Vector2D[n4];
        for (n = 0; n < n4; ++n) {
            AntiprotonClu2.otherp[n] = new Vector2D();
        }
        p_buf = Vector2D.doubleBuffer(p);
        otherp_buf = Vector2D.doubleBuffer(otherp);
        AntiprotonClu2.printPositions(bl);
        for (int i = 0; i < n2; ++i) {
            double d6;
            int n5;
            for (n = mylb; n <= myub; ++n) {
                Vector2D vector2D2;
                Vector2D vector2D3 = f[n - mylb];
                Vector2D vector2D4 = p[n - mylb];
                for (n5 = mylb; n5 < n; ++n5) {
                    vector2D2 = p[n5 - mylb];
                    vector2D.assign(vector2D4);
                    vector2D.sub(vector2D2);
                    d6 = vector2D.mag();
                    vector2D.mul(d4 / (d6 * d6 * d6));
                    vector2D3.add(vector2D);
                }
                for (n5 = n + 1; n5 <= myub; ++n5) {
                    vector2D2 = p[n5 - mylb];
                    vector2D.assign(vector2D4);
                    vector2D.sub(vector2D2);
                    d6 = vector2D.mag();
                    vector2D.mul(d4 / (d6 * d6 * d6));
                    vector2D3.add(vector2D);
                }
            }
            for (int j = 1; j < size; ++j) {
                int n6;
                int n7 = rank - j;
                if (n7 < 0) {
                    n7 += size;
                }
                if ((n6 = rank + j) >= size) {
                    n6 -= size;
                }
                world.sendReceive(n7, p_buf, n6, otherp_buf);
                int n8 = ranges[n6].lb();
                int n9 = ranges[n6].ub();
                for (n = mylb; n <= myub; ++n) {
                    Vector2D vector2D5 = f[n - mylb];
                    Vector2D vector2D6 = p[n - mylb];
                    for (n5 = n8; n5 <= n9; ++n5) {
                        Vector2D vector2D7 = otherp[n5 - n8];
                        vector2D.assign(vector2D6);
                        vector2D.sub(vector2D7);
                        d6 = vector2D.mag();
                        vector2D.mul(d4 / (d6 * d6 * d6));
                        vector2D5.add(vector2D);
                    }
                }
            }
            for (n = mylb; n <= myub; ++n) {
                Vector2D vector2D8 = f[n - mylb];
                Vector2D vector2D9 = v[n - mylb];
                Vector2D vector2D10 = p[n - mylb];
                double d7 = vector2D10.x;
                double d8 = d7 * d7;
                double d9 = vector2D10.x - d;
                double d10 = d9 * d9;
                double d11 = vector2D10.y;
                double d12 = d11 * d11;
                vector2D8.x += d5 * (1.0 / Math.sqrt(d10 + d12) - 1.0 / Math.sqrt(d8 + d12));
                vector2D8.y += d5 / d11 * (-d9 / Math.sqrt(d10 + d12) + d7 / Math.sqrt(d8 + d12));
                d11 = vector2D10.y - d;
                d12 = d11 * d11;
                vector2D8.x += d5 * (1.0 / Math.sqrt(d10 + d12) - 1.0 / Math.sqrt(d8 + d12));
                vector2D8.y += d5 / d11 * (-d9 / Math.sqrt(d10 + d12) + d7 / Math.sqrt(d8 + d12));
                double d13 = vector2D10.y;
                double d14 = d13 * d13;
                double d15 = vector2D10.y - d;
                double d16 = d15 * d15;
                double d17 = vector2D10.x;
                double d18 = d17 * d17;
                vector2D8.y += d5 * (1.0 / Math.sqrt(d16 + d18) - 1.0 / Math.sqrt(d14 + d18));
                vector2D8.x += d5 / d17 * (-d15 / Math.sqrt(d16 + d18) + d13 / Math.sqrt(d14 + d18));
                d17 = vector2D10.x - d;
                d18 = d17 * d17;
                vector2D8.y += d5 * (1.0 / Math.sqrt(d16 + d18) - 1.0 / Math.sqrt(d14 + d18));
                vector2D8.x += d5 / d17 * (-d15 / Math.sqrt(d16 + d18) + d13 / Math.sqrt(d14 + d18));
                vector2D.assign(vector2D9);
                vector2D10.add(vector2D.mul(d2));
                vector2D.assign(vector2D8);
                vector2D10.add(vector2D.mul(d3));
                vector2D.assign(vector2D8);
                vector2D9.add(vector2D.mul(d2));
                vector2D8.clear();
            }
        }
        AntiprotonClu2.printPositions(bl);
        System.out.println((l += System.currentTimeMillis()) + " msec total " + rank);
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<K> edu.rit.clu.antimatter.AntiprotonClu2 [-p] <seed> <side> <dt> <steps> <N>");
        System.exit(1);
    }

    private static void printPositions(boolean bl) {
        if (bl) {
            for (int i = mylb; i <= myub; ++i) {
                Vector2D vector2D = p[i - mylb];
                System.out.print(i);
                System.out.print('\t');
                System.out.print(vector2D.x);
                System.out.print('\t');
                System.out.print(vector2D.y);
                System.out.println();
            }
        }
    }
}

