/*
 * Decompiled with CFR 0.152.
 */
import edu.rit.numeric.AggregateXYSeries;
import edu.rit.numeric.ListSeries;
import edu.rit.numeric.plot.Dots;
import edu.rit.numeric.plot.Plot;
import java.awt.Color;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class Speedup {
    private static Pattern QUOTED_STRING_PATTERN = Pattern.compile("\"[^\"]*\"");
    private static DecimalFormat FMT_0 = new DecimalFormat("0");
    private static DecimalFormat FMT_0E = new DecimalFormat("0E0");
    private static DecimalFormat FMT_1 = new DecimalFormat("0.0");
    private static DecimalFormat FMT_2 = new DecimalFormat("0.00");
    private static DecimalFormat FMT_3 = new DecimalFormat("0.000");
    private static Map<Integer, Data> dataMap = new TreeMap<Integer, Data>();
    private static double K_max = Double.NEGATIVE_INFINITY;
    private static Plot T_plot = new Plot();
    private static Plot Speedup_plot = new Plot();
    private static Plot Eff_plot = new Plot();
    private static Plot EDSF_plot = new Plot();

    private Speedup() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            Speedup.usage();
        }
        File file = new File(stringArray[0]);
        T_plot.plotTitle("Running Time vs. Processors").leftMargin(42.0).minorGridLines(true).xAxisKind(Plot.LOGARITHMIC).xAxisMinorDivisions(10).xAxisTitle("Processors, <I>K</I>").yAxisKind(Plot.LOGARITHMIC).yAxisMinorDivisions(10).yAxisTickFormat(FMT_0E).yAxisTickScale(1000.0).yAxisTitle("<I>T</I> (<I>N,K</I>) (sec)").yAxisTitleOffset(30.0).labelPosition(5).labelOffset(6.0);
        Speedup_plot.plotTitle("Speedup vs. Processors").leftMargin(42.0).xAxisStart(0.0).xAxisTitle("Processors, <I>K</I>").yAxisStart(0.0).yAxisTickFormat(FMT_0).yAxisTitle("<I>Speedup</I> (<I>N,K</I>)").yAxisTitleOffset(30.0).labelPosition(5).labelOffset(6.0);
        Eff_plot.plotTitle("Efficiency vs. Processors").leftMargin(42.0).xAxisStart(0.0).xAxisTitle("Processors, <I>K</I>").yAxisStart(0.0).yAxisTickFormat(FMT_1).yAxisTitle("<I>Eff</I> (<I>N,K</I>)").yAxisTitleOffset(30.0).labelPosition(5).labelOffset(6.0);
        EDSF_plot.plotTitle("EDSF vs. Processors").leftMargin(42.0).xAxisStart(0.0).xAxisTitle("Processors, <I>K</I>").yAxisStart(0.0).yAxisTickFormat(FMT_0).yAxisTickScale(0.001).yAxisTitle("<I>EDSF</I> (/1000)").yAxisTitleOffset(30.0).labelPosition(5).labelOffset(6.0);
        Scanner scanner = new Scanner(file);
        int n = 1;
        while (scanner.hasNextLine()) {
            Object object = scanner.nextLine();
            int n2 = ((String)object).indexOf(35);
            if (n2 >= 0) {
                object = ((String)object).substring(0, n2);
            }
            if (((String)(object = ((String)object).trim())).length() > 0) {
                Speedup.parseLine((String)object, n);
            }
            ++n;
        }
        for (Data data : dataMap.values()) {
            Speedup.validateData(data);
        }
        Speedup_plot.seriesDots(null).seriesPaint(new Color(0.7f, 0.7f, 0.7f)).xySeries(new double[]{0.0, K_max}, new double[]{0.0, K_max}).seriesDots(Dots.circle(5.0)).seriesPaint(Color.black);
        Eff_plot.seriesDots(null).seriesPaint(new Color(0.7f, 0.7f, 0.7f)).xySeries(new double[]{0.0, K_max}, new double[]{1.0, 1.0}).seriesDots(Dots.circle(5.0)).seriesPaint(Color.black);
        System.out.println("N\tK\tT\tSpdup\tEffic\tEDSF\tDevi");
        for (Data data : dataMap.values()) {
            if (data.K_series.isEmpty()) continue;
            System.out.println();
            String string = data.labelText;
            if (string.startsWith("N = ")) {
                string = string.substring(4);
            } else if (string.startsWith("N=")) {
                string = string.substring(2);
            }
            if (data.T_seq != 0.0) {
                System.out.println(string + "\tseq\t" + FMT_0.format(data.T_seq) + "\t\t\t\t" + FMT_0.format(100.0 * data.Dev_seq) + "%");
            }
            int n3 = data.K_series.length();
            System.out.println(string + "\t" + FMT_0.format(data.K_series.x(0)) + "\t" + FMT_0.format(data.T_series.x(0)) + "\t" + FMT_3.format(data.Speedup_series.x(0)) + "\t" + FMT_3.format(data.Eff_series.x(0)) + "\t\t" + FMT_0.format(100.0 * data.Dev_series.x(0)) + "%");
            for (int i = 1; i < n3; ++i) {
                System.out.println(string + "\t" + FMT_0.format(data.K_series.x(i)) + "\t" + FMT_0.format(data.T_series.x(i)) + "\t" + FMT_3.format(data.Speedup_series.x(i)) + "\t" + FMT_3.format(data.Eff_series.x(i)) + "\t" + FMT_3.format(data.EDSF_series_2.x(i - 1)) + "\t" + FMT_0.format(100.0 * data.Dev_series.x(i)) + "%");
            }
            T_plot.xySeries(new AggregateXYSeries(data.K_series, data.T_series)).label(data.labelText, data.K_series.x(n3 - 1), data.T_series.x(n3 - 1));
            Speedup_plot.xySeries(new AggregateXYSeries(data.K_series, data.Speedup_series)).label(data.labelText, data.K_series.x(n3 - 1), data.Speedup_series.x(n3 - 1));
            Eff_plot.xySeries(new AggregateXYSeries(data.K_series, data.Eff_series)).label(data.labelText, data.K_series.x(n3 - 1), data.Eff_series.x(n3 - 1));
            EDSF_plot.xySeries(new AggregateXYSeries(data.K_series_2, data.EDSF_series_2)).label(data.labelText, data.K_series_2.x(n3 - 2), data.EDSF_series_2.x(n3 - 2));
        }
        T_plot.display();
        Speedup_plot.display();
        Eff_plot.display();
        EDSF_plot.display();
    }

    private static void parseLine(String string, int n) {
        Scanner scanner = new Scanner(string);
        if (scanner.hasNextInt()) {
            int n2;
            int n3 = scanner.nextInt();
            if (!scanner.hasNextInt()) {
                Speedup.error("K invalid", n);
            }
            if ((n2 = scanner.nextInt()) < 0) {
                Speedup.error("K < 0", n);
            }
            K_max = Math.max(K_max, (double)n2);
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            while (scanner.hasNextLong()) {
                double d3 = scanner.nextLong();
                if (d3 <= 0.0) {
                    Speedup.error("T invalid", n);
                }
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
            if (d == Double.POSITIVE_INFINITY) {
                Speedup.error("T values missing", n);
            }
            Data data = Speedup.getData(n3);
            if (n2 == 0) {
                data.T_seq = d;
                data.T_max_seq = d2;
                data.Dev_seq = (d2 - d) / d;
            } else if (n2 == 1) {
                double d4;
                double d5 = d4 = data.T_seq == 0.0 ? 1.0 : data.T_seq / d;
                double d6 = (d2 - d) / d;
                data.T_par_1 = d;
                data.K_series.add(n2);
                data.T_series.add(d);
                data.T_max_series.add(d2);
                data.Speedup_series.add(d4);
                data.Eff_series.add(d5);
                data.Dev_series.add(d6);
            } else {
                double d7 = data.T_seq == 0.0 ? data.T_par_1 / d : data.T_seq / d;
                double d8 = d7 / (double)n2;
                double d9 = (d2 - d) / d;
                double d10 = ((double)n2 * d - data.T_par_1) / data.T_par_1 / (double)(n2 - 1);
                data.K_series.add(n2);
                data.T_series.add(d);
                data.T_max_series.add(d2);
                data.Speedup_series.add(d7);
                data.Eff_series.add(d8);
                data.Dev_series.add(d9);
                data.K_series_2.add(n2);
                data.EDSF_series_2.add(d10);
            }
        } else {
            String string2 = scanner.next();
            if (string2.equals("n")) {
                if (!scanner.hasNextInt()) {
                    Speedup.error("Missing n value", n);
                }
                int n4 = scanner.nextInt();
                if (!scanner.hasNextDouble()) {
                    Speedup.error("Missing N value", n);
                }
                double d = scanner.nextDouble();
                String string3 = scanner.findInLine(QUOTED_STRING_PATTERN);
                if (string3 == null) {
                    Speedup.error("Missing quoted label text", n);
                }
                string3 = string3.substring(1, string3.length() - 1);
                Data data = Speedup.getData(n4);
                data.N = d;
                data.labelText = string3;
            } else if (string2.equals("time")) {
                Speedup.parsePlotSpecification(T_plot, scanner, n);
            } else if (string2.equals("speedup")) {
                Speedup.parsePlotSpecification(Speedup_plot, scanner, n);
            } else if (string2.equals("eff")) {
                Speedup.parsePlotSpecification(Eff_plot, scanner, n);
            } else if (string2.equals("edsf")) {
                Speedup.parsePlotSpecification(EDSF_plot, scanner, n);
            } else {
                Speedup.error("Unknown command", n);
            }
        }
    }

    private static void parsePlotSpecification(Plot plot, Scanner scanner, int n) {
        String string;
        if (!scanner.hasNext()) {
            Speedup.error("Missing plot attribute", n);
        }
        if ((string = scanner.next()).equals("plotTitle")) {
            String string2 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string2 == null) {
                Speedup.error("Missing quoted plot title", n);
            }
            string2 = string2.substring(1, string2.length() - 1);
            plot.plotTitle(string2);
        } else if (string.equals("margins")) {
            if (!scanner.hasNextDouble()) {
                Speedup.error("Missing margins value", n);
            }
            double d = scanner.nextDouble();
            plot.margins(d);
        } else if (string.equals("leftMargin")) {
            if (!scanner.hasNextDouble()) {
                Speedup.error("Missing left margin value", n);
            }
            double d = scanner.nextDouble();
            plot.leftMargin(d);
        } else if (string.equals("topMargin")) {
            if (!scanner.hasNextDouble()) {
                Speedup.error("Missing top margin value", n);
            }
            double d = scanner.nextDouble();
            plot.topMargin(d);
        } else if (string.equals("rightMargin")) {
            if (!scanner.hasNextDouble()) {
                Speedup.error("Missing right margin value", n);
            }
            double d = scanner.nextDouble();
            plot.rightMargin(d);
        } else if (string.equals("bottomMargin")) {
            if (!scanner.hasNextDouble()) {
                Speedup.error("Missing bottom margin value", n);
            }
            double d = scanner.nextDouble();
            plot.bottomMargin(d);
        } else if (string.equals("xAxisStart")) {
            if (!scanner.hasNextDouble()) {
                Speedup.error("Missing X axis start value", n);
            }
            double d = scanner.nextDouble();
            plot.xAxisStart(d);
        } else if (string.equals("xAxisEnd")) {
            if (!scanner.hasNextDouble()) {
                Speedup.error("Missing X axis end value", n);
            }
            double d = scanner.nextDouble();
            plot.xAxisEnd(d);
        } else if (string.equals("xAxisMajorDivisions")) {
            if (!scanner.hasNextInt()) {
                Speedup.error("Missing X axis major divisions value", n);
            }
            int n2 = scanner.nextInt();
            plot.xAxisMajorDivisions(n2);
        } else if (string.equals("xAxisMinorDivisions")) {
            if (!scanner.hasNextInt()) {
                Speedup.error("Missing X axis minor divisions value", n);
            }
            int n3 = scanner.nextInt();
            plot.xAxisMinorDivisions(n3);
        } else if (string.equals("xAxisLength")) {
            if (!scanner.hasNextDouble()) {
                Speedup.error("Missing X axis length value", n);
            }
            double d = scanner.nextDouble();
            plot.xAxisLength(d);
        } else if (string.equals("xAxisTitle")) {
            String string3 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string3 == null) {
                Speedup.error("Missing quoted X axis title", n);
            }
            string3 = string3.substring(1, string3.length() - 1);
            plot.xAxisTitle(string3);
        } else if (string.equals("yAxisStart")) {
            if (!scanner.hasNextDouble()) {
                Speedup.error("Missing Y axis start value", n);
            }
            double d = scanner.nextDouble();
            plot.yAxisStart(d);
        } else if (string.equals("yAxisEnd")) {
            if (!scanner.hasNextDouble()) {
                Speedup.error("Missing Y axis end value", n);
            }
            double d = scanner.nextDouble();
            plot.yAxisEnd(d);
        } else if (string.equals("yAxisMajorDivisions")) {
            if (!scanner.hasNextInt()) {
                Speedup.error("Missing Y axis major divisions value", n);
            }
            int n4 = scanner.nextInt();
            plot.yAxisMajorDivisions(n4);
        } else if (string.equals("yAxisMinorDivisions")) {
            if (!scanner.hasNextInt()) {
                Speedup.error("Missing Y axis minor divisions value", n);
            }
            int n5 = scanner.nextInt();
            plot.yAxisMinorDivisions(n5);
        } else if (string.equals("yAxisTickFormat")) {
            String string4 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string4 == null) {
                Speedup.error("Missing quoted Y axis tick format", n);
            }
            string4 = string4.substring(1, string4.length() - 1);
            plot.yAxisTickFormat(new DecimalFormat(string4));
        } else if (string.equals("yAxisLength")) {
            if (!scanner.hasNextDouble()) {
                Speedup.error("Missing Y axis length value", n);
            }
            double d = scanner.nextDouble();
            plot.yAxisLength(d);
        } else if (string.equals("yAxisTitle")) {
            String string5 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string5 == null) {
                Speedup.error("Missing quoted Y axis title", n);
            }
            string5 = string5.substring(1, string5.length() - 1);
            plot.yAxisTitle(string5);
        } else if (string.equals("yAxisTitleOffset")) {
            if (!scanner.hasNextDouble()) {
                Speedup.error("Missing Y axis title offset value", n);
            }
            double d = scanner.nextDouble();
            plot.yAxisTitleOffset(d);
        } else {
            Speedup.error("Unknown plot attribute", n);
        }
    }

    private static Data getData(int n) {
        Data data = dataMap.get(n);
        if (data == null) {
            data = new Data(n);
            dataMap.put(n, data);
        }
        return data;
    }

    private static void validateData(Data data) {
        if (data.K_series.isEmpty()) {
            return;
        }
        if (data.T_par_1 == 0.0) {
            System.err.println("Error: n = " + data.n + ": No data for K = 1");
            System.exit(1);
        }
        double d = Double.NEGATIVE_INFINITY;
        for (double d2 : data.K_series) {
            if (d2 <= d) {
                System.err.println("Error: n = " + data.n + ": K values not in ascending order");
                System.exit(1);
            }
            d = d2;
        }
    }

    private static void error(String string, int n) {
        System.err.println("Error: line " + n + ": " + string);
        System.exit(1);
    }

    private static void usage() {
        System.err.println("Usage: java Speedup <inputfile>");
        System.exit(1);
    }

    private static class Data {
        public int n;
        public double T_seq;
        public double T_max_seq;
        public double Dev_seq;
        public double T_par_1;
        public ListSeries K_series = new ListSeries();
        public ListSeries T_series = new ListSeries();
        public ListSeries T_max_series = new ListSeries();
        public ListSeries Speedup_series = new ListSeries();
        public ListSeries Eff_series = new ListSeries();
        public ListSeries Dev_series = new ListSeries();
        public ListSeries K_series_2 = new ListSeries();
        public ListSeries EDSF_series_2 = new ListSeries();
        public double N;
        public String labelText;

        public Data(int n) {
            this.n = n;
            this.N = n;
            this.labelText = "N = " + n;
        }
    }
}

