/*
 * Decompiled with CFR 0.152.
 */
import edu.rit.numeric.Interpolation;
import edu.rit.numeric.ListXYSeries;
import edu.rit.numeric.plot.Dots;
import edu.rit.numeric.plot.Plot;
import java.awt.Color;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class Sizeup {
    private static Pattern QUOTED_STRING_PATTERN = Pattern.compile("\"[^\"]*\"");
    private static DecimalFormat FMT_0 = new DecimalFormat("0");
    private static DecimalFormat FMT_0E = new DecimalFormat("0E0");
    private static DecimalFormat FMT_1 = new DecimalFormat("0.0");
    private static DecimalFormat FMT_2 = new DecimalFormat("0.00");
    private static DecimalFormat FMT_3 = new DecimalFormat("0.000");
    private static Map<Integer, ListXYSeries> nvstMap = new TreeMap<Integer, ListXYSeries>();
    private static Map<Integer, Interpolation> interpolationMap = new TreeMap<Integer, Interpolation>();
    private static Map<Integer, Double> ntoNMap = new TreeMap<Integer, Double>();
    private static List<Double> tList = new ArrayList<Double>();
    private static int K_max = Integer.MIN_VALUE;
    private static Plot NvsT_plot = new Plot();
    private static Plot N_plot = new Plot();
    private static Plot Sizeup_plot = new Plot();
    private static Plot SizeupEff_plot = new Plot();

    private Sizeup() {
    }

    public static void main(String[] stringArray) throws Exception {
        double d;
        Object object;
        if (stringArray.length != 1) {
            Sizeup.usage();
        }
        File file = new File(stringArray[0]);
        NvsT_plot.plotTitle("Problem Size vs. Running Time").leftMargin(42.0).minorGridLines(true).xAxisKind(Plot.LOGARITHMIC).xAxisMinorDivisions(10).xAxisTickScale(1000.0).xAxisTickFormat(FMT_0E).xAxisTitle("Running Time, <I>T</I> (sec)").yAxisKind(Plot.LOGARITHMIC).yAxisMinorDivisions(10).yAxisTickFormat(FMT_0E).yAxisTitle("Problem Size, <I>N</I>").yAxisTitleOffset(30.0).labelPosition(10).labelOffset(6.0);
        N_plot.plotTitle("Problem Size vs. Processors").leftMargin(42.0).minorGridLines(true).xAxisKind(Plot.LOGARITHMIC).xAxisMinorDivisions(10).xAxisTitle("Processors, <I>K</I>").yAxisKind(Plot.LOGARITHMIC).yAxisMinorDivisions(10).yAxisTickFormat(FMT_0E).yAxisTitle("<I>N</I> (<I>T,K</I>)").yAxisTitleOffset(30.0).labelPosition(5).labelOffset(6.0);
        Sizeup_plot.plotTitle("Sizeup vs. Processors").leftMargin(42.0).xAxisStart(0.0).xAxisTitle("Processors, <I>K</I>").yAxisStart(0.0).yAxisTickFormat(FMT_0).yAxisTitle("<I>Sizeup</I> (<I>T,K</I>)").yAxisTitleOffset(30.0).labelPosition(5).labelOffset(6.0);
        SizeupEff_plot.plotTitle("Sizeup Efficiency vs. Processors").leftMargin(42.0).xAxisStart(0.0).xAxisTitle("Processors, <I>K</I>").yAxisStart(0.0).yAxisTickFormat(FMT_1).yAxisTitle("<I>SizeupEff</I> (<I>T,K</I>)").yAxisTitleOffset(30.0).labelPosition(5).labelOffset(6.0);
        Scanner scanner = new Scanner(file);
        int n = 1;
        while (scanner.hasNextLine()) {
            object = scanner.nextLine();
            int n2 = ((String)object).indexOf(35);
            if (n2 >= 0) {
                object = ((String)object).substring(0, n2);
            }
            if (((String)(object = ((String)object).trim())).length() > 0) {
                Sizeup.parseLine((String)object, n);
            }
            ++n;
        }
        Sizeup_plot.seriesDots(null).seriesPaint(new Color(0.7f, 0.7f, 0.7f)).xySeries(new double[]{0.0, K_max}, new double[]{0.0, K_max}).seriesDots(Dots.circle(5.0)).seriesPaint(Color.black);
        SizeupEff_plot.seriesDots(null).seriesPaint(new Color(0.7f, 0.7f, 0.7f)).xySeries(new double[]{0.0, K_max}, new double[]{1.0, 1.0}).seriesDots(Dots.circle(5.0)).seriesPaint(Color.black);
        System.out.println("K\tT\tN");
        for (Map.Entry entry : nvstMap.entrySet()) {
            System.out.println();
            Integer n3 = (Integer)entry.getKey();
            String string = n3 == 0 ? "seq" : n3.toString();
            ListXYSeries listXYSeries = (ListXYSeries)entry.getValue();
            ListXYSeries listXYSeries2 = new ListXYSeries();
            for (int i = 0; i < listXYSeries.length(); ++i) {
                d = listXYSeries.x(i);
                int n4 = (int)listXYSeries.y(i);
                Double d2 = ntoNMap.get(n4);
                if (d2 == null) {
                    listXYSeries2.add(d, (double)n4);
                    System.out.println(string + "\t" + FMT_0.format(d) + "\t" + n4);
                    continue;
                }
                listXYSeries2.add(d, (double)d2);
                System.out.println(string + "\t" + FMT_0.format(d) + "\t" + FMT_0.format(d2));
            }
            if (n3 >= 1) {
                NvsT_plot.xySeries(listXYSeries2).label("<I>K</I> = " + n3, listXYSeries2.x(listXYSeries2.length() - 1), listXYSeries2.y(listXYSeries2.length() - 1));
            }
            interpolationMap.put(n3, new Interpolation(listXYSeries2));
        }
        System.out.println();
        System.out.println("T\tK\tN\tSizeup\tSzEff");
        object = tList.iterator();
        while (object.hasNext()) {
            double d3 = object.next();
            System.out.println();
            double d4 = 0.0;
            double d5 = 0.0;
            d = 0.0;
            double d6 = 0.0;
            ListXYSeries listXYSeries = new ListXYSeries();
            ListXYSeries listXYSeries3 = new ListXYSeries();
            ListXYSeries listXYSeries4 = new ListXYSeries();
            for (int i = 0; i <= K_max; ++i) {
                Interpolation interpolation = interpolationMap.get(i);
                if (interpolation == null) continue;
                if (i == 0) {
                    d5 = d4 = interpolation.f(d3);
                    System.out.println(FMT_0.format(d3) + "\t" + i + "\t" + FMT_0.format(d4) + "\t\t");
                    continue;
                }
                d4 = interpolation.f(d3);
                if (d5 == 0.0 && i == 1) {
                    d5 = d4;
                }
                d = d4 / d5;
                d6 = d / (double)i;
                listXYSeries.add((double)i, d4);
                listXYSeries3.add((double)i, d);
                listXYSeries4.add((double)i, d6);
                System.out.println(FMT_0.format(d3) + "\t" + i + "\t" + FMT_0.format(d4) + "\t" + FMT_3.format(d) + "\t" + FMT_3.format(d6));
            }
            N_plot.xySeries(listXYSeries).label("<I>T</I> = " + FMT_0.format(d3 / 1000.0) + " sec", listXYSeries.x(listXYSeries.length() - 1), listXYSeries.y(listXYSeries.length() - 1));
            Sizeup_plot.xySeries(listXYSeries3).label("<I>T</I> = " + FMT_0.format(d3 / 1000.0) + " sec", listXYSeries3.x(listXYSeries3.length() - 1), listXYSeries3.y(listXYSeries3.length() - 1));
            SizeupEff_plot.xySeries(listXYSeries4).label("<I>T</I> = " + FMT_0.format(d3 / 1000.0) + " sec", listXYSeries4.x(listXYSeries4.length() - 1), listXYSeries4.y(listXYSeries4.length() - 1));
        }
        NvsT_plot.display();
        N_plot.display();
        Sizeup_plot.display();
        SizeupEff_plot.display();
    }

    private static void parseLine(String string, int n) {
        Scanner scanner = new Scanner(string);
        if (scanner.hasNextInt()) {
            ListXYSeries listXYSeries;
            int n2;
            int n3 = scanner.nextInt();
            if (!scanner.hasNextInt()) {
                Sizeup.error("K invalid", n);
            }
            if ((n2 = scanner.nextInt()) < 0) {
                Sizeup.error("K < 0", n);
            }
            K_max = Math.max(K_max, n2);
            double d = Double.POSITIVE_INFINITY;
            while (scanner.hasNextLong()) {
                double d2 = scanner.nextLong();
                if (d2 <= 0.0) {
                    Sizeup.error("T invalid", n);
                }
                d = Math.min(d, d2);
            }
            if (d == Double.POSITIVE_INFINITY) {
                Sizeup.error("T values missing", n);
            }
            if ((listXYSeries = nvstMap.get(n2)) == null) {
                listXYSeries = new ListXYSeries();
                nvstMap.put(n2, listXYSeries);
            }
            listXYSeries.add(d, (double)n3);
        } else {
            String string2 = scanner.next();
            if (string2.equals("n")) {
                if (!scanner.hasNextInt()) {
                    Sizeup.error("Missing n value", n);
                }
                int n4 = scanner.nextInt();
                if (!scanner.hasNextDouble()) {
                    Sizeup.error("Missing N value", n);
                }
                double d = scanner.nextDouble();
                ntoNMap.put(n4, d);
            } else if (string2.equals("T")) {
                if (!scanner.hasNextLong()) {
                    Sizeup.error("Missing T value", n);
                }
                long l = scanner.nextLong();
                tList.add(Double.valueOf(l));
            } else if (string2.equals("nvst")) {
                Sizeup.parsePlotSpecification(NvsT_plot, scanner, n);
            } else if (string2.equals("size")) {
                Sizeup.parsePlotSpecification(N_plot, scanner, n);
            } else if (string2.equals("sizeup")) {
                Sizeup.parsePlotSpecification(Sizeup_plot, scanner, n);
            } else if (string2.equals("sizeupeff")) {
                Sizeup.parsePlotSpecification(SizeupEff_plot, scanner, n);
            } else {
                Sizeup.error("Unknown command", n);
            }
        }
    }

    private static void parsePlotSpecification(Plot plot, Scanner scanner, int n) {
        String string;
        if (!scanner.hasNext()) {
            Sizeup.error("Missing plot attribute", n);
        }
        if ((string = scanner.next()).equals("plotTitle")) {
            String string2 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string2 == null) {
                Sizeup.error("Missing quoted plot title", n);
            }
            string2 = string2.substring(1, string2.length() - 1);
            plot.plotTitle(string2);
        } else if (string.equals("margins")) {
            if (!scanner.hasNextDouble()) {
                Sizeup.error("Missing margins value", n);
            }
            double d = scanner.nextDouble();
            plot.margins(d);
        } else if (string.equals("leftMargin")) {
            if (!scanner.hasNextDouble()) {
                Sizeup.error("Missing left margin value", n);
            }
            double d = scanner.nextDouble();
            plot.leftMargin(d);
        } else if (string.equals("topMargin")) {
            if (!scanner.hasNextDouble()) {
                Sizeup.error("Missing top margin value", n);
            }
            double d = scanner.nextDouble();
            plot.topMargin(d);
        } else if (string.equals("rightMargin")) {
            if (!scanner.hasNextDouble()) {
                Sizeup.error("Missing right margin value", n);
            }
            double d = scanner.nextDouble();
            plot.rightMargin(d);
        } else if (string.equals("bottomMargin")) {
            if (!scanner.hasNextDouble()) {
                Sizeup.error("Missing bottom margin value", n);
            }
            double d = scanner.nextDouble();
            plot.bottomMargin(d);
        } else if (string.equals("xAxisStart")) {
            if (!scanner.hasNextDouble()) {
                Sizeup.error("Missing X axis start value", n);
            }
            double d = scanner.nextDouble();
            plot.xAxisStart(d);
        } else if (string.equals("xAxisEnd")) {
            if (!scanner.hasNextDouble()) {
                Sizeup.error("Missing X axis end value", n);
            }
            double d = scanner.nextDouble();
            plot.xAxisEnd(d);
        } else if (string.equals("xAxisMajorDivisions")) {
            if (!scanner.hasNextInt()) {
                Sizeup.error("Missing X axis major divisions value", n);
            }
            int n2 = scanner.nextInt();
            plot.xAxisMajorDivisions(n2);
        } else if (string.equals("xAxisMinorDivisions")) {
            if (!scanner.hasNextInt()) {
                Sizeup.error("Missing X axis minor divisions value", n);
            }
            int n3 = scanner.nextInt();
            plot.xAxisMinorDivisions(n3);
        } else if (string.equals("xAxisLength")) {
            if (!scanner.hasNextDouble()) {
                Sizeup.error("Missing X axis length value", n);
            }
            double d = scanner.nextDouble();
            plot.xAxisLength(d);
        } else if (string.equals("xAxisTitle")) {
            String string3 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string3 == null) {
                Sizeup.error("Missing quoted X axis title", n);
            }
            string3 = string3.substring(1, string3.length() - 1);
            plot.xAxisTitle(string3);
        } else if (string.equals("yAxisStart")) {
            if (!scanner.hasNextDouble()) {
                Sizeup.error("Missing Y axis start value", n);
            }
            double d = scanner.nextDouble();
            plot.yAxisStart(d);
        } else if (string.equals("yAxisEnd")) {
            if (!scanner.hasNextDouble()) {
                Sizeup.error("Missing Y axis end value", n);
            }
            double d = scanner.nextDouble();
            plot.yAxisEnd(d);
        } else if (string.equals("yAxisMajorDivisions")) {
            if (!scanner.hasNextInt()) {
                Sizeup.error("Missing Y axis major divisions value", n);
            }
            int n4 = scanner.nextInt();
            plot.yAxisMajorDivisions(n4);
        } else if (string.equals("yAxisMinorDivisions")) {
            if (!scanner.hasNextInt()) {
                Sizeup.error("Missing Y axis minor divisions value", n);
            }
            int n5 = scanner.nextInt();
            plot.yAxisMinorDivisions(n5);
        } else if (string.equals("yAxisTickFormat")) {
            String string4 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string4 == null) {
                Sizeup.error("Missing quoted Y axis tick format", n);
            }
            string4 = string4.substring(1, string4.length() - 1);
            plot.yAxisTickFormat(new DecimalFormat(string4));
        } else if (string.equals("yAxisLength")) {
            if (!scanner.hasNextDouble()) {
                Sizeup.error("Missing Y axis length value", n);
            }
            double d = scanner.nextDouble();
            plot.yAxisLength(d);
        } else if (string.equals("yAxisTitle")) {
            String string5 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string5 == null) {
                Sizeup.error("Missing quoted Y axis title", n);
            }
            string5 = string5.substring(1, string5.length() - 1);
            plot.yAxisTitle(string5);
        } else if (string.equals("yAxisTitleOffset")) {
            if (!scanner.hasNextDouble()) {
                Sizeup.error("Missing Y axis title offset value", n);
            }
            double d = scanner.nextDouble();
            plot.yAxisTitleOffset(d);
        } else {
            Sizeup.error("Unknown plot attribute", n);
        }
    }

    private static void error(String string, int n) {
        System.err.println("Error: line " + n + ": " + string);
        System.exit(1);
    }

    private static void usage() {
        System.err.println("Usage: java Sizeup <inputfile>");
        System.exit(1);
    }
}

