/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.util;

import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;

public class ICBStringUtils {
    private static final String HTML_AMP = "&amp;";
    private static final String HTML_SINGLE_QUOTE = "&apos;";
    private static final String HTML_DOUBLE_QUOTE = "&quot;";
    private static final String HTML_LESS_THAN = "&lt;";
    private static final String HTML_GREATER_THAN = "&gt;";
    private static final String XML_NEWLINE = "&#10;";
    private static final String XML_CR = "&#13;";

    private ICBStringUtils() {
    }

    public static String stripExtraSpaces(String x) {
        if (x == null || x.length() == 0) {
            return x;
        }
        return x.replaceAll("\t", " ").replaceAll(" {2,}", " ").trim();
    }

    public static String htmlFix(String inval) {
        if (StringUtils.isEmpty((String)inval)) {
            return "";
        }
        String outval = StringUtils.replace((String)inval, (String)"&", (String)HTML_AMP);
        outval = StringUtils.replace((String)outval, (String)"'", (String)HTML_SINGLE_QUOTE);
        outval = StringUtils.replace((String)outval, (String)"\"", (String)HTML_DOUBLE_QUOTE);
        outval = StringUtils.replace((String)outval, (String)"<", (String)HTML_LESS_THAN);
        outval = StringUtils.replace((String)outval, (String)">", (String)HTML_GREATER_THAN);
        return outval;
    }

    public static String xmlFix(String inval) {
        if (StringUtils.isBlank((String)inval)) {
            return "";
        }
        String outval = StringUtils.replace((String)inval, (String)"&", (String)HTML_AMP);
        outval = StringUtils.replace((String)outval, (String)"\"", (String)HTML_DOUBLE_QUOTE);
        outval = StringUtils.replace((String)outval, (String)"<", (String)HTML_LESS_THAN);
        outval = StringUtils.replace((String)outval, (String)">", (String)HTML_GREATER_THAN);
        outval = StringUtils.replace((String)outval, (String)"\n", (String)XML_NEWLINE);
        outval = StringUtils.replace((String)outval, (String)"\r", (String)XML_CR);
        return outval;
    }

    public static String urlFix(String toEncode) {
        String outval = StringUtils.replace((String)toEncode, (String)"%", (String)"%25");
        outval = StringUtils.replace((String)outval, (String)"$", (String)"%24");
        outval = StringUtils.replace((String)outval, (String)"&", (String)"%26");
        outval = StringUtils.replace((String)outval, (String)"+", (String)"%2B");
        outval = StringUtils.replace((String)outval, (String)",", (String)"%2C");
        outval = StringUtils.replace((String)outval, (String)"/", (String)"%2F");
        outval = StringUtils.replace((String)outval, (String)":", (String)"%3A");
        outval = StringUtils.replace((String)outval, (String)";", (String)"%3B");
        outval = StringUtils.replace((String)outval, (String)"=", (String)"%3D");
        outval = StringUtils.replace((String)outval, (String)"?", (String)"%3F");
        outval = StringUtils.replace((String)outval, (String)"@", (String)"%40");
        outval = StringUtils.replace((String)outval, (String)" ", (String)"%20");
        outval = StringUtils.replace((String)outval, (String)"\"", (String)"%22");
        outval = StringUtils.replace((String)outval, (String)"<", (String)"%3C");
        outval = StringUtils.replace((String)outval, (String)">", (String)"%3E");
        outval = StringUtils.replace((String)outval, (String)"#", (String)"%23");
        outval = StringUtils.replace((String)outval, (String)"{", (String)"%7B");
        outval = StringUtils.replace((String)outval, (String)"}", (String)"%7D");
        outval = StringUtils.replace((String)outval, (String)"|", (String)"%7C");
        outval = StringUtils.replace((String)outval, (String)"\\", (String)"%5C");
        outval = StringUtils.replace((String)outval, (String)"^", (String)"%5E");
        outval = StringUtils.replace((String)outval, (String)"~", (String)"%7E");
        outval = StringUtils.replace((String)outval, (String)"[", (String)"%5B");
        outval = StringUtils.replace((String)outval, (String)"]", (String)"%5D");
        outval = StringUtils.replace((String)outval, (String)"`", (String)"%60");
        return outval;
    }

    public static String modifyFilename(String origFilename, String[] extensions, String mod) {
        if (StringUtils.isBlank((String)origFilename)) {
            return mod;
        }
        String foundExt = null;
        if (extensions != null) {
            for (String ext : extensions) {
                if (!origFilename.endsWith(ext)) continue;
                foundExt = ext;
                break;
            }
        }
        if (foundExt == null) {
            return origFilename + mod;
        }
        return origFilename.substring(0, origFilename.length() - foundExt.length()) + mod + foundExt;
    }

    public static String highlightString(String toHighlight, String highlightWord, String highlightStart, String highlightEnd) {
        String[] highlightWords = new String[]{highlightWord};
        return ICBStringUtils.highlightStrings(toHighlight, highlightWords, highlightStart, highlightEnd);
    }

    public static String highlightStrings(String toHighlight, String[] highlightWords, String highlightStart, String highlightEnd) {
        if (StringUtils.isBlank((String)toHighlight)) {
            return toHighlight;
        }
        String[] cleanHighlightWords = ICBStringUtils.cleanStringArray(highlightWords);
        if (cleanHighlightWords == null || cleanHighlightWords.length == 0) {
            return toHighlight;
        }
        for (int i = 0; i < cleanHighlightWords.length; ++i) {
            cleanHighlightWords[i] = cleanHighlightWords[i].toLowerCase();
        }
        if (StringUtils.isBlank((String)highlightStart) && StringUtils.isBlank((String)highlightEnd)) {
            return toHighlight;
        }
        StringBuilder input = new StringBuilder(toHighlight);
        StringBuilder inputLC = new StringBuilder(toHighlight.toLowerCase());
        StringBuilder output = new StringBuilder();
        StringBuilder tagStart = highlightStart == null ? new StringBuilder() : new StringBuilder(highlightStart);
        StringBuilder tagEnd = highlightEnd == null ? new StringBuilder() : new StringBuilder(highlightEnd);
        while (input.length() != 0) {
            int pos = -1;
            int size = -1;
            for (String toFind : cleanHighlightWords) {
                int curPos = inputLC.indexOf(toFind);
                if (curPos == -1) continue;
                if (pos == -1) {
                    pos = curPos;
                    size = toFind.length();
                    continue;
                }
                if (curPos >= pos) continue;
                pos = curPos;
                size = toFind.length();
            }
            if (pos == -1) {
                output.append((CharSequence)input);
                break;
            }
            assert (size > 0);
            if (pos > 0) {
                output.append(input.substring(0, pos));
            }
            output.append((CharSequence)tagStart);
            output.append(input.substring(pos, pos + size));
            output.append((CharSequence)tagEnd);
            input.delete(0, pos + size);
            inputLC.delete(0, pos + size);
        }
        return output.toString();
    }

    public static String[] cleanStringArray(String[] strings) {
        if (strings == null) {
            return null;
        }
        LinkedList<String> cleanList = new LinkedList<String>();
        for (String string : strings) {
            if (!StringUtils.isNotBlank((String)string)) continue;
            cleanList.add(string);
        }
        return cleanList.toArray(new String[cleanList.size()]);
    }

    public static String millis2hms(long t) {
        assert (t >= 0L);
        if (t < 1000L) {
            return t + "ms";
        }
        long s = t / 1000L % 60L;
        long m = t / 1000L / 60L % 60L;
        long h = t / 3600000L;
        if (h == 0L && m == 0L) {
            return s + "s";
        }
        if (h == 0L) {
            return m + "m " + s + "s";
        }
        return h + "h " + m + "m " + s + "s";
    }
}

