/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundedPriorityQueue<E>
extends PriorityQueue<E> {
    private int maxCapacity;
    private boolean removeFromFront;

    public BoundedPriorityQueue(int maxCapacity, Comparator<E> c, boolean removeFromFront) {
        super(maxCapacity + 1, c);
        this.maxCapacity = maxCapacity;
        this.removeFromFront = removeFromFront;
    }

    public BoundedPriorityQueue(int maxCapacity, Comparator<E> c) {
        this(maxCapacity, c, false);
    }

    public BoundedPriorityQueue(int maxCapacity, boolean removeFromFront) {
        super(maxCapacity);
        this.maxCapacity = maxCapacity;
        this.removeFromFront = removeFromFront;
    }

    public BoundedPriorityQueue(int maxCapacity) {
        this(maxCapacity, false);
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public boolean isRemoveFromFrontSize() {
        return this.removeFromFront;
    }

    public void setRemoveFromFrontSize(boolean removeFromFront) {
        this.removeFromFront = removeFromFront;
    }

    @Override
    public boolean add(E e) {
        boolean result = super.add(e);
        this.ensureSize();
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = super.addAll(c);
        this.ensureSize();
        return result;
    }

    @Override
    public boolean offer(E e) {
        boolean result = super.offer(e);
        this.ensureSize();
        return result;
    }

    public synchronized List<E> reversedList(boolean destructive) {
        int queueSize = this.size();
        LinkedList reverse = new LinkedList();
        for (int i = 0; i < queueSize; ++i) {
            Object current = this.poll();
            reverse.addFirst(current);
        }
        if (!destructive) {
            this.addAll(reverse);
        }
        return reverse;
    }

    private synchronized void ensureSize() {
        int size = this.size();
        if (size <= this.maxCapacity) {
            return;
        }
        if (this.removeFromFront) {
            for (int i = 0; i < size - this.maxCapacity; ++i) {
                this.poll();
            }
        } else {
            ArrayList transferQueue = new ArrayList(this.maxCapacity);
            for (int i = 0; i < this.maxCapacity; ++i) {
                transferQueue.add(this.poll());
            }
            this.clear();
            super.addAll(transferQueue);
        }
    }
}

