/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;

public final class TSVReader
implements Closeable {
    private final BufferedReader bufferedReader;
    private String currentLine;
    private String[] currentTokens;
    private int currentTokenIndex;
    private final String fieldSeparatorRegExp;

    public TSVReader(Reader reader) {
        this(reader, '\t');
    }

    public TSVReader(Reader reader, char delimiter) {
        this.bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.fieldSeparatorRegExp = "[" + delimiter + "]";
    }

    public boolean hasNext() throws IOException {
        if (this.currentLine != null) {
            return true;
        }
        this.currentLine = this.bufferedReader.readLine();
        if (this.currentLine == null) {
            this.currentTokens = null;
            return false;
        }
        return true;
    }

    public boolean isCommentLine() {
        return this.currentLine.startsWith("#");
    }

    public void skip() {
        this.currentTokenIndex = 0;
        this.currentLine = null;
    }

    public void next() {
        this.currentTokens = this.currentLine.split(this.fieldSeparatorRegExp);
        this.currentTokenIndex = 0;
        this.currentLine = null;
    }

    public int getInt() {
        this.ensureNextField();
        return Integer.parseInt(this.currentTokens[this.currentTokenIndex++]);
    }

    public float getFloat() {
        this.ensureNextField();
        return Float.parseFloat(this.currentTokens[this.currentTokenIndex++]);
    }

    public double getDouble() {
        this.ensureNextField();
        return Double.parseDouble(this.currentTokens[this.currentTokenIndex++]);
    }

    public String getString() {
        this.ensureNextField();
        return this.currentTokens[this.currentTokenIndex++];
    }

    private void ensureNextField() {
        if (this.currentTokens == null || this.currentTokenIndex >= this.currentTokens.length) {
            throw new NoSuchElementException();
        }
    }

    public int numTokens() {
        return this.currentTokens.length;
    }

    public boolean isEmptyLine() {
        return this.currentLine.trim().length() == 0;
    }

    public void close() throws IOException {
        this.bufferedReader.close();
        this.currentLine = null;
        this.currentTokens = null;
    }
}

