/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.utils;

import Jama.Matrix;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.ThreadLocalRandom;
import org.ejml.data.DenseMatrix64F;

public class MatrixOps {
    Random rnd = new Random();
    static DecimalFormat mydecimalFormat = new DecimalFormat("00.###E0");
    private static ForkJoinPool pool = new ForkJoinPool();
    private static String DEFAULT_TITLE = "Vector";
    public static int noDigits = 4;
    MatrixOp multiplyop = new MatrixOp(){

        @Override
        public double compute(double f1, double f2) {
            return f1 * f2;
        }
    };
    MatrixOp minusop = new MatrixOp(){

        @Override
        public double compute(double f1, double f2) {
            return f1 - f2;
        }
    };

    public static String arrToStr(int[] arr, String title) {
        String res = "";
        res = res + title + "[" + arr.length + "]:";
        for (int j = 0; j < arr.length; ++j) {
            res = res + arr[j] + ", ";
        }
        res = res + "\n";
        return res;
    }

    public static String arrToStr(double[] arr) {
        return MatrixOps.arrToStr(arr, DEFAULT_TITLE, Integer.MAX_VALUE);
    }

    public static String arrToStr(double[] arr, int maxLen) {
        return MatrixOps.arrToStr(arr, DEFAULT_TITLE, maxLen);
    }

    public static String arrToStr(double[] arr, String title) {
        return MatrixOps.arrToStr(arr, title, Integer.MAX_VALUE);
    }

    public static String arrToStr(double[] arr, String title, int maxLen) {
        String res = "";
        res = res + title + "[" + arr.length + "]:";
        for (int j = 0; j < arr.length && j < maxLen; ++j) {
            res = res + MatrixOps.formatDouble(arr[j]) + ", ";
        }
        return res;
    }

    public static String doubleArrayToPrintString(double[][] m) {
        return MatrixOps.doubleArrayToPrintString(m, ", ", Integer.MAX_VALUE, m.length, Integer.MAX_VALUE, "\n");
    }

    public static String doubleArrayToPrintString(double[][] m, int maxRows) {
        return MatrixOps.doubleArrayToPrintString(m, ", ", maxRows, maxRows, Integer.MAX_VALUE, "\n");
    }

    public static String doubleArrayToPrintString(double[][] m, String colDelimiter) {
        return MatrixOps.doubleArrayToPrintString(m, colDelimiter, Integer.MAX_VALUE, -1, Integer.MAX_VALUE, "\n");
    }

    public static String doubleArrayToPrintString(double[][] m, String colDelimiter, int toprowlim) {
        return MatrixOps.doubleArrayToPrintString(m, colDelimiter, toprowlim, -1, Integer.MAX_VALUE, "\n");
    }

    public static String doubleArrayToPrintString(double[][] m, int toprowlim, int btmrowlim) {
        return MatrixOps.doubleArrayToPrintString(m, ", ", toprowlim, btmrowlim, Integer.MAX_VALUE, "\n");
    }

    public static String doubleArrayToPrintString(double[][] m, int toprowlim, int btmrowlim, int collim) {
        return MatrixOps.doubleArrayToPrintString(m, ", ", toprowlim, btmrowlim, collim, "\n");
    }

    public static String doubleArrayToPrintString(double[][] m, String colDelimiter, int toprowlim, int btmrowlim) {
        return MatrixOps.doubleArrayToPrintString(m, colDelimiter, toprowlim, btmrowlim, Integer.MAX_VALUE, "\n");
    }

    public static String doubleArrayToPrintString(double[][] m, String colDelimiter, int toprowlim, int btmrowlim, int collim) {
        return MatrixOps.doubleArrayToPrintString(m, colDelimiter, toprowlim, btmrowlim, collim, "\n");
    }

    public static String doubleArrayToPrintString(double[][] m, String colDelimiter, int toprowlim, int btmrowlim, int collim, String sentenceDelimiter) {
        int j;
        String rowPref;
        int i;
        StringBuffer str = new StringBuffer(m.length * m[0].length);
        str.append("Dim:" + m.length + " x " + m[0].length + "\n");
        for (i = 0; i < m.length && i < toprowlim; ++i) {
            rowPref = i < 1000 ? String.format("%03d", i) : String.format("%04d", i);
            str.append(rowPref + ": [");
            for (j = 0; j < m[i].length - 1 && j < collim; ++j) {
                String formatted = MatrixOps.formatDouble(m[i][j]);
                str = str.append(formatted);
                str = str.append(colDelimiter);
            }
            str = str.append(MatrixOps.formatDouble(m[i][m[i].length - 1]));
            if (collim == Integer.MAX_VALUE) {
                str.append("]");
            } else {
                str.append("...]");
            }
            if (i >= m.length - 1) continue;
            str = str.append(sentenceDelimiter);
        }
        if (btmrowlim < 0) {
            return str.toString();
        }
        while (i < m.length - btmrowlim) {
            ++i;
        }
        if (i < m.length) {
            str.append("\t.\n\t.\n\t.\n");
        }
        while (i < m.length) {
            rowPref = i < 1000 ? String.format("%03d", i) : String.format("%04d", i);
            str.append(rowPref + ": [");
            for (j = 0; j < m[i].length - 1 && j < collim; ++j) {
                str = str.append(MatrixOps.formatDouble(m[i][j]));
                str = str.append(colDelimiter);
            }
            str = str.append(MatrixOps.formatDouble(m[i][m[i].length - 1]));
            if (collim > m[i].length) {
                str.append("]");
            } else {
                str.append(", ...]");
            }
            if (i < m.length - 1) {
                str = str.append(sentenceDelimiter);
            }
            ++i;
        }
        return str.toString();
    }

    public static String formatDouble(double d) {
        if (d == 0.0) {
            return "<0.0>";
        }
        if (d < 1.0E-4 && d > 0.0 || d > -1.0E-4 && d < 0.0) {
            return mydecimalFormat.format(d);
        }
        String formatString = "%." + noDigits + "f";
        return String.format(formatString, d);
    }

    public static String doubleArrayToString(double[][] m) {
        return MatrixOps.doubleArrayToString(m, ",");
    }

    public static String doubleArrayToString(double[][] m, String colDelimiter) {
        StringBuffer str = new StringBuffer(m.length * m[0].length);
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length - 1; ++j) {
                str = str.append(Double.toString(m[i][j]));
                str = str.append(colDelimiter);
            }
            str = str.append(Double.toString(m[i][m[i].length - 1]));
            str = str.append("\n");
        }
        return str.toString();
    }

    public static double[] rep(double val, int times) {
        double[] res = new double[times];
        for (int i = 0; i < res.length; ++i) {
            res[i] = val;
        }
        return res;
    }

    public static double[] asVector(double[][] matrix) {
        int n;
        boolean isCol = matrix.length != 1;
        int n2 = n = matrix.length == 1 ? matrix[0].length : matrix.length;
        if (matrix.length != 1 && matrix[0].length != 1) {
            throw new IllegalArgumentException("Cannot convert non-row or col matrix to vactor! Matrix dim: " + matrix.length + "x" + matrix[0].length);
        }
        double[] res = new double[n];
        if (isCol) {
            for (int j = 0; j < matrix.length; ++j) {
                res[j] = matrix[j][0];
            }
        } else {
            for (int j = 0; j < matrix[0].length; ++j) {
                res[j] = matrix[0][j];
            }
        }
        return res;
    }

    public static double[][] centerAndScaleGlobal(double[][] matrix) {
        double[][] res = new double[matrix.length][matrix[0].length];
        double mean = MatrixOps.mean(matrix);
        double std = MatrixOps.stdev(matrix);
        for (int i = 0; i < res.length; ++i) {
            for (int j = 0; j < res[i].length; ++j) {
                res[i][j] = (matrix[i][j] - mean) / std;
            }
        }
        return res;
    }

    public static double[][] centerAndScale(double[][] matrix) {
        double[][] res = new double[matrix.length][matrix[0].length];
        double[] means = MatrixOps.colMeans(matrix);
        for (int i = 0; i < res.length; ++i) {
            for (int j = 0; j < res[i].length; ++j) {
                res[i][j] = matrix[i][j] - means[j];
            }
        }
        double[] std = MatrixOps.colStddev(res);
        for (int i = 0; i < res.length; ++i) {
            for (int j = 0; j < res[i].length; ++j) {
                res[i][j] = res[i][j] / (std[j] == 0.0 ? 1.0 : std[j]);
            }
        }
        return res;
    }

    public static double[][] centerAndScaleSametime(double[][] matrix) {
        double[][] res = new double[matrix.length][matrix[0].length];
        double[] means = MatrixOps.colMeans(matrix);
        double[] std = MatrixOps.colStddev(matrix);
        for (int i = 0; i < res.length; ++i) {
            for (int j = 0; j < res[i].length; ++j) {
                res[i][j] = (matrix[i][j] - means[j]) / (std[j] == 0.0 ? 1.0 : std[j]);
            }
        }
        return res;
    }

    public static double[][] addNoise(double[][] matrix) {
        double[][] res = new double[matrix.length][matrix[0].length];
        double[] std = MatrixOps.colStddev(matrix);
        for (int i = 0; i < res.length; ++i) {
            for (int j = 0; j < res[i].length; ++j) {
                double noise = MatrixOps.rnorm(0.0, std[j] == 0.0 ? 1.0E-5 : std[j] / 5.0);
                res[i][j] = matrix[i][j] + noise;
            }
        }
        return res;
    }

    public static double[][] transposeSerial(double[][] matrix) {
        int rows = matrix.length;
        int cols = matrix[0].length;
        double[][] transpose = new double[cols][rows];
        for (int col = 0; col < cols; ++col) {
            for (int row = 0; row < rows; ++row) {
                transpose[col][row] = matrix[row][col];
            }
        }
        return transpose;
    }

    public double[][] transpose(double[][] matrix) {
        return this.transpose(matrix, 1000);
    }

    public double[][] transpose(double[][] matrix, int ll) {
        int cols = matrix[0].length;
        int rows = matrix.length;
        double[][] transpose = new double[cols][rows];
        if (rows < 100) {
            for (int i = 0; i < cols; ++i) {
                for (int j = 0; j < rows; ++j) {
                    transpose[i][j] = matrix[j][i];
                }
            }
        } else {
            MatrixTransposer process = new MatrixTransposer(matrix, transpose, 0, rows, ll);
            pool.invoke(process);
        }
        return transpose;
    }

    public static double[][] exp(double[][] m1) {
        double[][] matrix = new double[m1.length][m1[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                matrix[i][j] = Math.exp(m1[i][j]);
            }
        }
        return matrix;
    }

    public static double[] sqrt(double[] v1) {
        double[] vector = new double[v1.length];
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = Math.sqrt(v1[i]);
        }
        return vector;
    }

    public static double mean(double[] vector) {
        double sum = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            sum += vector[i];
        }
        return sum / (double)vector.length;
    }

    public static double[][] log(double[][] m1) {
        double[][] matrix = new double[m1.length][m1[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                matrix[i][j] = Math.log(m1[i][j]);
            }
        }
        return matrix;
    }

    public static double[][] pow(double[][] m1, double power) {
        double[][] matrix = new double[m1.length][m1[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                matrix[i][j] = Math.pow(m1[i][j], power);
            }
        }
        return matrix;
    }

    public static double[] pow(double[] m1, double power) {
        double[] matrix = new double[m1.length];
        for (int i = 0; i < matrix.length; ++i) {
            matrix[i] = Math.pow(m1[i], power);
        }
        return matrix;
    }

    public static double[][] log(double[][] m1, boolean infAsZero) {
        double[][] matrix = new double[m1.length][m1[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                matrix[i][j] = Math.log(m1[i][j]);
                if (!infAsZero || !Double.isInfinite(matrix[i][j])) continue;
                matrix[i][j] = 0.0;
            }
        }
        return matrix;
    }

    public static double[][] scalarInverse(double[][] m1) {
        double[][] matrix = new double[m1.length][m1[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                matrix[i][j] = 1.0 / m1[i][j];
            }
        }
        return matrix;
    }

    public static double[] scalarInverse(double[] v1) {
        double[] vector = new double[v1.length];
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = 1.0 / v1[i];
        }
        return vector;
    }

    public static double[][] rnorm(int m, int n) {
        double[][] array = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                array[i][j] = MatrixOps.rnorm(0.0, 1.0);
            }
        }
        return array;
    }

    public static double[] rnorm(int n, double[] mus, double[] sigmas) {
        double[] res = new double[n];
        for (int i = 0; i < res.length; ++i) {
            res[i] = mus[i] + ThreadLocalRandom.current().nextGaussian() * sigmas[i];
        }
        return res;
    }

    public static double[] rnorm(int n, double mu, double[] sigmas) {
        double[] res = new double[n];
        for (int i = 0; i < res.length; ++i) {
            res[i] = mu + ThreadLocalRandom.current().nextGaussian() * sigmas[i];
        }
        return res;
    }

    public static double rnorm() {
        return ThreadLocalRandom.current().nextGaussian();
    }

    public static double rnorm(double mu, double sigma) {
        return mu + ThreadLocalRandom.current().nextGaussian() * sigma;
    }

    public static boolean[][] equal(double[][] matrix1, double[][] matrix2) {
        boolean[][] equals = new boolean[matrix1.length][matrix1[0].length];
        if (matrix1.length != matrix2.length) {
            throw new IllegalArgumentException("Dimensions does not match");
        }
        if (matrix1[0].length != matrix2[0].length) {
            throw new IllegalArgumentException("Dimensions does not match");
        }
        for (int i = 0; i < matrix1.length; ++i) {
            for (int j = 0; j < matrix1[0].length; ++j) {
                equals[i][j] = Double.compare(matrix1[i][j], matrix2[i][j]) == 0;
            }
        }
        return equals;
    }

    public static boolean[][] equal(boolean[][] matrix1, boolean[][] matrix2) {
        boolean[][] equals = new boolean[matrix1.length][matrix1[0].length];
        if (matrix1.length != matrix2.length) {
            throw new IllegalArgumentException("Dimensions does not match");
        }
        if (matrix1[0].length != matrix2[0].length) {
            throw new IllegalArgumentException("Dimensions does not match");
        }
        for (int i = 0; i < matrix1.length; ++i) {
            for (int j = 0; j < matrix1[0].length; ++j) {
                equals[i][j] = matrix1[i][j] == matrix2[i][j];
            }
        }
        return equals;
    }

    public static boolean[][] biggerThan(double[][] matrix, double value) {
        boolean[][] equals = new boolean[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                equals[i][j] = Double.compare(matrix[i][j], value) == 1;
            }
        }
        return equals;
    }

    public static boolean[][] negate(boolean[][] booleans) {
        boolean[][] negates = new boolean[booleans.length][booleans[0].length];
        for (int i = 0; i < booleans.length; ++i) {
            for (int j = 0; j < booleans[0].length; ++j) {
                negates[i][j] = !booleans[i][j];
            }
        }
        return negates;
    }

    public static double[][] abs(boolean[][] booleans) {
        double[][] absolutes = new double[booleans.length][booleans[0].length];
        for (int i = 0; i < booleans.length; ++i) {
            for (int j = 0; j < booleans[0].length; ++j) {
                absolutes[i][j] = booleans[i][j] ? 1.0 : 0.0;
            }
        }
        return absolutes;
    }

    public static double[][] abs(double[][] vals) {
        double[][] absolutes = new double[vals.length][vals[0].length];
        for (int i = 0; i < vals.length; ++i) {
            for (int j = 0; j < vals[0].length; ++j) {
                absolutes[i][j] = Math.abs(vals[i][j]);
            }
        }
        return absolutes;
    }

    public static double[] abs(double[] vals) {
        double[] absolutes = new double[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            absolutes[i] = Math.abs(vals[i]);
        }
        return absolutes;
    }

    public static double[][] sign(double[][] matrix) {
        double[][] signs = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                signs[i][j] = matrix[i][j] >= 0.0 ? 1.0 : -1.0;
            }
        }
        return signs;
    }

    public static double mean(double[][] matrix) {
        return MatrixOps.mean(matrix, 2)[0][0];
    }

    public static double[][] mean(double[][] matrix, int axis) {
        double[][] result;
        if (axis == 0) {
            result = new double[1][matrix[0].length];
            for (int j = 0; j < matrix[0].length; ++j) {
                double colsum = 0.0;
                for (int i = 0; i < matrix.length; ++i) {
                    colsum += matrix[i][j];
                }
                result[0][j] = colsum / (double)matrix.length;
            }
        } else if (axis == 1) {
            result = new double[matrix.length][1];
            for (int i = 0; i < matrix.length; ++i) {
                double rowsum = 0.0;
                for (int j = 0; j < matrix[0].length; ++j) {
                    rowsum += matrix[i][j];
                }
                result[i][0] = rowsum / (double)matrix[0].length;
            }
        } else if (axis == 2) {
            result = new double[1][1];
            for (int j = 0; j < matrix[0].length; ++j) {
                for (int i = 0; i < matrix.length; ++i) {
                    double[] dArray = result[0];
                    dArray[0] = dArray[0] + matrix[i][j];
                }
            }
            double[] dArray = result[0];
            dArray[0] = dArray[0] / (double)(matrix[0].length * matrix.length);
        } else {
            throw new IllegalArgumentException("Axes other than 0,1,2 is unsupported");
        }
        return result;
    }

    public static double[][] sum(double[][] matrix, int axis) {
        double[][] result;
        if (axis == 0) {
            result = new double[1][matrix[0].length];
            for (int j = 0; j < matrix[0].length; ++j) {
                double rowsum = 0.0;
                for (int i = 0; i < matrix.length; ++i) {
                    rowsum += matrix[i][j];
                }
                result[0][j] = rowsum;
            }
        } else if (axis == 1) {
            result = new double[matrix.length][1];
            for (int i = 0; i < matrix.length; ++i) {
                double colsum = 0.0;
                for (int j = 0; j < matrix[0].length; ++j) {
                    colsum += matrix[i][j];
                }
                result[i][0] = colsum;
            }
        } else {
            throw new IllegalArgumentException("Axes other than 0,1 is unsupported");
        }
        return result;
    }

    public double sumPar(double[][] matrix) {
        int ll = 100;
        int cols = matrix[0].length;
        int rows = matrix.length;
        double[] sums = new double[rows];
        if (rows < ll) {
            for (int row = 0; row < rows; ++row) {
                for (int col = 0; col < cols; ++col) {
                    int n = row;
                    sums[n] = sums[n] + matrix[row][col];
                }
            }
        } else {
            MatrixSummer process = new MatrixSummer(matrix, sums, 0, rows, ll);
            pool.invoke(process);
        }
        double sum = 0.0;
        for (int i = 0; i < sums.length; ++i) {
            sum += sums[i];
        }
        return sum;
    }

    public static double sum(double[][] matrix) {
        double sum = 0.0;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                sum += matrix[i][j];
            }
        }
        return sum;
    }

    public static double sum(double[] vector) {
        double res = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            res += vector[i];
        }
        return res;
    }

    public static double[][] maximum(double[][] matrix, double maxval) {
        double[][] maxed = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                maxed[i][j] = matrix[i][j] > maxval ? matrix[i][j] : maxval;
            }
        }
        return maxed;
    }

    public static void assignAllLessThan(double[][] matrix, double lessthan, double assign) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                if (!(matrix[i][j] < lessthan)) continue;
                matrix[i][j] = assign;
            }
        }
    }

    public static double[][] square(double[][] matrix) {
        return MatrixOps.scalarPow(matrix, 2.0);
    }

    public static double[][] replaceNaN(double[][] matrix, double repl) {
        double[][] result = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                result[i][j] = Double.isNaN(matrix[i][j]) ? repl : matrix[i][j];
            }
        }
        return result;
    }

    public static double[][] replaceInf(double[][] matrix, double repl) {
        double[][] result = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                result[i][j] = Double.isInfinite(matrix[i][j]) ? repl : matrix[i][j];
            }
        }
        return result;
    }

    public static double[][] scalarPow(double[][] matrix, double power) {
        double[][] result = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                double[] dArray = result[i];
                int n = j;
                dArray[n] = dArray[n] + Math.pow(matrix[i][j], power);
            }
        }
        return result;
    }

    public static double[][] addColumnVector(double[][] matrix, double[][] colvector) {
        double[][] result = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                result[i][j] = matrix[i][j] + colvector[i][0];
            }
        }
        return result;
    }

    public static double[][] addRowVector(double[][] matrix, double[][] rowvector) {
        double[][] result = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                result[i][j] = matrix[i][j] + rowvector[0][j];
            }
        }
        return result;
    }

    public static double[][] fillWithRowOld(double[][] matrix, int row) {
        double[][] result = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                result[i][j] = matrix[row][j];
            }
        }
        return result;
    }

    public static double[][] fillWithRow(double[][] matrix, int row) {
        int rows = matrix.length;
        int cols = matrix[0].length;
        double[][] result = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(matrix[row], 0, result[i], 0, cols);
        }
        return result;
    }

    public static double[][] tile(double[][] matrix, int rowtimes, int coltimes) {
        double[][] result = new double[matrix.length * rowtimes][matrix[0].length * coltimes];
        int resultrow = 0;
        for (int i = 0; i < rowtimes; ++i) {
            for (int j = 0; j < matrix.length; ++j) {
                int resultcol = 0;
                for (int k = 0; k < coltimes; ++k) {
                    for (int l = 0; l < matrix[0].length; ++l) {
                        result[resultrow][resultcol++] = matrix[j][l];
                    }
                }
                ++resultrow;
            }
        }
        return result;
    }

    public static double[][] normalize(double[][] x, double[] meanX, double[] stdevX) {
        double[][] y = new double[x.length][x[0].length];
        for (int i = 0; i < y.length; ++i) {
            for (int j = 0; j < y[i].length; ++j) {
                y[i][j] = (x[i][j] - meanX[j]) / stdevX[j];
            }
        }
        return y;
    }

    public static int[] range(int n) {
        int[] result = new int[n];
        for (int i = 0; i < n; ++i) {
            result[i] = i;
        }
        return result;
    }

    public static int[] range(int a, int b) {
        if (b < a) {
            throw new IllegalArgumentException("b has to be larger than a");
        }
        int val = a;
        int[] result = new int[b - a];
        for (int i = 0; i < b - a; ++i) {
            result[i] = val++;
        }
        return result;
    }

    public static int[] concatenate(int[] v1, int[] v2) {
        int[] result = new int[v1.length + v2.length];
        int index = 0;
        int i = 0;
        while (i < v1.length) {
            result[index] = v1[index];
            ++i;
            ++index;
        }
        i = 0;
        while (i < v2.length) {
            result[index] = v2[i];
            ++i;
            ++index;
        }
        return result;
    }

    public static double[] concatenate(double[] v1, double[] v2) {
        double[] result = new double[v1.length + v2.length];
        int index = 0;
        int i = 0;
        while (i < v1.length) {
            result[index] = v1[index];
            ++i;
            ++index;
        }
        i = 0;
        while (i < v2.length) {
            result[index] = v2[i];
            ++i;
            ++index;
        }
        return result;
    }

    public static double[][] concatenate(double[][] m1, double[][] m2) {
        if (m1.length != m2.length) {
            throw new IllegalArgumentException("m1 and m2 must have the same number of rows:" + m1.length + " != " + m2.length);
        }
        double[][] result = new double[m1.length][m1[0].length + m2[0].length];
        int resCol = 0;
        for (int i = 0; i < m1.length; ++i) {
            int j;
            resCol = 0;
            for (j = 0; j < m1[i].length; ++j) {
                result[i][resCol++] = m1[i][j];
            }
            for (j = 0; j < m2[i].length; ++j) {
                result[i][resCol++] = m2[i][j];
            }
        }
        return result;
    }

    public static double[][] concatenate(double[][] m1, double[] v2) {
        if (m1.length != v2.length) {
            throw new IllegalArgumentException("m1 and v2 must have the same number of rows:" + m1.length + " != " + v2.length);
        }
        double[][] result = new double[m1.length][m1[0].length + 1];
        int resCol = 0;
        for (int i = 0; i < m1.length; ++i) {
            resCol = 0;
            for (int j = 0; j < m1[i].length; ++j) {
                result[i][resCol++] = m1[i][j];
            }
            result[i][resCol++] = v2[i];
        }
        return result;
    }

    public double[][] scalarMultiply(double[][] m1, double[][] m2) {
        return this.parScalarMultiply(m1, m2);
    }

    public static double[][] sMultiply(double[][] v1, double[][] v2) {
        if (v1.length != v2.length || v1[0].length != v2[0].length) {
            throw new IllegalArgumentException("a and b has to be of equal dimensions");
        }
        double[][] result = new double[v1.length][v1[0].length];
        for (int i = 0; i < v1.length; ++i) {
            for (int j = 0; j < v1[0].length; ++j) {
                result[i][j] = v1[i][j] * v2[i][j];
            }
        }
        return result;
    }

    public double[][] parScalarMultiply(double[][] m1, double[][] m2) {
        int ll = 600;
        double[][] result = new double[m1.length][m1[0].length];
        MatrixOperator process = new MatrixOperator(m1, m2, result, this.multiplyop, 0, m1.length, ll);
        pool.invoke(process);
        return result;
    }

    public double[][] parScalarMinus(double[][] m1, double[][] m2) {
        int ll = 600;
        double[][] result = new double[m1.length][m1[0].length];
        MatrixOperator process = new MatrixOperator(m1, m2, result, this.minusop, 0, m1.length, ll);
        pool.invoke(process);
        return result;
    }

    public static void assignAtIndex(double[][] num, int[] range, int[] range1, double value) {
        for (int j = 0; j < range.length; ++j) {
            num[range[j]][range1[j]] = value;
        }
    }

    public static double[][] getValuesFromRow(double[][] matrix, int row, int[] indicies) {
        double[][] values = new double[1][indicies.length];
        for (int j = 0; j < indicies.length; ++j) {
            values[0][j] = matrix[row][indicies[j]];
        }
        return values;
    }

    public static void assignValuesToRow(double[][] matrix, int row, int[] indicies, double[] values) {
        if (indicies.length != values.length) {
            throw new IllegalArgumentException("Length of indicies and values have to be equal");
        }
        for (int j = 0; j < indicies.length; ++j) {
            matrix[row][indicies[j]] = values[j];
        }
    }

    public static double stdev(double[][] matrix) {
        double m = MatrixOps.mean(matrix);
        double total = 0.0;
        int N = matrix.length * matrix[0].length;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                double x = matrix[i][j];
                total += (x - m) * (x - m);
            }
        }
        return Math.sqrt(total / (double)(N - 1));
    }

    public static double[] colStddev(double[][] v) {
        double[] var = MatrixOps.variance(v);
        for (int i = 0; i < var.length; ++i) {
            var[i] = Math.sqrt(var[i]);
        }
        return var;
    }

    public static double[] variance(double[][] v) {
        int m = v.length;
        int n = v[0].length;
        double[] var = new double[n];
        int degrees = m - 1;
        for (int j = 0; j < n; ++j) {
            int k;
            double c = 0.0;
            double s = 0.0;
            for (k = 0; k < m; ++k) {
                s += v[k][j];
            }
            s /= (double)m;
            for (k = 0; k < m; ++k) {
                c += (v[k][j] - s) * (v[k][j] - s);
            }
            var[j] = c / (double)degrees;
        }
        return var;
    }

    public static double[] colMeans(double[][] matrix) {
        int rows = matrix.length;
        int cols = matrix[0].length;
        double[] mean = new double[cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                int n = j;
                mean[n] = mean[n] + matrix[i][j];
            }
        }
        int j = 0;
        while (j < cols) {
            int n = j++;
            mean[n] = mean[n] / (double)rows;
        }
        return mean;
    }

    public static double[][] copyRows(double[][] input, int ... indices) {
        double[][] matrix = new double[indices.length][input[0].length];
        for (int i = 0; i < indices.length; ++i) {
            System.arraycopy(input[indices[i]], 0, matrix[i], 0, input[indices[i]].length);
        }
        return matrix;
    }

    public static double[][] copyCols(double[][] input, int ... indices) {
        double[][] matrix = new double[indices.length][input.length];
        for (int i = 0; i < indices.length; ++i) {
            for (int j = 0; j < input.length; ++j) {
                matrix[i][j] = input[j][indices[i]];
            }
        }
        return matrix;
    }

    public static double[][] fillMatrix(int rows, int cols, double fillvalue) {
        double[][] matrix = new double[rows][cols];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                matrix[i][j] = fillvalue;
            }
        }
        return matrix;
    }

    public static double[][] plus(double[][] m1, double[][] m2) {
        double[][] matrix = new double[m1.length][m1[0].length];
        for (int i = 0; i < m1.length; ++i) {
            for (int j = 0; j < m1[0].length; ++j) {
                matrix[i][j] = m1[i][j] + m2[i][j];
            }
        }
        return matrix;
    }

    public static double[][] scalarPlus(double[][] m1, double m2) {
        double[][] matrix = new double[m1.length][m1[0].length];
        for (int i = 0; i < m1.length; ++i) {
            for (int j = 0; j < m1[0].length; ++j) {
                matrix[i][j] = m1[i][j] + m2;
            }
        }
        return matrix;
    }

    public static double[] scalarPlus(double[] m1, double m2) {
        double[] matrix = new double[m1.length];
        for (int i = 0; i < m1.length; ++i) {
            matrix[i] = m1[i] + m2;
        }
        return matrix;
    }

    public double[][] minus(double[][] m1, double[][] m2) {
        return this.parScalarMinus(m1, m2);
    }

    public static double[][] sMinus(double[][] m1, double[][] m2) {
        double[][] matrix = new double[m1.length][m1[0].length];
        for (int i = 0; i < m1.length; ++i) {
            for (int j = 0; j < m1[0].length; ++j) {
                matrix[i][j] = m1[i][j] - m2[i][j];
            }
        }
        return matrix;
    }

    public static double[][] scalarDivide(double[][] numerator, double denom) {
        double[][] matrix = new double[numerator.length][numerator[0].length];
        for (int i = 0; i < numerator.length; ++i) {
            for (int j = 0; j < numerator[i].length; ++j) {
                matrix[i][j] = numerator[i][j] / denom;
            }
        }
        return matrix;
    }

    public static double[] scalarDivide(double numerator, double[] denom) {
        double[] vector = new double[denom.length];
        for (int i = 0; i < denom.length; ++i) {
            vector[i] = numerator / denom[i];
        }
        return vector;
    }

    public static double[] scalarDivide(double[] numerator, double denom) {
        double[] vector = new double[numerator.length];
        for (int i = 0; i < numerator.length; ++i) {
            vector[i] = numerator[i] / denom;
        }
        return vector;
    }

    public static double[] scalarDivide(double[] numerator, double[] denom) {
        double[] vector = new double[denom.length];
        for (int i = 0; i < denom.length; ++i) {
            vector[i] = numerator[i] / denom[i];
        }
        return vector;
    }

    public static double[][] scalarDivide(double[][] numerator, double[][] denom) {
        double[][] matrix = new double[numerator.length][numerator[0].length];
        for (int i = 0; i < numerator.length; ++i) {
            for (int j = 0; j < numerator[i].length; ++j) {
                matrix[i][j] = numerator[i][j] / denom[i][j];
            }
        }
        return matrix;
    }

    public static double[][] scalarMult(double[][] m1, double mul) {
        double[][] matrix = new double[m1.length][m1[0].length];
        for (int i = 0; i < m1.length; ++i) {
            for (int j = 0; j < m1[i].length; ++j) {
                matrix[i][j] = m1[i][j] * mul;
            }
        }
        return matrix;
    }

    public static double[][] times(double[][] m1, double[][] m2) {
        Matrix A = Matrix.constructWithCopy((double[][])m1);
        Matrix B = Matrix.constructWithCopy((double[][])m2);
        return A.times(B).getArray();
    }

    public static double[] scalarMultiply(double[] m1, double mul) {
        double[] matrix = new double[m1.length];
        for (int i = 0; i < m1.length; ++i) {
            matrix[i] = m1[i] * mul;
        }
        return matrix;
    }

    public static double[] scalarMultiply(double[] m1, double[] m2) {
        double[] matrix = new double[m1.length];
        for (int i = 0; i < m1.length; ++i) {
            matrix[i] = m1[i] * m2[i];
        }
        return matrix;
    }

    public static double[][] diag(double[][] ds) {
        boolean isLong = ds.length > ds[0].length;
        int dim = Math.max(ds.length, ds[0].length);
        double[][] result = new double[dim][dim];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result.length; ++j) {
                if (i != j) continue;
                result[i][j] = isLong ? ds[i][0] : ds[0][i];
            }
        }
        return result;
    }

    public static double[][] dot(double[][] a, double[][] b) {
        if (a[0].length != b.length) {
            throw new IllegalArgumentException("Dims does not match: " + a[0].length + "!=" + b.length);
        }
        double[][] res = new double[a.length][b[0].length];
        for (int row = 0; row < a.length; ++row) {
            for (int col = 0; col < b[row].length; ++col) {
                for (int i = 0; i < a[0].length; ++i) {
                    res[row][col] = a[row][i] * b[i][col];
                }
            }
        }
        return res;
    }

    public static double dot(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Vectors are not of equal length");
        }
        double res = 0.0;
        for (int i = 0; i < b.length; ++i) {
            res += a[i] * b[i];
        }
        return res;
    }

    public static double dot2P1(double[] a1, double[] a2, double[] b) {
        if (a1.length + a2.length != b.length) {
            throw new IllegalArgumentException("Vectors are not of equal length");
        }
        double res = 0.0;
        int bidx = 0;
        int i = 0;
        while (i < a1.length) {
            res += a1[i] * b[bidx];
            ++i;
            ++bidx;
        }
        i = 0;
        while (i < a2.length) {
            res += a2[i] * b[bidx];
            ++i;
            ++bidx;
        }
        return res;
    }

    public static int maxIdx(double[] probs) {
        int maxIdx = 0;
        double max = probs[maxIdx];
        for (int i = 0; i < probs.length; ++i) {
            if (!(probs[i] > max)) continue;
            max = probs[i];
            maxIdx = i;
        }
        return maxIdx;
    }

    public static double[][] extractCol(int col, double[][] matrix) {
        double[][] res = new double[matrix.length][1];
        for (int row = 0; row < matrix.length; ++row) {
            res[row][0] = matrix[row][col];
        }
        return res;
    }

    public static double[] extractColVector(int col, double[][] matrix) {
        double[] res = new double[matrix.length];
        for (int row = 0; row < matrix.length; ++row) {
            res[row] = matrix[row][col];
        }
        return res;
    }

    public static double[][] extractDoubleArray(DenseMatrix64F p) {
        int rows = p.getNumRows();
        int cols = p.getNumCols();
        double[][] result = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                result[i][j] = p.get(i, j);
            }
        }
        return result;
    }

    public static double[] extractDoubleVector(DenseMatrix64F p) {
        double[] result;
        int rows = p.getNumRows();
        int cols = p.getNumCols();
        if (rows != 1 && cols != 1) {
            throw new IllegalArgumentException("Cannot convert a " + rows + "x" + cols + " matrix to a vector");
        }
        if (cols == 1) {
            result = new double[rows];
            for (int j = 0; j < rows; ++j) {
                result[j] = p.get(j, 0);
            }
        } else {
            result = new double[cols];
            for (int j = 0; j < cols; ++j) {
                result[j] = p.get(0, j);
            }
        }
        return result;
    }

    public static double[][] extractRowCols(int col, double[][] zs2, int[] cJIdxs) {
        double[][] res = new double[cJIdxs.length][1];
        for (int row = 0; row < cJIdxs.length; ++row) {
            res[row][0] = zs2[cJIdxs[row]][col];
        }
        return res;
    }

    public static Integer[] indicesOf(int classIdx, int[] ys) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int row = 0; row < ys.length; ++row) {
            if (ys[row] != classIdx) continue;
            indices.add(row);
        }
        return indices.toArray(new Integer[0]);
    }

    public static double[][] makeDesignMatrix(double[][] xstmp) {
        double[][] xs = new double[xstmp.length][xstmp[0].length + 1];
        for (int row = 0; row < xs.length; ++row) {
            for (int col = 0; col < xs[0].length; ++col) {
                xs[row][col] = col == 0 ? 1.0 : xstmp[row][col - 1];
            }
        }
        return xs;
    }

    public static double[][] addIntercept(double[][] xs) {
        double[][] result = new double[xs.length][xs[0].length + 1];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[0].length; ++j) {
                result[i][j] = j == 0 ? 1.0 : xs[i][j - 1];
            }
        }
        return result;
    }

    public static double[] toPrimitive(Double[] ds) {
        double[] result = new double[ds.length];
        for (int i = 0; i < ds.length; ++i) {
            result[i] = ds[i];
        }
        return result;
    }

    public static double[] extractRowFromFlatMatrix(double[] flatMatrix, int rowIdx, int dimension) {
        double[] point = new double[dimension];
        int offset = rowIdx * dimension;
        for (int j = 0; j < dimension; ++j) {
            point[j] = flatMatrix[offset + j];
        }
        return point;
    }

    class MatrixOperator
    extends RecursiveAction {
        static final long serialVersionUID = 1L;
        double[][] matrix1;
        double[][] matrix2;
        double[][] resultMatrix;
        int startRow = -1;
        int endRow = -1;
        int limit = 1000;
        MatrixOp op;

        public MatrixOperator(double[][] matrix1, double[][] matrix2, double[][] resultMatrix, MatrixOp op, int startRow, int endRow, int ll) {
            this.op = op;
            this.limit = ll;
            this.matrix1 = matrix1;
            this.matrix2 = matrix2;
            this.resultMatrix = resultMatrix;
            this.startRow = startRow;
            this.endRow = endRow;
        }

        @Override
        protected void compute() {
            try {
                if (this.endRow - this.startRow <= this.limit) {
                    int cols = this.matrix1[0].length;
                    for (int i = this.startRow; i < this.endRow; ++i) {
                        for (int j = 0; j < cols; ++j) {
                            this.resultMatrix[i][j] = this.op.compute(this.matrix1[i][j], this.matrix2[i][j]);
                        }
                    }
                } else {
                    int endRow1;
                    int range = this.endRow - this.startRow;
                    int startRow1 = this.startRow;
                    int startRow2 = endRow1 = this.startRow + range / 2;
                    int endRow2 = this.endRow;
                    MatrixOperator.invokeAll(new MatrixOperator(this.matrix1, this.matrix2, this.resultMatrix, this.op, startRow1, endRow1, this.limit), new MatrixOperator(this.matrix1, this.matrix2, this.resultMatrix, this.op, startRow2, endRow2, this.limit));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface MatrixOp {
        public double compute(double var1, double var3);
    }

    class MatrixSummer
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        double[][] orig;
        double[] sums;
        int startRow = -1;
        int endRow = -1;
        int limit = 1000;

        public MatrixSummer(double[][] orig, double[] sums, int startRow, int endRow, int ll) {
            this.limit = ll;
            this.orig = orig;
            this.sums = sums;
            this.startRow = startRow;
            this.endRow = endRow;
        }

        public MatrixSummer(double[][] orig, double[] transpose, int startRow, int endRow) {
            this.orig = orig;
            this.sums = transpose;
            this.startRow = startRow;
            this.endRow = endRow;
        }

        @Override
        protected void compute() {
            try {
                if (this.endRow - this.startRow <= this.limit) {
                    int cols = this.orig[0].length;
                    for (int row = this.startRow; row < this.endRow; ++row) {
                        for (int i = 0; i < cols; ++i) {
                            int n = row;
                            this.sums[n] = this.sums[n] + this.orig[row][i];
                        }
                    }
                } else {
                    int endRow1;
                    int range = this.endRow - this.startRow;
                    int startRow1 = this.startRow;
                    int startRow2 = endRow1 = this.startRow + range / 2;
                    int endRow2 = this.endRow;
                    MatrixSummer.invokeAll(new MatrixSummer(this.orig, this.sums, startRow1, endRow1, this.limit), new MatrixSummer(this.orig, this.sums, startRow2, endRow2, this.limit));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class MatrixTransposer
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        double[][] orig;
        double[][] transpose;
        int startRow = -1;
        int endRow = -1;
        int limit = 1000;

        public MatrixTransposer(double[][] orig, double[][] transpose, int startRow, int endRow, int ll) {
            this.limit = ll;
            this.orig = orig;
            this.transpose = transpose;
            this.startRow = startRow;
            this.endRow = endRow;
        }

        public MatrixTransposer(double[][] orig, double[][] transpose, int startRow, int endRow) {
            this.orig = orig;
            this.transpose = transpose;
            this.startRow = startRow;
            this.endRow = endRow;
        }

        @Override
        protected void compute() {
            try {
                if (this.endRow - this.startRow <= this.limit) {
                    int cols = this.orig[0].length;
                    for (int i = 0; i < cols; ++i) {
                        for (int j = this.startRow; j < this.endRow; ++j) {
                            this.transpose[i][j] = this.orig[j][i];
                        }
                    }
                } else {
                    int endRow1;
                    int range = this.endRow - this.startRow;
                    int startRow1 = this.startRow;
                    int startRow2 = endRow1 = this.startRow + range / 2;
                    int endRow2 = this.endRow;
                    MatrixTransposer.invokeAll(new MatrixTransposer(this.orig, this.transpose, startRow1, endRow1, this.limit), new MatrixTransposer(this.orig, this.transpose, startRow2, endRow2, this.limit));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

