/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageRoi;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.plugin.Colors;
import java.awt.Color;
import java.awt.Font;

public class RoiProperties {
    private Roi roi;
    private String title;
    private boolean showName = true;
    private boolean addToOverlay;
    private boolean overlayOptions;
    private boolean existingOverlay;
    private boolean setPositions;
    private static final String[] justNames = new String[]{"Left", "Center", "Right"};

    public RoiProperties(String title, Roi roi) {
        if (roi == null) {
            throw new IllegalArgumentException("ROI is null");
        }
        this.title = title;
        this.showName = title.startsWith("Prop");
        this.addToOverlay = title.equals("Add to Overlay");
        this.overlayOptions = title.equals("Overlay Options");
        ImagePlus imp = WindowManager.getCurrentImage();
        if (this.overlayOptions) {
            Overlay overlay = imp != null ? imp.getOverlay() : null;
            boolean bl = this.setPositions = roi.getPosition() != 0;
            if (overlay != null) {
                this.existingOverlay = true;
            }
        }
        this.roi = roi;
    }

    private String decodeColor(Color color, Color defaultColor) {
        String lc;
        String str;
        if (color == null) {
            color = defaultColor;
        }
        if ((str = "#" + Integer.toHexString(color.getRGB())).length() == 9 && str.startsWith("#ff")) {
            str = "#" + str.substring(3);
        }
        if ((lc = Colors.hexToColor(str)) != null) {
            str = lc;
        }
        return str;
    }

    public boolean showDialog() {
        boolean newOverlay;
        String fillc;
        String lc;
        String linec;
        double width;
        String nameLabel;
        Color strokeColor = null;
        Color fillColor = null;
        double strokeWidth = 1.0;
        String name = this.roi.getName();
        boolean isRange = name != null && name.startsWith("range: ");
        String string = nameLabel = isRange ? "Range:" : "Name:";
        if (isRange) {
            name = name.substring(7);
        }
        if (name == null) {
            name = "";
        }
        if (!isRange && this.roi instanceof ImageRoi) {
            return this.showImageDialog(name);
        }
        if (this.roi.getStrokeColor() != null) {
            strokeColor = this.roi.getStrokeColor();
        }
        if (strokeColor == null) {
            strokeColor = Roi.getColor();
        }
        if (this.roi.getFillColor() != null) {
            fillColor = this.roi.getFillColor();
        }
        if ((width = (double)this.roi.getStrokeWidth()) > 1.0) {
            strokeWidth = width;
        }
        boolean isText = this.roi instanceof TextRoi;
        boolean isLine = this.roi.isLine();
        int justification = 0;
        if (isText) {
            TextRoi troi = (TextRoi)this.roi;
            Font font = troi.getCurrentFont();
            strokeWidth = font.getSize();
            justification = troi.getJustification();
        }
        String string2 = linec = strokeColor != null ? "#" + Integer.toHexString(strokeColor.getRGB()) : "none";
        if (linec.length() == 9 && linec.startsWith("#ff")) {
            linec = "#" + linec.substring(3);
        }
        if ((lc = Colors.hexToColor(linec)) != null) {
            linec = lc;
        }
        String string3 = fillc = fillColor != null ? "#" + Integer.toHexString(fillColor.getRGB()) : "none";
        if (IJ.isMacro()) {
            fillc = "none";
        }
        int digits = (double)((int)strokeWidth) == strokeWidth ? 0 : 1;
        GenericDialog gd = new GenericDialog(this.title);
        if (this.showName) {
            gd.addStringField(nameLabel, name, 15);
        }
        gd.addStringField("Stroke color: ", linec);
        if (isText) {
            gd.addNumericField("Font size:", strokeWidth, digits);
            gd.addChoice("Justification:", justNames, justNames[justification]);
        } else {
            gd.addNumericField("Width:", strokeWidth, digits);
        }
        if (!isLine) {
            gd.addMessage("");
            gd.addStringField("Fill color: ", fillc);
        }
        if (this.addToOverlay) {
            gd.addCheckbox("New overlay", false);
        }
        if (this.overlayOptions) {
            if (this.existingOverlay) {
                gd.addCheckbox("Apply to current overlay", false);
            }
            gd.addCheckbox("Set stack positions", this.setPositions);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        if (this.showName) {
            name = gd.getNextString();
            if (!isRange) {
                this.roi.setName(name.length() > 0 ? name : null);
            }
        }
        linec = gd.getNextString();
        strokeWidth = gd.getNextNumber();
        if (isText) {
            justification = gd.getNextChoiceIndex();
        }
        if (!isLine) {
            fillc = gd.getNextString();
        }
        boolean applyToOverlay = false;
        boolean bl = newOverlay = this.addToOverlay ? gd.getNextBoolean() : false;
        if (this.overlayOptions) {
            if (this.existingOverlay) {
                applyToOverlay = gd.getNextBoolean();
            }
            this.setPositions = gd.getNextBoolean();
            this.roi.setPosition(this.setPositions ? 1 : 0);
        }
        strokeColor = Colors.decode(linec, Roi.getColor());
        fillColor = Colors.decode(fillc, null);
        if (isText) {
            TextRoi troi = (TextRoi)this.roi;
            Font font = troi.getCurrentFont();
            if ((int)strokeWidth != font.getSize()) {
                font = new Font(font.getName(), font.getStyle(), (int)strokeWidth);
                troi.setCurrentFont(font);
            }
            if (justification != troi.getJustification()) {
                troi.setJustification(justification);
            }
        } else if (strokeWidth != 1.0 || this.roi.getStroke() != null) {
            this.roi.setStrokeWidth((float)strokeWidth);
        }
        this.roi.setStrokeColor(strokeColor);
        this.roi.setFillColor(fillColor);
        if (newOverlay) {
            this.roi.setName("new-overlay");
        }
        if (applyToOverlay) {
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp == null) {
                return true;
            }
            Overlay overlay = imp.getOverlay();
            if (overlay == null) {
                return true;
            }
            Roi[] rois = overlay.toArray();
            for (int i = 0; i < rois.length; ++i) {
                rois[i].setStrokeColor(strokeColor);
                rois[i].setStrokeWidth((float)strokeWidth);
                rois[i].setFillColor(fillColor);
            }
            imp.draw();
        }
        return true;
    }

    public boolean showImageDialog(String name) {
        boolean newOverlay;
        GenericDialog gd = new GenericDialog(this.title);
        gd.addStringField("Name:", name, 15);
        gd.addNumericField("Opacity (0-100%):", ((ImageRoi)this.roi).getOpacity() * 100.0, 0);
        if (this.addToOverlay) {
            gd.addCheckbox("New Overlay", false);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        name = gd.getNextString();
        this.roi.setName(name.length() > 0 ? name : null);
        double opacity = gd.getNextNumber() / 100.0;
        ((ImageRoi)this.roi).setOpacity(opacity);
        boolean bl = newOverlay = this.addToOverlay ? gd.getNextBoolean() : false;
        if (newOverlay) {
            this.roi.setName("new-overlay");
        }
        return true;
    }
}

