/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;

public final class XmlUtil {
    private static Map<String, String> replacements = new HashMap<String, String>();

    private XmlUtil() {
    }

    public static String getFragmentFromURI(String uri) {
        if (uri.indexOf(35) > 0) {
            return uri.substring(uri.indexOf(35) + 1);
        }
        return uri;
    }

    public static String indentXmlSimple(String xmlString) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int indent = 0;
        char[] bytes = xmlString.toCharArray();
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] == '<' && bytes[i + 1] == '/') {
                os.write(10);
                XmlUtil.writeIndentation(os, --indent);
            } else if (bytes[i] == '<') {
                if (i > 0) {
                    os.write(10);
                }
                XmlUtil.writeIndentation(os, indent++);
            } else if (bytes[i] == '/' && bytes[i + 1] == '>') {
                --indent;
            } else if (bytes[i] == '>') {
                // empty if block
            }
            os.write(bytes[i++]);
        }
        return os.toString();
    }

    private static void writeIndentation(ByteArrayOutputStream os, int indent) {
        for (int j = 0; j < indent; ++j) {
            os.write(32);
            os.write(32);
        }
    }

    public static String fixEntityNames(String value) {
        String retVal = value;
        if (retVal.indexOf(38) != -1) {
            for (Map.Entry<String, String> entry : replacements.entrySet()) {
                String orig = entry.getKey();
                String replacement = entry.getValue();
                if ((retVal = retVal.replaceAll("&" + orig + ";", "&" + replacement + ";")).indexOf(38) != -1) continue;
                break;
            }
        }
        return retVal;
    }

    static {
        replacements.put("agr", "alpha");
        replacements.put("Agr", "Alpha");
        replacements.put("bgr", "beta");
        replacements.put("Bgr", "Beta");
        replacements.put("ggr", "gamma");
        replacements.put("Ggr", "Gamma");
        replacements.put("dgr", "delta");
        replacements.put("Dgr", "Delta");
        replacements.put("egr", "epsilon");
        replacements.put("Egr", "Epsilon");
        replacements.put("zgr", "zeta");
        replacements.put("Zgr", "Zeta");
        replacements.put("eegr", "eta");
        replacements.put("EEgr", "Eta");
        replacements.put("thgr", "theta");
        replacements.put("THgr", "Theta");
        replacements.put("igr", "iota");
        replacements.put("Igr", "Iota");
        replacements.put("kgr", "kappa");
        replacements.put("Kgr", "Kappa");
        replacements.put("lgr", "lambda");
        replacements.put("Lgr", "Lambda");
        replacements.put("mgr", "mu");
        replacements.put("Mgr", "Mu");
        replacements.put("ngr", "nu");
        replacements.put("Ngr", "Nu");
        replacements.put("xgr", "xi");
        replacements.put("Xgr", "Xi");
        replacements.put("ogr", "omicron");
        replacements.put("Ogr", "Omicron");
        replacements.put("pgr", "pi");
        replacements.put("Pgr", "Pi");
        replacements.put("rgr", "rho");
        replacements.put("Rgr", "Rho");
        replacements.put("sgr", "sigma");
        replacements.put("Sgr", "Sigma");
        replacements.put("sfgr", "sigmaf");
        replacements.put("tgr", "tau");
        replacements.put("Tgr", "Tau");
        replacements.put("ugr", "upsilon");
        replacements.put("Ugr", "Upsilon");
        replacements.put("phgr", "phi");
        replacements.put("PHgr", "Phi");
        replacements.put("khgr", "chi");
        replacements.put("KHgr", "Chi");
        replacements.put("psgr", "psi");
        replacements.put("PSgr", "Psi");
        replacements.put("ohgr", "omega");
        replacements.put("OHgr", "Omega");
    }
}

