/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Util {
    private Util() {
    }

    public static boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static int hashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    public static Exception verboseException(Exception e) {
        boolean needComma = false;
        StringWriter message = new StringWriter();
        PrintWriter pMessage = new PrintWriter(message);
        Class<?> c = e.getClass();
        while (e != null) {
            if (needComma) {
                pMessage.println("\n---------------NEXT EXCEPTION");
            }
            needComma = true;
            e.printStackTrace(pMessage);
            if (e instanceof SQLException) {
                e = ((SQLException)e).getNextException();
                continue;
            }
            e = null;
        }
        try {
            Constructor<?> cons = c.getConstructor(String.class);
            Exception toThrow = (Exception)cons.newInstance(message.toString());
            return toThrow;
        }
        catch (NoSuchMethodException e2) {
            throw new RuntimeException("NoSuchMethodException thrown while handling " + c.getName() + ": " + message.toString());
        }
        catch (InstantiationException e2) {
            throw new RuntimeException("InstantiationException thrown while handling " + c.getName() + ": " + message.toString());
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException("IllegalAccessException thrown while handling " + c.getName() + ": " + message.toString());
        }
        catch (InvocationTargetException e2) {
            throw new RuntimeException("InvocationTargetException thrown while handling " + c.getName() + ": " + message.toString());
        }
    }

    public static int gcd(int a, int b) {
        while (b != 0) {
            int t = b;
            b = a % b;
            a = t;
        }
        return a;
    }

    public static int lcm(int a, int b) {
        return a / Util.gcd(a, b) * b;
    }

    public static String wildcardSqlToUser(String exp) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < exp.length(); ++i) {
            String substring = exp.substring(i);
            if (substring.startsWith("%")) {
                sb.append("*");
                continue;
            }
            if (substring.startsWith("_")) {
                sb.append("?");
                continue;
            }
            if (substring.startsWith("\\%")) {
                sb.append("%");
                ++i;
                continue;
            }
            if (substring.startsWith("\\_")) {
                sb.append("_");
                ++i;
                continue;
            }
            if (substring.startsWith("*")) {
                sb.append("\\*");
                continue;
            }
            if (substring.startsWith("?")) {
                sb.append("\\?");
                continue;
            }
            if (substring.startsWith("\\\\")) {
                ++i;
                sb.append("\\");
                continue;
            }
            sb.append(substring.charAt(0));
        }
        return sb.toString();
    }

    public static String wildcardUserToSql(String exp) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < exp.length(); ++i) {
            String substring = exp.substring(i);
            if (substring.startsWith("*")) {
                sb.append("%");
                continue;
            }
            if (substring.startsWith("?")) {
                sb.append("_");
                continue;
            }
            if (substring.startsWith("\\*")) {
                sb.append("*");
                ++i;
                continue;
            }
            if (substring.startsWith("\\?")) {
                sb.append("?");
                ++i;
                continue;
            }
            if (substring.startsWith("%")) {
                sb.append("\\%");
                continue;
            }
            if (substring.startsWith("_")) {
                sb.append("\\_");
                continue;
            }
            if (substring.startsWith("\\")) {
                sb.append("\\\\");
                continue;
            }
            sb.append(substring.charAt(0));
        }
        return sb.toString();
    }

    public static String getMd5checksum(String sequence) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        byte[] buffer = sequence.getBytes();
        md5.update(buffer);
        byte[] bits = md5.digest();
        StringBuilder checksum = new StringBuilder();
        for (int i = 0; i < bits.length; ++i) {
            checksum.append(Integer.toHexString(0xFF & bits[i] | 0xFFFFFF00).substring(6));
        }
        return checksum.toString().toLowerCase();
    }

    public static Class<?> getClassFromString(String type) {
        if ("short".equals(type) || "java.lang.Short".equals(type)) {
            return Short.class;
        }
        if ("int".equals(type) || "java.lang.Integer".equals(type)) {
            return Integer.class;
        }
        if ("long".equals(type) || "java.lang.Long".equals(type)) {
            return Long.class;
        }
        if ("java.lang.String".equals(type)) {
            return String.class;
        }
        if ("boolean".equals(type)) {
            return Boolean.TYPE;
        }
        if ("java.lang.Boolean".equals(type)) {
            return Boolean.class;
        }
        if ("float".equals(type) || "java.lang.Float".equals(type)) {
            return Float.class;
        }
        if ("double".equals(type) || "java.lang.Double".equals(type)) {
            return Double.class;
        }
        if ("java.util.Date".equals(type)) {
            return Date.class;
        }
        if ("java.math.BigDecimal".equals(type)) {
            return BigDecimal.class;
        }
        if ("org.intermine.objectstore.query.ClobAccess".equals(type)) {
            return String.class;
        }
        throw new IllegalArgumentException("Unknown type \"" + type + "\"");
    }

    public static void addToSetMap(Map map, Object key, Set<Object> values) {
        if (map == null) {
            throw new IllegalArgumentException("invalid map");
        }
        if (key == null) {
            throw new IllegalArgumentException("invalid map key");
        }
        HashSet<Object> valuesList = (HashSet<Object>)map.get(key);
        if (valuesList == null) {
            valuesList = new HashSet<Object>();
            map.put(key, valuesList);
        }
        valuesList.addAll(values);
    }

    public static void addToSetMap(Map map, Object key, Object value) {
        if (map == null) {
            throw new IllegalArgumentException("invalid map");
        }
        if (key == null) {
            throw new IllegalArgumentException("invalid map key");
        }
        HashSet<Object> valuesList = (HashSet<Object>)map.get(key);
        if (valuesList == null) {
            valuesList = new HashSet<Object>();
            map.put(key, valuesList);
        }
        valuesList.add(value);
    }

    public static void addToListMap(Map map, Object key, Object value) {
        if (map == null) {
            throw new IllegalArgumentException("invalid map");
        }
        if (key == null) {
            throw new IllegalArgumentException("invalid map key");
        }
        ArrayList<Object> valuesList = (ArrayList<Object>)map.get(key);
        if (valuesList == null) {
            valuesList = new ArrayList<Object>();
            map.put(key, valuesList);
        }
        valuesList.add(value);
    }
}

