/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.util.ArrayList;
import java.util.Iterator;

public class TextTable {
    public static final String[] ROW_SEPARATOR = new String[0];
    private ArrayList<String[]> rows = new ArrayList();
    private ArrayList<Integer> columnWidths = new ArrayList();
    private boolean leftBound;
    private boolean columnSeparators;
    private boolean rightBound;

    public TextTable(boolean leftBound, boolean columnSeparators, boolean rightBound) {
        this.leftBound = leftBound;
        this.columnSeparators = columnSeparators;
        this.rightBound = rightBound;
    }

    public void addRow(String ... row) {
        for (int i = 0; i < row.length; ++i) {
            int width = row[i].length();
            if (i >= this.columnWidths.size()) {
                this.columnWidths.add(i, new Integer(width));
                continue;
            }
            int previousWidth = this.columnWidths.get(i);
            if (width <= previousWidth) continue;
            this.columnWidths.set(i, new Integer(width));
        }
        this.rows.add(row);
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        boolean firstRow = true;
        Iterator<String[]> rowIter = this.rows.iterator();
        while (rowIter.hasNext()) {
            int width;
            int i;
            String[] row = rowIter.next();
            if (row == ROW_SEPARATOR) {
                if (this.leftBound) {
                    if (firstRow) {
                        if (!rowIter.hasNext()) {
                            retval.append("--");
                        } else {
                            retval.append(".-");
                        }
                    } else if (!rowIter.hasNext()) {
                        retval.append("`-");
                    } else {
                        retval.append("|-");
                    }
                }
                for (i = 0; i < this.columnWidths.size(); ++i) {
                    width = this.columnWidths.get(i);
                    for (int o = 0; o < width; ++o) {
                        retval.append('-');
                    }
                    if (i + 1 >= this.columnWidths.size()) continue;
                    if (this.columnSeparators) {
                        if (firstRow || !rowIter.hasNext()) {
                            retval.append("---");
                            continue;
                        }
                        retval.append("-|-");
                        continue;
                    }
                    retval.append("-");
                }
                if (this.rightBound) {
                    if (firstRow) {
                        if (!rowIter.hasNext()) {
                            retval.append("--");
                        } else {
                            retval.append("-.");
                        }
                    } else if (!rowIter.hasNext()) {
                        retval.append("-'");
                    } else {
                        retval.append("-|");
                    }
                }
            } else {
                if (this.leftBound) {
                    retval.append("| ");
                }
                for (i = 0; i < this.columnWidths.size(); ++i) {
                    int textLength;
                    width = this.columnWidths.get(i);
                    if (i >= row.length) {
                        textLength = 0;
                    } else {
                        retval.append(row[i]);
                        textLength = row[i].length();
                    }
                    for (int o = textLength; o < width; ++o) {
                        retval.append(' ');
                    }
                    if (i + 1 >= this.columnWidths.size()) continue;
                    if (this.columnSeparators) {
                        retval.append(" | ");
                        continue;
                    }
                    retval.append(" ");
                }
                if (this.rightBound) {
                    retval.append(" |");
                }
            }
            retval.append("\n");
            firstRow = false;
        }
        return retval.toString();
    }
}

