/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public final class StringUtil {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static long differentNumber = 0L;

    private StringUtil() {
    }

    public static int countOccurances(String str, String target) {
        if (str == null || target == null) {
            throw new NullPointerException("Cannot pass null arguments to countOccurances");
        }
        int count = 0;
        int index = -1;
        while ((index = target.indexOf(str, index + 1)) >= 0) {
            ++count;
        }
        return count;
    }

    public static String join(Collection<?> c, String delimiter) {
        StringBuffer sb = new StringBuffer();
        boolean needComma = false;
        for (Object o : c) {
            if (needComma) {
                sb.append(delimiter);
            }
            needComma = true;
            sb.append(o.toString());
        }
        return sb.toString();
    }

    public static List<String> tokenize(String str, String delimiter) {
        if (str == null) {
            throw new NullPointerException("Cannot pass null arguments to tokenize");
        }
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l;
    }

    public static List<String> tokenize(String str) {
        if (str == null) {
            throw new NullPointerException("Cannot pass null arguments to tokenize");
        }
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l;
    }

    public static Collection<String> tokenize(String strings, boolean lowercase) {
        if (strings == null) {
            return null;
        }
        ArrayList<String> coll = new ArrayList<String>();
        for (String s : strings.split(",")) {
            if (lowercase) {
                coll.add(s.toLowerCase());
                continue;
            }
            coll.add(s);
        }
        return coll;
    }

    public static String bufferToHexString(byte[] buffer) {
        StringBuffer sb = new StringBuffer(buffer.length * 2);
        for (int i = 0; i < buffer.length; ++i) {
            char a = HEX_CHARS[(buffer[i] & 0xF0) >> 4];
            char b = HEX_CHARS[buffer[i] & 0xF];
            sb.append(a);
            sb.append(b);
        }
        return sb.toString();
    }

    public static String[] split(String str, String delim) {
        int delimIndex;
        if (str == null || delim == null) {
            throw new NullPointerException("Cannot pass null arguments to tokenize");
        }
        if (delim.length() == 0) {
            throw new IllegalArgumentException("Delimiter can not be zero length");
        }
        ArrayList<Integer> l = new ArrayList<Integer>();
        int nextStartIndex = 0;
        while ((delimIndex = str.indexOf(delim, nextStartIndex)) != -1) {
            l.add(new Integer(delimIndex));
            nextStartIndex = delimIndex + delim.length();
        }
        l.add(new Integer(str.length()));
        String[] returnArray = new String[l.size()];
        int i = 0;
        int lastDelimStart = -delim.length();
        for (Integer thisDelimStartInteger : l) {
            int thisDelimStart = thisDelimStartInteger;
            returnArray[i] = str.substring(lastDelimStart + delim.length(), thisDelimStart);
            lastDelimStart = thisDelimStart;
            ++i;
        }
        return returnArray;
    }

    public static String capitalise(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() <= 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
    }

    public static String decapitalise(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() <= 1) {
            return str.toLowerCase();
        }
        if (Character.isUpperCase(str.charAt(1))) {
            return str;
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static String reverseCapitalisation(String str) {
        if (str == null) {
            return null;
        }
        if ("".equals(str)) {
            return str;
        }
        char first = str.charAt(0);
        if (Character.isLowerCase(first)) {
            return Character.toUpperCase(first) + str.substring(1);
        }
        return Character.toLowerCase(first) + str.substring(1);
    }

    public static String pluralise(String str) {
        if (str == null) {
            return null;
        }
        return str + "s";
    }

    public static String toSameInitialCase(String n, String template) {
        if (n == null) {
            throw new NullPointerException("String to convert cannot be null");
        }
        if (template == null) {
            return n;
        }
        StringBuffer sb = new StringBuffer();
        if (Character.isUpperCase(template.charAt(0))) {
            sb.append(Character.toUpperCase(n.charAt(0)));
        }
        if (Character.isLowerCase(template.charAt(0))) {
            sb.append(Character.toLowerCase(n.charAt(0)));
        }
        if (n.length() > 1) {
            sb.append(n.substring(1, n.length()));
        }
        return sb.toString();
    }

    public static synchronized String uniqueString() {
        return "" + differentNumber++;
    }

    public static synchronized void setNextUniqueNumber(long number) {
        differentNumber = number;
    }

    public static String duplicateQuotes(String s) {
        if (s.indexOf(39) == -1) {
            return s;
        }
        return s.replaceAll("'", "''");
    }

    public static String escapeWithBackslashes(String str) {
        String s = str;
        if (s.indexOf(92) != -1) {
            s = s.replace("\\", "\\\\");
        }
        if (s.indexOf(39) != -1) {
            s = s.replace("'", "\\'");
        }
        return s;
    }

    public static String escapeBackslash(String s) {
        if (s.indexOf(92) == -1) {
            return s;
        }
        return s.replaceAll("\\\\", "/");
    }

    public static String trimLeft(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return s.substring(i);
        }
        return s;
    }

    public static boolean allDigits(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i)) || '.' == s.charAt(i) || '-' == s.charAt(0)) continue;
            return false;
        }
        return true;
    }

    public static String prettyList(Collection<String> elements) {
        return StringUtil.prettyList(elements, false);
    }

    public static String prettyList(Collection<String> elements, boolean sort) {
        Collection<String> col = sort ? new TreeSet<String>(elements) : elements;
        StringBuffer sb = new StringBuffer();
        int pos = 1;
        for (String str : col) {
            sb.append(str);
            if (pos == col.size() - 1) {
                sb.append(" and ");
            } else if (pos < col.size()) {
                sb.append(", ");
            }
            ++pos;
        }
        return sb.toString();
    }

    public static String indefiniteArticle(String s) {
        String noun;
        ArrayList<Character> vowels = new ArrayList<Character>(Arrays.asList(Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('i'), Character.valueOf('o'), Character.valueOf('u')));
        if (vowels.contains(Character.valueOf((noun = s.trim()).charAt(0)))) {
            return "an";
        }
        ArrayList<Character> vowelPronounced = new ArrayList<Character>(Arrays.asList(Character.valueOf('A'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('X')));
        if (Character.isUpperCase(noun.charAt(0)) && (noun.length() == 1 || Character.isUpperCase(noun.charAt(1))) && vowelPronounced.contains(Character.valueOf(noun.charAt(0)))) {
            return "an";
        }
        return "a";
    }

    public static Map<String, String> serializedSortOrderToMap(String str) {
        String[] strArray;
        LinkedHashMap<String, String> returnMap = new LinkedHashMap<String, String>();
        for (String path : strArray = str.split("&")) {
            returnMap.put(StringUtils.split((String)path, (String)"[]=")[0], StringUtils.split((String)path, (String)"[]=")[1]);
        }
        return returnMap;
    }

    public static String colonsToDots(String in) {
        char[] array = in.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != ':') continue;
            array[i] = 46;
        }
        return new String(array);
    }

    public static String trimSlashes(String s) {
        if (s == null) {
            return null;
        }
        String formattedString = s;
        if (formattedString.startsWith("/")) {
            formattedString = formattedString.substring(1);
        }
        if (formattedString.endsWith("/")) {
            formattedString = formattedString.substring(0, formattedString.length() - 1);
        }
        if (formattedString.startsWith("/") || formattedString.endsWith("/")) {
            formattedString = StringUtil.trimSlashes(formattedString);
        }
        return formattedString;
    }

    public static LineWrappedString wrapLines(String input, int lineLength, int lineCount) {
        return StringUtil.wrapLines(input, lineLength, lineCount, 0);
    }

    public static LineWrappedString wrapLines(String input, int lineLength, int lineCount, int lastLineShorter) {
        String formattedString = input.trim();
        String trimmed = "";
        boolean truncated = false;
        for (int i = 1; i <= lineCount; ++i) {
            int breakPoint;
            if (i == lineCount) {
                if (formattedString.length() > lineLength - lastLineShorter) {
                    breakPoint = formattedString.lastIndexOf(" ", lineLength - 3 - lastLineShorter);
                    trimmed = breakPoint > lineLength / 2 ? trimmed + formattedString.substring(0, breakPoint) + "..." : trimmed + formattedString.substring(0, lineLength - 3 - lastLineShorter) + "...";
                    truncated = true;
                    continue;
                }
                trimmed = trimmed + formattedString;
                break;
            }
            if (formattedString.length() > lineLength) {
                breakPoint = formattedString.lastIndexOf(" ", lineLength);
                if (breakPoint > lineLength / 2) {
                    trimmed = trimmed + formattedString.substring(0, breakPoint) + "\n";
                    formattedString = formattedString.substring(breakPoint + 1);
                    continue;
                }
                trimmed = trimmed + formattedString.substring(0, lineLength - 1) + "-\n";
                formattedString = formattedString.substring(lineLength - 1);
                continue;
            }
            trimmed = trimmed + formattedString;
            break;
        }
        return new LineWrappedString(trimmed, truncated);
    }

    public static class LineWrappedString {
        private String wrapped;
        private boolean truncated;

        public LineWrappedString(String wrapped, boolean truncated) {
            this.wrapped = wrapped;
            this.truncated = truncated;
        }

        public String getString() {
            return this.wrapped;
        }

        public boolean isTruncated() {
            return this.truncated;
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof LineWrappedString) {
                LineWrappedString lws = (LineWrappedString)o;
                return this.wrapped.equals(lws.wrapped) && this.truncated == lws.truncated;
            }
            return false;
        }
    }
}

