/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.io.OutputStream;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.intermine.util.Shutdownable;

public final class ShutdownHook
extends Thread {
    private static final Logger LOG = Logger.getLogger(ShutdownHook.class);
    private static Stack<Object> objects = new Stack();
    private static ShutdownHook instance = new ShutdownHook();

    private ShutdownHook() {
    }

    public static synchronized void registerObject(Object object) {
        objects.push(object);
    }

    private static synchronized void shutdown() {
        while (!objects.empty()) {
            Object o = objects.pop();
            try {
                if (o instanceof WeakReference) {
                    o = ((WeakReference)o).get();
                }
                if (o instanceof Writer) {
                    ((Writer)o).flush();
                    ((Writer)o).close();
                    continue;
                }
                if (o instanceof OutputStream) {
                    ((OutputStream)o).flush();
                    ((OutputStream)o).close();
                    continue;
                }
                if (o instanceof Shutdownable) {
                    ((Shutdownable)o).shutdown();
                    continue;
                }
                if (o == null) continue;
                LOG.error((Object)("Do not know how to shut down " + o));
            }
            catch (Exception e) {
                LOG.error((Object)("Exception while shutting down " + o), (Throwable)e);
            }
        }
    }

    @Override
    public void run() {
        ShutdownHook.shutdown();
    }

    static {
        Runtime.getRuntime().addShutdownHook(instance);
    }
}

