/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.io.ByteArrayOutputStream;

public class SensibleByteArrayOutputStream
extends ByteArrayOutputStream {
    public SensibleByteArrayOutputStream() {
    }

    public SensibleByteArrayOutputStream(int size) {
        super(size);
    }

    @Override
    public synchronized void write(int b) {
        this.assureSize(this.count + 1);
        super.write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        this.assureSize(this.count + len);
        super.write(b, off, len);
    }

    public void assureSize(int newSize) {
        if (newSize > this.buf.length) {
            byte[] newBuf = new byte[Math.max(this.buf.length << 1, newSize + newSize / 10)];
            System.arraycopy(this.buf, 0, newBuf, 0, this.count);
            this.buf = newBuf;
        }
    }
}

