/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class ReferenceMap<K, V>
implements Map<K, V> {
    private static final Logger LOG = Logger.getLogger(ReferenceMap.class);
    protected static final NullValue NULL_VALUE = new NullValue();
    protected Map<K, Reference<Object>> subMap;
    protected ReferenceQueue<Object> queue = new ReferenceQueue();
    protected String name;

    private void expungeStaleEntries() {
        ReferenceWithKey r;
        int oldSize = this.subMap.size();
        while ((r = (ReferenceWithKey)((Object)this.queue.poll())) != null) {
            Object key = r.getKey();
            Reference<Object> ref = this.subMap.get(key);
            if (r != ref) continue;
            this.subMap.remove(key);
        }
        int newSize = this.subMap.size();
        if (newSize != oldSize) {
            LOG.debug((Object)(this.name + ": Expunged stale entries - size " + oldSize + " -> " + newSize));
        }
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.subMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        this.expungeStaleEntries();
        return this.subMap.keySet();
    }

    @Override
    public void clear() {
        this.expungeStaleEntries();
        this.subMap.clear();
    }

    @Override
    public V get(Object key) {
        this.expungeStaleEntries();
        Reference<Object> ref = this.subMap.get(key);
        if (ref != null) {
            Object value = ref.get();
            if (value instanceof NullValue) {
                return null;
            }
            return (V)value;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        this.expungeStaleEntries();
        if (this.subMap.containsKey(key)) {
            Reference<Object> ref = this.subMap.get(key);
            if (ref != null) {
                Object value = ref.get();
                return value != null;
            }
            return false;
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        Reference<Object> ref;
        this.expungeStaleEntries();
        Object v = value;
        if (v == null) {
            v = NULL_VALUE;
        }
        if ((ref = this.subMap.put(key, this.newRef(v, this.queue, key))) != null) {
            v = ref.get();
            if (v instanceof NullValue) {
                return null;
            }
            return v;
        }
        return null;
    }

    protected abstract Reference<Object> newRef(Object var1, ReferenceQueue<Object> var2, K var3);

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        this.expungeStaleEntries();
        Reference<Object> ref = this.subMap.remove(key);
        if (ref != null) {
            Object value = ref.get();
            if (value instanceof NullValue) {
                return null;
            }
            return (V)value;
        }
        return null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.subMap.toString();
    }

    private static class NullValue {
        NullValue() {
        }
    }

    protected static interface ReferenceWithKey<K> {
        public K getKey();
    }
}

