/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.intermine.util.NonOverrideableProperties;

public final class PropertiesUtil {
    private static final Logger LOG = Logger.getLogger(PropertiesUtil.class);
    private static Properties globalProperties = new Properties();

    private PropertiesUtil() {
    }

    public static Properties getProperties() {
        return globalProperties;
    }

    public static Properties getPropertiesStartingWith(String str, Properties props) {
        if (str == null) {
            throw new NullPointerException("str cannot be null, props param: " + props);
        }
        if (props == null) {
            throw new NullPointerException("props cannot be null, str param: " + str);
        }
        Properties subset = new Properties();
        Enumeration<Object> propertyEnum = props.keys();
        while (propertyEnum.hasMoreElements()) {
            String propertyName = (String)propertyEnum.nextElement();
            if (!propertyName.startsWith(str)) continue;
            subset.put(propertyName, props.get(propertyName));
        }
        return subset;
    }

    public static Properties getPropertiesStartingWith(String str) {
        return PropertiesUtil.getPropertiesStartingWith(str, globalProperties);
    }

    public static Properties stripStart(String prefix, Properties props) {
        if (prefix == null) {
            throw new NullPointerException("prefix cannot be null");
        }
        if (props == null) {
            throw new NullPointerException("props cannot be null");
        }
        Properties ret = new Properties();
        Enumeration<Object> propertyEnum = props.keys();
        while (propertyEnum.hasMoreElements()) {
            String propertyName = (String)propertyEnum.nextElement();
            if (!propertyName.startsWith(prefix + ".")) continue;
            ret.put(propertyName.substring(prefix.length() + 1), props.get(propertyName));
        }
        return ret;
    }

    public static String serialize(Properties props) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        props.store(baos, null);
        return baos.toString();
    }

    public static Properties loadProperties(String filename) {
        NonOverrideableProperties props = new NonOverrideableProperties();
        try {
            ClassLoader loader = PropertiesUtil.class.getClassLoader();
            InputStream is = loader.getResourceAsStream(filename);
            if (is == null) {
                LOG.error((Object)("Could not find file " + filename + " from " + loader));
                return null;
            }
            props.load(is);
            is.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load :" + filename, e);
        }
        return props;
    }

    static {
        try {
            InputStream is = PropertiesUtil.class.getClassLoader().getResourceAsStream("default.intermine.properties");
            if (is != null) {
                globalProperties.load(is);
            }
            if ((is = PropertiesUtil.class.getClassLoader().getResourceAsStream("intermine.properties")) == null) {
                throw new RuntimeException("intermine.properties is not in the classpath");
            }
            globalProperties.load(is);
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

