/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class ObjectPipe<E>
implements Iterator<E> {
    private LinkedList<E> list = new LinkedList();
    private boolean finished = false;
    private int maxBuffer = 1024;
    private int putters = 0;

    public ObjectPipe() {
    }

    public ObjectPipe(int maxBuffer) {
        if (maxBuffer < 1) {
            throw new IllegalArgumentException("Illegal value for maxBuffer: " + maxBuffer);
        }
        this.maxBuffer = maxBuffer;
    }

    public synchronized void put(E o) {
        ++this.putters;
        if (this.finished) {
            throw new IllegalArgumentException("Can't put onto a finished ObjectPipe");
        }
        while (this.list.size() >= this.maxBuffer) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.list.add(o);
        this.notifyAll();
        --this.putters;
    }

    public synchronized void putAll(Collection<? extends E> col) {
        ++this.putters;
        if (this.finished) {
            throw new IllegalArgumentException("Can't putAll onto a finished ObjectPipe");
        }
        while (this.list.size() >= this.maxBuffer) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.list.addAll(col);
        this.notifyAll();
        --this.putters;
    }

    public synchronized void finish() {
        if (this.finished) {
            throw new IllegalArgumentException("Can't finish a finished ObjectPipe");
        }
        while (this.putters > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.finished = true;
        this.notifyAll();
    }

    @Override
    public synchronized boolean hasNext() {
        while (!this.finished && this.list.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return !this.list.isEmpty();
    }

    @Override
    public synchronized E next() {
        while (!this.finished && this.list.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.notifyAll();
        return this.list.removeFirst();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported on an ObjectPipe");
    }
}

