/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intermine.util.MappingUtilChecker;

public final class MappingUtil {
    private static final MappingUtilChecker<Object> DEFAULT_CHECKER = new MappingUtilChecker<Object>(){

        @Override
        public boolean check(Map<Object, Object> map) {
            return true;
        }
    };

    private MappingUtil() {
    }

    public static <T> Set<Map<T, T>> findCombinations(Set<T> firstSet, Set<T> secondSet, Comparator<? super T> comparator) {
        return MappingUtil.findCombinations(firstSet, secondSet, comparator, DEFAULT_CHECKER);
    }

    public static <T> Set<Map<T, T>> findCombinations(Set<T> firstSet, Set<T> secondSet, Comparator<? super T> comparator, MappingUtilChecker<T> checker) {
        ArrayList<T> firstList = new ArrayList<T>(firstSet);
        ArrayList<T> secondList = new ArrayList<T>(secondSet);
        Set<Integer> takenSeconds = Collections.emptySet();
        Map soFar = Collections.emptyMap();
        LinkedHashSet<Map<T, T>> retval = new LinkedHashSet<Map<T, T>>();
        MappingUtil.findCombinations(retval, firstList, secondList, comparator, checker, soFar, 0, takenSeconds);
        return retval;
    }

    private static <T> void findCombinations(Set<Map<T, T>> retval, List<T> firstList, List<T> secondList, Comparator<? super T> comparator, MappingUtilChecker<T> checker, Map<T, T> soFar, int firstIndex, Set<Integer> takenSeconds) {
        if (firstIndex >= firstList.size()) {
            retval.add(soFar);
        } else {
            T firstElement = firstList.get(firstIndex);
            for (int i = 0; i < secondList.size(); ++i) {
                T secondElement;
                if (takenSeconds.contains(new Integer(i)) || comparator.compare(firstElement, secondElement = secondList.get(i)) != 0) continue;
                HashSet<Integer> newTakenSeconds = new HashSet<Integer>(takenSeconds);
                LinkedHashMap<T, T> newSoFar = new LinkedHashMap<T, T>(soFar);
                newTakenSeconds.add(new Integer(i));
                newSoFar.put(firstElement, secondElement);
                if (!checker.check(newSoFar)) continue;
                MappingUtil.findCombinations(retval, firstList, secondList, comparator, checker, newSoFar, firstIndex + 1, newTakenSeconds);
            }
        }
    }

    public static <T> Set<Set<Map<T, T>>> findMultipleCombinations(Set<Map<T, T>> combinations) {
        LinkedHashSet<Set<Map<T, T>>> retval = new LinkedHashSet<Set<Map<T, T>>>();
        LinkedHashSet<Map<T, T>> newCombinations = new LinkedHashSet<Map<T, T>>(combinations);
        LinkedHashSet<Map<T, T>> combinationsSoFar = new LinkedHashSet<Map<T, T>>();
        MappingUtil.recurseFindMultipleCombinations(retval, newCombinations, combinationsSoFar);
        return retval;
    }

    private static <T> void recurseFindMultipleCombinations(Set<Set<Map<T, T>>> retval, Set<Map<T, T>> combinations, Set<Map<T, T>> combinationsSoFar) {
        if (!combinations.isEmpty()) {
            Map<T, T> currentCombination = combinations.iterator().next();
            combinations.remove(currentCombination);
            LinkedHashSet<T> currentValues = new LinkedHashSet<T>();
            for (Map.Entry<T, T> valueEntry : currentCombination.entrySet()) {
                T value = valueEntry.getValue();
                currentValues.add(value);
            }
            boolean clashes = false;
            for (Map<T, T> map : combinationsSoFar) {
                Iterator<Map.Entry<T, T>> mapValueIter = map.entrySet().iterator();
                while (!clashes && mapValueIter.hasNext()) {
                    Map.Entry<T, T> mapValueEntry = mapValueIter.next();
                    T mapValue = mapValueEntry.getValue();
                    clashes = currentValues.contains(mapValue);
                }
            }
            if (!clashes) {
                combinationsSoFar.add(currentCombination);
                retval.add(new LinkedHashSet<Map<T, T>>(combinationsSoFar));
                MappingUtil.recurseFindMultipleCombinations(retval, combinations, combinationsSoFar);
                combinationsSoFar.remove(currentCombination);
            }
            MappingUtil.recurseFindMultipleCombinations(retval, combinations, combinationsSoFar);
            combinations.add(currentCombination);
        }
    }
}

