/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class IntToIntMap {
    private static final int INNER_MASK = 8191;
    private static final int OUTER_MASK = -8192;
    private static final int PAGE_SIZE = 8192;
    private Map<Integer, int[]> pages = new HashMap<Integer, int[]>();
    private int size = 0;

    public synchronized void put(int from, int to) {
        Integer pageNo = new Integer(from & 0xFFFFE000);
        int[] page = this.pages.get(pageNo);
        if (page == null) {
            page = new int[8193];
            for (int i = 0; i < 8192; ++i) {
                page[i] = -1;
            }
            page[8192] = 0;
            this.pages.put(pageNo, page);
        }
        int old = page[from & 0x1FFF];
        page[from & 0x1FFF] = to;
        if (old != -1) {
            --this.size;
            page[8192] = page[8192] - 1;
        }
        if (to != -1) {
            ++this.size;
            page[8192] = page[8192] + 1;
        }
        if (page[8192] == 0) {
            this.pages.remove(pageNo);
        }
    }

    public synchronized int get(int from) {
        Integer pageNo = new Integer(from & 0xFFFFE000);
        int[] page = this.pages.get(pageNo);
        if (page == null) {
            return -1;
        }
        return page[from & 0x1FFF];
    }

    public void put(Integer from, Integer to) {
        if (from == null) {
            throw new NullPointerException("from is null");
        }
        int iFrom = from;
        int iTo = -1;
        if (to != null && (iTo = to.intValue()) == -1) {
            throw new IllegalArgumentException("IntToIntMap cannot handle to = -1");
        }
        this.put(iFrom, iTo);
    }

    public Integer get(Integer from) {
        if (from == null) {
            throw new NullPointerException("from is null");
        }
        int iFrom = from;
        int to = this.get(iFrom);
        if (to == -1) {
            return null;
        }
        return new Integer(to);
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized void clear() {
        this.pages.clear();
        this.size = 0;
    }

    public synchronized String toString() {
        StringBuffer retval = new StringBuffer("{");
        boolean needComma = false;
        TreeSet<Integer> sortedKeys = new TreeSet<Integer>(this.pages.keySet());
        for (Integer pageNo : sortedKeys) {
            int pageNoInt = pageNo;
            int[] page = this.pages.get(pageNo);
            for (int i = 0; i < 8192; ++i) {
                if (page[i] == -1) continue;
                if (needComma) {
                    retval.append(", ");
                }
                needComma = true;
                retval.append(pageNoInt + i + " -> " + page[i]);
            }
        }
        retval.append("}");
        return retval.toString();
    }
}

