/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class IntPresentSet {
    private static final int WORD_SIZE = 32;
    private static final int WORD_MASK = 31;
    private static final int PAGE_SIZE = 8192;
    private static final int PAGE_MASK = 8191;
    private Map<Integer, int[]> pages = new HashMap<Integer, int[]>();
    private int size = 0;

    public void set(int i, boolean newBit) {
        int bitMask;
        int word;
        boolean oldBit;
        int bitNo = i & 0x1F;
        int wordNo = (i /= 32) & 0x1FFF;
        Integer pageNo = new Integer(i / 8192);
        int[] page = this.pages.get(pageNo);
        if (page == null) {
            page = new int[8193];
            for (int o = 0; o <= 8192; ++o) {
                page[o] = 0;
            }
            this.pages.put(pageNo, page);
        }
        boolean bl = oldBit = ((word = page[wordNo]) & (bitMask = 1 << bitNo)) != 0;
        if (oldBit != newBit) {
            if (newBit) {
                word |= bitMask;
                ++this.size;
                page[8192] = page[8192] + 1;
            } else {
                word &= ~bitMask;
                --this.size;
                page[8192] = page[8192] - 1;
            }
            page[wordNo] = word;
            if (page[8192] == 0) {
                this.pages.remove(pageNo);
            }
        }
    }

    public boolean contains(int i) {
        int bitNo = i & 0x1F;
        int wordNo = (i /= 32) & 0x1FFF;
        Integer pageNo = new Integer(i / 8192);
        int[] page = this.pages.get(pageNo);
        if (page == null) {
            return false;
        }
        int word = page[wordNo];
        int bitMask = 1 << bitNo;
        return (word & bitMask) != 0;
    }

    public void add(Integer i) {
        if (i == null) {
            throw new NullPointerException("i is null");
        }
        int iFrom = i;
        this.set(iFrom, true);
    }

    public boolean contains(Integer i) {
        if (i == null) {
            throw new NullPointerException("i is null");
        }
        int iFrom = i;
        return this.contains(iFrom);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.pages.clear();
        this.size = 0;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer("[");
        boolean needComma = false;
        TreeSet<Integer> sortedKeys = new TreeSet<Integer>(this.pages.keySet());
        for (Integer pageNo : sortedKeys) {
            int pageNoInt = pageNo;
            int[] page = this.pages.get(pageNo);
            for (int wordNo = 0; wordNo < 8192; ++wordNo) {
                int word = page[wordNo];
                if (word == 0) continue;
                int bitMask = 1;
                for (int bitNo = 0; bitNo < 32; ++bitNo) {
                    if ((word & bitMask) != 0) {
                        if (needComma) {
                            retval.append(", ");
                        }
                        needComma = true;
                        retval.append(Integer.toString((pageNoInt * 8192 + wordNo) * 32 + bitNo));
                    }
                    bitMask <<= 1;
                }
            }
        }
        retval.append("]");
        return retval.toString();
    }
}

