/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang.text.StrMatcher;
import org.apache.commons.lang.text.StrTokenizer;
import org.intermine.util.StringUtil;

public final class FormattedTextParser {
    private FormattedTextParser() {
    }

    public static Iterator<String[]> parseTabDelimitedReader(Reader reader) throws IOException {
        return FormattedTextParser.parseDelimitedReader(reader, false, "\t");
    }

    public static Iterator<String[]> parseTabDelimitedReader(Reader reader, boolean stripQuotes) throws IOException {
        return FormattedTextParser.parseDelimitedReader(reader, stripQuotes, "\t");
    }

    public static Iterator<String[]> parseCsvDelimitedReader(Reader reader) throws IOException {
        return FormattedTextParser.parseDelimitedReader(reader, true, ",");
    }

    public static Iterator<String[]> parseDelimitedReader(Reader reader, char delim) throws IOException {
        return FormattedTextParser.parseDelimitedReader(reader, false, String.valueOf(delim));
    }

    private static Iterator<String[]> parseDelimitedReader(final Reader reader, final boolean stripQuotes, final String delim) throws IOException {
        final BufferedReader bufferedReader = new BufferedReader(reader);
        return new Iterator<String[]>(){
            String currentLine = this.getNextNonCommentLine();

            @Override
            public boolean hasNext() {
                return this.currentLine != null;
            }

            @Override
            public String[] next() {
                if (this.currentLine == null) {
                    throw new NoSuchElementException();
                }
                String lastLine = this.currentLine;
                try {
                    this.currentLine = this.getNextNonCommentLine();
                }
                catch (IOException e) {
                    throw new RuntimeException("error while reading from " + reader, e);
                }
                if (stripQuotes) {
                    StrMatcher delimMatcher = null;
                    StrTokenizer tokeniser = null;
                    if (",".equals(delim)) {
                        delimMatcher = StrMatcher.commaMatcher();
                        tokeniser = new StrTokenizer(lastLine, delimMatcher, StrMatcher.doubleQuoteMatcher());
                    } else if ("\t".equals(delim)) {
                        delimMatcher = StrMatcher.tabMatcher();
                        tokeniser = new StrTokenizer(lastLine, delimMatcher, StrMatcher.doubleQuoteMatcher());
                    } else {
                        tokeniser = new StrTokenizer(lastLine, delim);
                    }
                    tokeniser.setEmptyTokenAsNull(false);
                    tokeniser.setIgnoreEmptyTokens(false);
                    return tokeniser.getTokenArray();
                }
                return StringUtil.split(lastLine, delim);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private String getNextNonCommentLine() throws IOException {
                String line = null;
                while ((line = bufferedReader.readLine()) != null && line.startsWith("#")) {
                }
                return line;
            }
        };
    }
}

