/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Factory;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.model.ShadowClass;
import org.intermine.util.DynamicBean;
import org.intermine.util.StringUtil;

public final class DynamicUtil {
    private static Map<Set<? extends Class<?>>, Class<? extends FastPathObject>> classMap = new HashMap();
    private static HashMap<Class<?>, Set<Class<?>>> decomposeMap = new HashMap();
    private static Map<Class<?>, String> friendlyNameMap = new HashMap();
    private static Map<Class<?>, String> simpleNameMap = new HashMap();

    private DynamicUtil() {
    }

    public static synchronized FastPathObject createObject(Set<? extends Class<?>> classes) {
        Object retval;
        Class<? extends FastPathObject> requiredClass = classMap.get(classes);
        if (requiredClass != null) {
            return DynamicUtil.createObject(requiredClass);
        }
        Class<?> clazz = null;
        HashSet interfaces = new HashSet();
        for (Class<?> cls : classes) {
            if (cls.isInterface()) {
                interfaces.add(cls);
                continue;
            }
            if (clazz == null || clazz.isAssignableFrom(cls)) {
                clazz = cls;
                continue;
            }
            if (cls.isAssignableFrom(clazz)) continue;
            throw new IllegalArgumentException("Cannot create a class from multiple classes: " + classes);
        }
        if (clazz != null && !FastPathObject.class.isAssignableFrom(clazz)) {
            throw new ClassCastException("Expected to create a FastPathObject, but was " + clazz.getName());
        }
        Class<?> fpclazz = clazz;
        if (fpclazz != null) {
            interfaces.removeAll(Arrays.asList(clazz.getInterfaces()));
        }
        if (interfaces.isEmpty()) {
            if (fpclazz == null) {
                throw new IllegalArgumentException("Cannot create an object without a class for: " + classes);
            }
            try {
                classMap.put(classes, fpclazz);
                return (FastPathObject)fpclazz.newInstance();
            }
            catch (InstantiationException e) {
                IllegalArgumentException e2 = new IllegalArgumentException("Problem running constructor");
                e2.initCause(e);
                throw e2;
            }
            catch (IllegalAccessException e) {
                IllegalArgumentException e2 = new IllegalArgumentException("Problem running constructor");
                e2.initCause(e);
                throw e2;
            }
        }
        if (fpclazz == null && interfaces.size() == 1) {
            try {
                retval = Class.forName(((Class)interfaces.iterator().next()).getName() + "Shadow");
                classMap.put(classes, (Class<? extends FastPathObject>)retval);
                return DynamicUtil.createObject(retval);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        retval = DynamicBean.create(fpclazz, interfaces.toArray(new Class[0]));
        classMap.put(classes, retval.getClass());
        return retval;
    }

    public static <C extends FastPathObject> C simpleCreateObject(Class<C> clazz) {
        FastPathObject retval = DynamicUtil.createObject(Collections.singleton(clazz));
        return (C)retval;
    }

    public static <C extends FastPathObject> C createObject(Class<C> clazz) {
        FastPathObject retval = null;
        try {
            retval = (FastPathObject)clazz.newInstance();
        }
        catch (Exception e) {
            IllegalArgumentException e2 = new IllegalArgumentException();
            e2.initCause(e);
            throw e2;
        }
        if (retval instanceof Factory) {
            ((Factory)retval).setCallback(0, (Callback)new DynamicBean());
        }
        return (C)retval;
    }

    public static Class<? extends FastPathObject> composeDescriptiveClass(Class<?> ... classes) {
        if (classes.length == 1) {
            if (!FastPathObject.class.isAssignableFrom(classes[0])) {
                throw new ClassCastException("Expected a FastPathObject class");
            }
            return classes[0];
        }
        return DynamicUtil.composeClass(new HashSet(Arrays.asList(classes)));
    }

    public static Class<? extends FastPathObject> composeClass(Class<?> ... classes) {
        return DynamicUtil.composeClass(new HashSet(Arrays.asList(classes)));
    }

    public static synchronized Class<? extends FastPathObject> composeClass(Set<Class<?>> classes) {
        Class<FastPathObject> retval = classMap.get(classes);
        if (retval == null) {
            retval = DynamicUtil.createObject(classes).getClass();
        }
        return retval;
    }

    protected static Set<Class<?>> convertToClasses(Set<String> names) throws ClassNotFoundException {
        HashSet classes = new HashSet();
        Iterator<String> iter = names.iterator();
        while (iter.hasNext()) {
            classes.add(Class.forName(iter.next()));
        }
        return classes;
    }

    public static synchronized Set<Class<?>> decomposeClass(Class<?> clazz) {
        Set<Class<?>> retval = decomposeMap.get(clazz);
        if (retval == null) {
            if (Factory.class.isAssignableFrom(clazz)) {
                retval = new TreeSet(new ClassNameComparator());
                retval.add(clazz.getSuperclass());
                Class<?>[] interfs = clazz.getInterfaces();
                for (int i = 0; i < interfs.length; ++i) {
                    Class<?> inter = interfs[i];
                    if (Factory.class == inter) continue;
                    boolean notIn = true;
                    Iterator<Class<?>> inIter = retval.iterator();
                    while (inIter.hasNext() && notIn) {
                        Class<?> in = inIter.next();
                        if (in.isAssignableFrom(inter)) {
                            inIter.remove();
                        }
                        if (!inter.isAssignableFrom(in)) continue;
                        notIn = false;
                    }
                    if (!notIn) continue;
                    retval.add(inter);
                }
            } else if (ShadowClass.class.isAssignableFrom(clazz)) {
                try {
                    retval = new TreeSet(new ClassNameComparator());
                    retval.add((Class)clazz.getField("shadowOf").get(null));
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException("ShadowClass " + clazz.getName() + " has no " + "shadowOf method", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(clazz.getName() + ".shadowOf method is inaccessible", e);
                }
            } else {
                retval = new TreeSet(new ClassNameComparator());
                retval.add(clazz);
            }
            decomposeMap.put(clazz, retval);
        }
        return retval;
    }

    public static FastPathObject instantiateObject(String className, String implementations) throws ClassNotFoundException {
        HashSet<String> classNames = new HashSet<String>();
        if (className != null && !"".equals(className) && !"".equals(className.trim())) {
            classNames.add(className.trim());
        }
        if (implementations != null) {
            classNames.addAll(StringUtil.tokenize(implementations));
        }
        if (classNames.size() == 0) {
            throw new RuntimeException("attempted to create an object without specifying any classes or interfaces");
        }
        return DynamicUtil.createObject(DynamicUtil.convertToClasses(classNames));
    }

    public static synchronized String getFriendlyName(Class<?> clazz) {
        String retval = friendlyNameMap.get(clazz);
        if (retval == null) {
            retval = "";
            Iterator<Class<?>> iter = DynamicUtil.decomposeClass(clazz).iterator();
            boolean needComma = false;
            while (iter.hasNext()) {
                Class<?> constit = iter.next();
                retval = retval + (needComma ? "," : "");
                needComma = true;
                retval = retval + constit.getName().substring(constit.getName().lastIndexOf(46) + 1);
            }
            friendlyNameMap.put(clazz, retval);
        }
        return retval;
    }

    public static String getFriendlyDesc(Object o) {
        if (o instanceof InterMineObject) {
            return DynamicUtil.getFriendlyName(o.getClass()) + ":" + ((InterMineObject)o).getId();
        }
        return o.toString();
    }

    public static synchronized String getSimpleClassName(Class<?> clazz) {
        String retval = simpleNameMap.get(clazz);
        if (retval == null) {
            Set<Class<?>> decomposedClass = DynamicUtil.decomposeClass(clazz);
            if (decomposedClass.size() > 1) {
                throw new IllegalArgumentException("No simple name for class: " + DynamicUtil.getFriendlyName(clazz));
            }
            retval = decomposedClass.iterator().next().getName();
            simpleNameMap.put(clazz, retval);
        }
        return retval;
    }

    public static synchronized String getSimpleClassName(FastPathObject obj) {
        return DynamicUtil.getSimpleClassName(obj.getClass());
    }

    public static boolean isAssignableFrom(Class<?> sup, Class<?> sub) {
        Set<Class<?>> classes = DynamicUtil.decomposeClass(sup);
        for (Class<?> clazz : classes) {
            if (clazz.isAssignableFrom(sub)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInstance(Object obj, Class<?> clazz) {
        return DynamicUtil.isAssignableFrom(clazz, obj.getClass());
    }

    public static Class<? extends FastPathObject> getSimpleClass(Class<? extends FastPathObject> clazz) {
        Set<Class<?>> decomposed = DynamicUtil.decomposeClass(clazz);
        if (decomposed.size() > 1) {
            throw new IllegalArgumentException("No simple class for " + DynamicUtil.getFriendlyName(clazz));
        }
        return decomposed.iterator().next();
    }

    public static Class<? extends FastPathObject> getSimpleClass(FastPathObject obj) {
        return DynamicUtil.getSimpleClass(obj.getClass());
    }

    private static class ClassNameComparator
    implements Comparator<Class<?>> {
        private ClassNameComparator() {
        }

        @Override
        public int compare(Class<?> a, Class<?> b) {
            return a.getName().compareTo(b.getName());
        }
    }
}

