/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.intermine.NotXmlRenderer;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.util.DynamicUtil;
import org.intermine.util.StringUtil;
import org.intermine.util.TypeUtil;

public class DynamicBean
implements MethodInterceptor {
    private Map<String, Object> map = new HashMap<String, Object>();

    public static FastPathObject create(Class<? extends FastPathObject> clazz, Class<?>[] inter) {
        if (clazz != null && clazz.isInterface()) {
            throw new IllegalArgumentException("clazz must not be an interface");
        }
        return (FastPathObject)Enhancer.create(clazz, (Class[])inter, (Callback)new DynamicBean());
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if ("equals".equals(method.getName())) {
            if (args[0] instanceof InterMineObject) {
                Integer otherId = ((InterMineObject)args[0]).getId();
                Integer thisId = (Integer)this.map.get("id");
                return thisId != null ? thisId.equals(otherId) : obj == args[0];
            }
            return Boolean.FALSE;
        }
        if ("hashCode".equals(method.getName())) {
            return this.map.get("id");
        }
        if ("finalize".equals(method.getName())) {
            return null;
        }
        if ("toString".equals(method.getName())) {
            return this.doToString(obj);
        }
        if ("getoBJECT".equals(method.getName()) && args.length == 0) {
            return NotXmlRenderer.render(obj);
        }
        if ("getFieldValue".equals(method.getName()) && args.length == 1) {
            String fieldName = (String)args[0];
            Serializable retval = this.map.get(fieldName);
            if (retval instanceof ProxyReference) {
                try {
                    retval = ((ProxyReference)((Object)retval)).getObject();
                }
                catch (NullPointerException e) {
                    NullPointerException e2 = new NullPointerException("Exception while calling " + method.getName() + "(\"" + args[0] + "\") on object with ID " + this.map.get("id"));
                    e2.initCause(e);
                    throw e2;
                }
                catch (Exception e) {
                    RuntimeException e2 = new RuntimeException("Exception while calling " + method.getName() + "(\"" + args[0] + "\") on object with ID " + this.map.get("id"));
                    e2.initCause(e);
                    throw e2;
                }
            }
            if (retval == null) {
                Class<?> fieldType = null;
                try {
                    String methodName = "get" + StringUtil.reverseCapitalisation((String)args[0]);
                    Method getMethod = obj.getClass().getMethod(methodName, new Class[0]);
                    fieldType = getMethod.getReturnType();
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("No such field " + args[0], e);
                }
                if (Collection.class.isAssignableFrom(fieldType)) {
                    retval = new HashSet();
                    this.map.put(fieldName, retval);
                }
                if (fieldType.isPrimitive()) {
                    if (Boolean.TYPE.equals(fieldType)) {
                        retval = Boolean.FALSE;
                    } else if (Short.TYPE.equals(fieldType)) {
                        retval = new Short(0);
                    } else if (Integer.TYPE.equals(fieldType)) {
                        retval = new Integer(0);
                    } else if (Long.TYPE.equals(fieldType)) {
                        retval = new Long(0L);
                    } else if (Float.TYPE.equals(fieldType)) {
                        retval = new Float(0.0);
                    } else if (Double.TYPE.equals(fieldType)) {
                        retval = new Double(0.0);
                    }
                    this.map.put(fieldName, retval);
                }
            }
            return retval;
        }
        if ("getFieldProxy".equals(method.getName()) && args.length == 1) {
            String fieldName = (String)args[0];
            Serializable retval = this.map.get(fieldName);
            if (retval == null) {
                Class<?> fieldType = null;
                try {
                    String methodName = "get" + StringUtil.reverseCapitalisation((String)args[0]);
                    Method getMethod = obj.getClass().getMethod(methodName, new Class[0]);
                    fieldType = getMethod.getReturnType();
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("No such field " + args[0], e);
                }
                if (Collection.class.isAssignableFrom(fieldType)) {
                    retval = new HashSet();
                    this.map.put(fieldName, retval);
                }
                if (fieldType.isPrimitive()) {
                    if (Boolean.TYPE.equals(fieldType)) {
                        retval = Boolean.FALSE;
                    } else if (Short.TYPE.equals(fieldType)) {
                        retval = new Short(0);
                    } else if (Integer.TYPE.equals(fieldType)) {
                        retval = new Integer(0);
                    } else if (Long.TYPE.equals(fieldType)) {
                        retval = new Long(0L);
                    } else if (Float.TYPE.equals(fieldType)) {
                        retval = new Float(0.0);
                    } else if (Double.TYPE.equals(fieldType)) {
                        retval = new Double(0.0);
                    }
                    this.map.put(fieldName, retval);
                }
            }
            return retval;
        }
        if ("setFieldValue".equals(method.getName()) && args.length == 2 && method.getReturnType() == Void.TYPE) {
            String fieldName = (String)args[0];
            this.map.put(fieldName, args[1]);
            return null;
        }
        if ("addCollectionElement".equals(method.getName()) && args.length == 2 && method.getReturnType() == Void.TYPE) {
            String fieldName = (String)args[0];
            HashSet<Object> col = (HashSet<Object>)this.map.get(fieldName);
            if (col == null) {
                col = new HashSet<Object>();
                this.map.put(fieldName, col);
            }
            col.add(args[1]);
            return null;
        }
        if ("getFieldType".equals(method.getName()) && args.length == 1) {
            try {
                String methodName = "get" + StringUtil.reverseCapitalisation((String)args[0]);
                Method getMethod = obj.getClass().getMethod(methodName, new Class[0]);
                return getMethod.getReturnType();
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("No such field " + args[0], e);
            }
        }
        if ("getElementType".equals(method.getName()) && args.length == 1) {
            Method[] methods;
            String methodName = "add" + StringUtil.reverseCapitalisation((String)args[0]);
            for (Method addMethod : methods = obj.getClass().getMethods()) {
                if (!addMethod.getName().equals(methodName)) continue;
                return addMethod.getParameterTypes()[0];
            }
            throw new RuntimeException("No such collection " + args[0]);
        }
        if (method.getName().startsWith("get") && args.length == 0) {
            HashSet retval = this.map.get(StringUtil.reverseCapitalisation(method.getName().substring(3)));
            if (retval instanceof ProxyReference) {
                try {
                    retval = ((ProxyReference)((Object)retval)).getObject();
                }
                catch (NullPointerException e) {
                    NullPointerException e2 = new NullPointerException("Exception while calling " + method.getName() + " on object with ID " + this.map.get("id"));
                    e2.initCause(e);
                    throw e2;
                }
                catch (Exception e) {
                    RuntimeException e2 = new RuntimeException("Exception while calling " + method.getName() + " on object with ID " + this.map.get("id"));
                    e2.initCause(e);
                    throw e2;
                }
            }
            if (retval == null && Collection.class.isAssignableFrom(method.getReturnType())) {
                retval = new HashSet();
                this.map.put(StringUtil.reverseCapitalisation(method.getName().substring(3)), retval);
            }
            return retval;
        }
        if (method.getName().startsWith("is") && args.length == 0) {
            return this.map.get(StringUtil.reverseCapitalisation(method.getName().substring(2)));
        }
        if (method.getName().startsWith("set") && args.length == 1 && method.getReturnType() == Void.TYPE) {
            this.map.put(StringUtil.reverseCapitalisation(method.getName().substring(3)), args[0]);
            return null;
        }
        if (method.getName().startsWith("proxy") && args.length == 1 && method.getReturnType() == Void.TYPE) {
            this.map.put(StringUtil.reverseCapitalisation(method.getName().substring(5)), args[0]);
            return null;
        }
        if (method.getName().startsWith("proxGet") && args.length == 0) {
            return this.map.get(StringUtil.reverseCapitalisation(method.getName().substring(7)));
        }
        if (method.getName().startsWith("add") && args.length == 1 && method.getReturnType() == Void.TYPE) {
            HashSet<Object> col = (HashSet<Object>)this.map.get(StringUtil.reverseCapitalisation(method.getName().substring(3)));
            if (col == null) {
                col = new HashSet<Object>();
                this.map.put(StringUtil.reverseCapitalisation(method.getName().substring(3)), col);
            }
            col.add(args[0]);
            return null;
        }
        throw new IllegalArgumentException("No definition for method " + method);
    }

    private String doToString(Object obj) {
        StringBuffer className = new StringBuffer();
        boolean needComma = false;
        Set<Class<?>> classes = DynamicUtil.decomposeClass(obj.getClass());
        for (Class<?> clazz : classes) {
            if (needComma) {
                className.append(",");
            }
            needComma = true;
            className.append(TypeUtil.unqualifiedName(clazz.getName()));
        }
        StringBuffer retval = new StringBuffer(className.toString() + " [");
        TreeMap<String, Object> sortedMap = new TreeMap<String, Object>(this.map);
        needComma = false;
        for (Map.Entry mapEntry : sortedMap.entrySet()) {
            String fieldName = (String)mapEntry.getKey();
            Object fieldValue = mapEntry.getValue();
            if (fieldValue instanceof Collection) continue;
            if (needComma) {
                retval.append(", ");
            }
            needComma = true;
            if (fieldValue instanceof ProxyReference) {
                retval.append(fieldName + "=" + ((ProxyReference)fieldValue).getId());
                continue;
            }
            if (fieldValue instanceof InterMineObject) {
                retval.append(fieldName + "=" + ((InterMineObject)fieldValue).getId());
                continue;
            }
            retval.append(fieldName + "=\"" + fieldValue + "\"");
        }
        return retval.toString() + "]";
    }

    public Map<String, Object> getMap() {
        return this.map;
    }
}

