/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.sf.cglib.proxy.Factory;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <K, V> LinkedHashMap<K, V> linkedHashMapAdd(LinkedHashMap<K, V> map, K prevKey, K newKey, V newValue) {
        if (prevKey == null) {
            LinkedHashMap<K, V> newMap = new LinkedHashMap<K, V>();
            newMap.put(newKey, newValue);
            newMap.putAll(map);
            return newMap;
        }
        if (!map.containsKey(prevKey)) {
            throw new IllegalArgumentException("LinkedHashMap does not contain: " + prevKey);
        }
        LinkedHashMap<K, V> newMap = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> mapEntry : map.entrySet()) {
            K key = mapEntry.getKey();
            V value = mapEntry.getValue();
            newMap.put(key, value);
            if (!key.equals(prevKey)) continue;
            newMap.put(newKey, newValue);
        }
        return newMap;
    }

    public static <E> Map<Class<?>, List<E>> groupByClass(Collection<E> objects, boolean inherit) {
        HashMap retval = new HashMap();
        for (E o : objects) {
            Class c = o.getClass();
            if (inherit) {
                HashSet<Class> done = new HashSet<Class>();
                done.add(Object.class);
                Stack todo = new Stack();
                todo.push(c);
                while (!todo.empty()) {
                    c = (Class)todo.pop();
                    if (c == null || done.contains(c)) continue;
                    done.add(c);
                    ArrayList<E> l = (ArrayList<E>)retval.get(c);
                    if (l == null) {
                        l = new ArrayList<E>();
                        retval.put(c, l);
                    }
                    l.add(o);
                    todo.push(c.getSuperclass());
                    Class<?>[] classes = c.getInterfaces();
                    for (int i = 0; i < classes.length; ++i) {
                        todo.push(classes[i]);
                    }
                }
                continue;
            }
            ArrayList<E> l = (ArrayList<E>)retval.get(c);
            if (l == null) {
                l = new ArrayList<E>();
                retval.put(c, l);
            }
            l.add(o);
        }
        return retval;
    }

    public static <E> Collection<List<E>> fanOutCombinations(List<Collection<E>> values) {
        ArrayList<List<E>> retval = new ArrayList<List<E>>();
        List soFar = Collections.emptyList();
        CollectionUtil.fanOutCombinations(values, retval, soFar, 0);
        return retval;
    }

    private static <E> void fanOutCombinations(List<Collection<E>> values, Collection<List<E>> retval, List<E> soFar, int index) {
        if (index == values.size() - 1) {
            for (E value : values.get(index)) {
                ArrayList<E> solution = new ArrayList<E>(soFar);
                solution.add(value);
                retval.add(solution);
            }
        } else {
            for (E value : values.get(index)) {
                ArrayList<E> solution = new ArrayList<E>(soFar);
                solution.add(value);
                CollectionUtil.fanOutCombinations(values, retval, solution, index + 1);
            }
        }
    }

    public static Set<Class<?>> findCommonSuperclasses(Collection<Class<?>> classes) {
        HashSet<Class> all = new HashSet<Class>();
        for (Class<?> clazz : classes) {
            Stack stack = new Stack();
            stack.push(clazz);
            while (!stack.empty()) {
                Class clazz2 = (Class)stack.pop();
                if (Factory.class.equals((Object)clazz2) || all.contains(clazz2)) continue;
                all.add(clazz2);
                Class superClass = clazz2.getSuperclass();
                if (superClass != null) {
                    stack.push(superClass);
                }
                for (Class<?> e : clazz2.getInterfaces()) {
                    stack.push(e);
                }
            }
        }
        Iterator iter = all.iterator();
        block3: while (iter.hasNext()) {
            Class clazz = (Class)iter.next();
            for (Class<Object> clazz3 : classes) {
                if (clazz.isAssignableFrom(clazz3)) continue;
                iter.remove();
                continue block3;
            }
        }
        HashSet hashSet = new HashSet();
        for (Class<Object> clazz : all) {
            boolean needed = true;
            for (Class clazz4 : all) {
                if (!clazz.isAssignableFrom(clazz4) || clazz.equals(clazz4)) continue;
                needed = false;
                break;
            }
            if (!needed) continue;
            hashSet.add(clazz);
        }
        return hashSet;
    }

    public static Class<?> findCommonSuperclass(Collection<Class<?>> classes) {
        return CollectionUtil.findCommonSuperclasses(classes).iterator().next();
    }
}

