/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.task;

import java.util.Properties;
import java.util.Random;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.intermine.metadata.Model;
import org.intermine.modelproduction.MetadataManager;
import org.intermine.sql.Database;
import org.intermine.sql.DatabaseFactory;
import org.intermine.util.PropertiesUtil;

public class StoreMetadataTask
extends Task {
    protected String modelName;
    protected String database;
    protected String osName;

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setOsName(String osname) {
        this.database = PropertiesUtil.getProperties().getProperty(osname + ".db");
        this.osName = osname;
    }

    public void execute() {
        if (this.modelName == null) {
            throw new BuildException("modelName attribute is not set");
        }
        if (this.database == null) {
            throw new BuildException("database attribute is not set");
        }
        try {
            Database db = DatabaseFactory.getDatabase(this.database);
            Model model = MetadataManager.loadModel(this.modelName);
            MetadataManager.store(db, "model", model.toString());
            Properties keys = MetadataManager.loadKeyDefinitions(this.modelName);
            if (keys == null) {
                throw new BuildException("no keys for " + this.modelName + " model found to store in the ObjectStore");
            }
            MetadataManager.store(db, "keyDefs", PropertiesUtil.serialize(keys));
            Properties props = PropertiesUtil.getPropertiesStartingWith(this.osName);
            props = PropertiesUtil.stripStart(this.osName, props);
            String missingTablesString = props.getProperty("missingTables");
            String truncatedClassesString = props.getProperty("truncatedClasses");
            String noNotXmlString = props.getProperty("noNotXml");
            boolean noNotXml = false;
            if ("true".equals(noNotXmlString) || noNotXmlString == null) {
                noNotXml = true;
            } else if ("false".equals(noNotXmlString)) {
                noNotXml = false;
            } else {
                throw new BuildException("Invalid value for property noNotXml: " + noNotXmlString);
            }
            MetadataManager.store(db, "osversion", "1");
            if (truncatedClassesString != null) {
                MetadataManager.store(db, "truncatedClasses", truncatedClassesString);
            }
            if (missingTablesString != null) {
                MetadataManager.store(db, "missingTables", missingTablesString);
            }
            MetadataManager.store(db, "noNotXml", "" + noNotXml);
            MetadataManager.store(db, "serialNumber", Long.toString(new Random().nextLong()));
        }
        catch (Exception e) {
            if (e instanceof BuildException) {
                throw (BuildException)((Object)e);
            }
            throw new BuildException((Throwable)e);
        }
    }
}

