/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.task;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.intermine.metadata.Model;
import org.intermine.modelproduction.MetadataManager;
import org.intermine.modelproduction.xml.InterMineModelParser;
import org.intermine.sql.Database;
import org.intermine.sql.DatabaseFactory;
import org.intermine.util.PropertiesUtil;

public class RetrieveMetadataTask
extends Task {
    protected File destDir;
    protected String database;
    protected String osname;
    private String keyToRetrieve;

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setOsName(String osname) {
        this.osname = osname;
        this.database = PropertiesUtil.getProperties().getProperty(osname + ".db");
    }

    public void setKeyToRetreive(String keyToRetrieve) {
        this.keyToRetrieve = keyToRetrieve;
    }

    public void execute() {
        if (this.destDir == null) {
            throw new BuildException("destDir attribute is not set");
        }
        if (this.osname == null) {
            throw new BuildException("osname attribute is not set");
        }
        if (this.database == null) {
            throw new BuildException("couldn't find database property: " + this.osname + ".db - " + "osName property is: " + this.osname);
        }
        try {
            Database db = DatabaseFactory.getDatabase(this.database);
            if (this.keyToRetrieve == null) {
                String modelXml = MetadataManager.retrieve(db, "model");
                String keyDefs = MetadataManager.retrieve(db, "keyDefs");
                Model model = new InterMineModelParser().process(new StringReader(modelXml));
                File localModel = new File(this.destDir, MetadataManager.getFilename("model", model.getName()));
                if (keyDefs != null) {
                    MetadataManager.saveKeyDefinitions(keyDefs, this.destDir, model.getName());
                }
                if (localModel.exists() && IOUtils.contentEquals((Reader)new FileReader(localModel), (Reader)new StringReader(modelXml))) {
                    System.err.println("Model in database is identical to local model.");
                    return;
                }
                MetadataManager.saveModel(model, this.destDir);
            } else {
                String objectStoreSummary = MetadataManager.retrieve(db, "objectStoreSummary");
                MetadataManager.saveProperties(objectStoreSummary, this.destDir, "objectstoresummary.properties");
            }
        }
        catch (Exception e) {
            System.err.println("Failed to retrieve metadata from " + this.database + " - maybe you need to run build-db?");
            throw new BuildException((Throwable)e);
        }
    }
}

