/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.task;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.intermine.metadata.Model;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStoreFactory;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.objectstore.intermine.ParallelPrecomputer;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCloner;
import org.intermine.objectstore.query.iql.IqlQuery;
import org.intermine.objectstore.querygen.QueryGenUtil;

public class PrecomputeTask
extends Task {
    private static final Logger LOG = Logger.getLogger(PrecomputeTask.class);
    protected static final int THREAD_COUNT = 4;
    protected String alias;
    protected int minRows = -1;

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setMinRows(Integer minRows) {
        this.minRows = minRows;
    }

    public void execute() {
        ObjectStore os;
        if (this.alias == null) {
            throw new BuildException("alias attribute is not set");
        }
        if (this.minRows == -1) {
            throw new BuildException("minRows attribute is not set");
        }
        try {
            os = ObjectStoreFactory.getObjectStore(this.alias);
        }
        catch (Exception e) {
            throw new BuildException("Exception while creating ObjectStore", (Throwable)e);
        }
        if (!(os instanceof ObjectStoreInterMineImpl)) {
            throw new BuildException(this.alias + " isn't an ObjectStoreInterMineImpl");
        }
        this.precompute(false, os, this.minRows);
    }

    public void precompute(boolean createAllOrders, ObjectStore os, int minRows) {
        Properties properties = PrecomputeTask.readProperties(os.getModel().getName());
        Map<String, List<Query>> pq = PrecomputeTask.getPrecomputeQueries(createAllOrders, os, properties);
        LOG.info((Object)("pq.size(): " + pq.size()));
        ArrayList<ParallelPrecomputer.Job> jobs = new ArrayList<ParallelPrecomputer.Job>();
        for (Map.Entry<String, List<Query>> entry : pq.entrySet()) {
            String key = entry.getKey();
            String value = properties.getProperty(key);
            List<Query> queries = entry.getValue();
            LOG.debug((Object)("queries: " + queries.size()));
            for (Query query : queries) {
                LOG.info((Object)("key: " + key));
                jobs.add(new ParallelPrecomputer.Job(key, query, null, !value.contains(" ORDER BY "), "PrecomputeTask"));
            }
        }
        ParallelPrecomputer pp = this.getPrecomputer((ObjectStoreInterMineImpl)os);
        pp.setMinRows(minRows);
        try {
            pp.precompute(jobs);
        }
        catch (ObjectStoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected ParallelPrecomputer getPrecomputer(ObjectStoreInterMineImpl os) {
        return new ParallelPrecomputer(os, 4);
    }

    private static Map<String, List<Query>> getPrecomputeQueries(boolean createAllOrders, ObjectStore os, Properties precomputeProperties) {
        TreeMap<String, List<Query>> returnMap = new TreeMap<String, List<Query>>();
        for (Object precomputeKeyObj : new TreeSet<Object>(precomputeProperties.keySet())) {
            String precomputeKey = (String)precomputeKeyObj;
            String value = (String)precomputeProperties.get(precomputeKey);
            if (precomputeKey.startsWith("precompute.query")) {
                String iqlQueryString = value;
                Query query = PrecomputeTask.parseQuery(os.getModel(), iqlQueryString, precomputeKey);
                ArrayList<Query> list = new ArrayList<Query>();
                list.add(query);
                returnMap.put(precomputeKey, list);
                continue;
            }
            if (precomputeKey.startsWith("precompute.constructquery")) {
                try {
                    List<Query> constructedQueries = PrecomputeTask.constructQueries(createAllOrders, os, value, precomputeKey);
                    returnMap.put(precomputeKey, constructedQueries);
                    continue;
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
            throw new BuildException("unknown key: '" + precomputeKey + "' in properties file " + PrecomputeTask.getPropertiesFileName(os.getModel().getName()));
        }
        return returnMap;
    }

    protected static List<Query> constructQueries(boolean createAllOrders, ObjectStore os, String path, String precomputeKey) throws ClassNotFoundException, ObjectStoreException {
        ArrayList<Query> queries = new ArrayList<Query>();
        Set<String> paths = QueryGenUtil.expandPath(os, path);
        for (String nextPath : paths) {
            LOG.info((Object)("Expanded path for id " + precomputeKey + " to \"" + nextPath + "\""));
            Query q = QueryGenUtil.constructQuery(os.getModel(), nextPath);
            if (createAllOrders) {
                queries.addAll(PrecomputeTask.getOrderedQueries(q));
                continue;
            }
            queries.add(q);
        }
        return queries;
    }

    private static List<Query> getOrderedQueries(Query q) {
        ArrayList<Query> queryList = new ArrayList<Query>();
        Set<int[]> permutations = PrecomputeTask.permutations(q.getEffectiveOrderBy().size());
        for (int[] order : permutations) {
            Query newQuery = QueryCloner.cloneQuery(q);
            ArrayList<Object> orderBy = new ArrayList<Object>(newQuery.getEffectiveOrderBy());
            newQuery.clearOrderBy();
            for (int i = 0; i < order.length; ++i) {
                newQuery.addToOrderBy((QueryClass)orderBy.get(order[i]));
            }
            queryList.add(newQuery);
        }
        return queryList;
    }

    private static Query parseQuery(Model model, String iqlQueryString, String key) {
        IqlQuery iqlQuery = new IqlQuery(iqlQueryString, model.getPackageName());
        try {
            return iqlQuery.toQuery();
        }
        catch (IllegalArgumentException e) {
            throw new BuildException("Exception while parsing query: " + key + " = " + iqlQueryString, (Throwable)e);
        }
    }

    private static Properties readProperties(String modelName) {
        String propertiesFileName = PrecomputeTask.getPropertiesFileName(modelName);
        try {
            InputStream is = PrecomputeTask.class.getClassLoader().getResourceAsStream(propertiesFileName);
            if (is == null) {
                throw new BuildException("Cannot find " + propertiesFileName + " in the class path");
            }
            Properties precomputeProperties = new Properties();
            precomputeProperties.load(is);
            return precomputeProperties;
        }
        catch (IOException e) {
            throw new BuildException("Exception while reading properties from " + propertiesFileName, (Throwable)e);
        }
    }

    protected static String getPropertiesFileName(String modelName) {
        return modelName + "_precompute.properties";
    }

    private static Set<int[]> permutations(int n) {
        LinkedHashSet<int[]> result = new LinkedHashSet<int[]>();
        int[] array = new int[n];
        for (int i = 0; i < n; ++i) {
            array[i] = i;
        }
        PrecomputeTask.enumerate(result, array, n);
        return result;
    }

    private static void swap(int[] array, int i, int j) {
        int tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    private static void enumerate(Set<int[]> result, int[] array, int n) {
        if (n == 1) {
            int[] copy = new int[array.length];
            System.arraycopy(array, 0, copy, 0, array.length);
            result.add(copy);
            return;
        }
        for (int i = 0; i < n; ++i) {
            PrecomputeTask.swap(array, i, n - 1);
            PrecomputeTask.enumerate(result, array, n - 1);
            PrecomputeTask.swap(array, i, n - 1);
        }
    }
}

