/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.task;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.intermine.metadata.MetaDataException;
import org.intermine.metadata.Model;
import org.intermine.modelproduction.ModelFileMerger;
import org.intermine.modelproduction.xml.InterMineModelParser;

public class ModelMergerTask
extends Task {
    protected List<File> additionsFiles = new ArrayList<File>();
    protected File inputModelFile;
    protected File outputModelFile;

    public void setInputModelFile(File file) {
        this.inputModelFile = file;
    }

    public void setAdditionsFile(File file) {
        this.additionsFiles.add(file);
    }

    public void setAdditionsFiles(List<File> files) {
        this.additionsFiles = files;
    }

    public void setOutputFile(File file) {
        this.outputModelFile = file;
    }

    public void execute() {
        Model mergedModel;
        InterMineModelParser parser = new InterMineModelParser();
        try {
            mergedModel = ModelFileMerger.mergeModelFromFiles(this.inputModelFile, this.additionsFiles, parser);
        }
        catch (MetaDataException e) {
            throw new BuildException("Failed to parse model from input files", (Throwable)e);
        }
        try {
            FileWriter writer = new FileWriter(this.outputModelFile);
            writer.write(mergedModel.toString());
            writer.close();
        }
        catch (IOException e) {
            throw new BuildException("failed to write model file: " + this.outputModelFile, (Throwable)e);
        }
    }
}

