/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.task;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class DynamicAttributeTask
extends Task {
    protected static final Logger LOG = Logger.getLogger(DynamicAttributeTask.class);

    protected void configureDynamicAttributes(Object bean) {
        Project antProject = this.getProject();
        Hashtable projectProps = antProject.getProperties();
        PropertyDescriptor[] props = PropertyUtils.getPropertyDescriptors((Object)bean);
        for (int i = 0; i < props.length; ++i) {
            String camelCasePropName;
            String setterName;
            PropertyDescriptor desc = props[i];
            Method setter = desc.getWriteMethod();
            if (setter == null) continue;
            Class<?> propType = desc.getPropertyType();
            String propName = setter.getName().substring(3).toLowerCase();
            Object propValue = projectProps.get(propName);
            if (propValue == null) {
                setterName = setter.getName();
                propName = camelCasePropName = setterName.substring(3, 4).toLowerCase() + setterName.substring(4);
                propValue = projectProps.get(camelCasePropName);
            }
            if (propValue == null) {
                setterName = setter.getName();
                camelCasePropName = setterName.substring(3, 4).toLowerCase() + setterName.substring(4);
                String dotName = "";
                for (int j = 0; j < camelCasePropName.length(); ++j) {
                    dotName = Character.isUpperCase(camelCasePropName.charAt(j)) ? dotName + "." + camelCasePropName.substring(j, j + 1).toLowerCase() : dotName + camelCasePropName.substring(j, j + 1);
                }
                propValue = projectProps.get(dotName);
            }
            if (propValue == null) continue;
            try {
                if (propType.equals(File.class)) {
                    String filePropValue = (String)propValue;
                    File maybeFile = new File(filePropValue);
                    if (maybeFile.exists()) {
                        propValue = maybeFile;
                        LOG.info((Object)("Configuring task to use file:" + filePropValue));
                    } else {
                        propValue = this.getProject().resolveFile(filePropValue);
                    }
                }
                PropertyUtils.setProperty((Object)bean, (String)propName, propValue);
                continue;
            }
            catch (Exception e) {
                throw new BuildException("failed to set value for " + propName + " to " + propValue + " in " + bean, (Throwable)e);
            }
        }
    }
}

