/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.torque.task.TorqueSQLExec;
import org.intermine.sql.Database;
import org.intermine.sql.DatabaseFactory;
import org.intermine.sql.DatabaseUtil;
import org.intermine.task.InsertSQL;
import org.intermine.task.SQL;
import org.intermine.util.PropertiesUtil;

public class BuildDbTask
extends Task {
    private static final Logger LOG = Logger.getLogger(BuildDbTask.class);
    protected static final String SERIAL_SEQUENCE_NAME = "serial";
    protected File tempDir;
    protected Database database;
    protected String databaseAlias;
    protected String schemaFile;
    private String os;
    private String model;

    public void setOsName(String os) {
        this.os = os;
        try {
            this.databaseAlias = PropertiesUtil.getProperties().getProperty(os + ".db");
            this.database = DatabaseFactory.getDatabase(this.databaseAlias);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setTempdir(File tempDir) {
        this.tempDir = tempDir;
    }

    public void setSchemafile(String schemafile) {
        this.schemaFile = schemafile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        File tempFile;
        if (this.tempDir == null) {
            throw new BuildException("tempDir attribute is not set");
        }
        if (this.databaseAlias == null) {
            throw new BuildException("Could not find database attribute for: '" + this.os + ".db'");
        }
        if (this.database == null) {
            throw new BuildException("Could not access database: " + this.databaseAlias);
        }
        if (this.schemaFile == null) {
            throw new BuildException("schemaFile attribute is not set");
        }
        Connection c = null;
        try {
            c = this.database.getConnection();
            c.setAutoCommit(true);
            DatabaseUtil.removeAllTables(c);
        }
        catch (SQLException e) {
            LOG.warn((Object)("Failed to remove all tables from database: " + e));
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (SQLException e) {}
            }
        }
        SQL sql = new SQL();
        sql.setControlTemplate("sql/base/Control.vm");
        sql.setOutputDirectory(this.tempDir);
        sql.setUseClasspath(true);
        sql.setSqlDbMap(this.tempDir + "/sqldb.map");
        sql.setOutputFile("report.sql.generation");
        sql.setTargetDatabase(this.database.getPlatform().toLowerCase());
        InputStream schemaFileInputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.schemaFile);
        if (schemaFileInputStream == null) {
            throw new BuildException("cannot open schema file (" + this.schemaFile + ")");
        }
        try {
            String line;
            tempFile = File.createTempFile("schema", "xml", this.tempDir);
            PrintWriter writer = new PrintWriter(new FileWriter(tempFile));
            BufferedReader reader = new BufferedReader(new InputStreamReader(schemaFileInputStream));
            while ((line = reader.readLine()) != null) {
                writer.println(line);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new BuildException("cannot create temporary file for BuildDbTask: " + e.getMessage());
        }
        sql.setXmlFile(tempFile.getPath());
        sql.execute();
        InsertSQL isql = new InsertSQL();
        isql.setDriver(this.database.getDriver());
        isql.setUrl(this.database.getURL());
        isql.setUserid(this.database.getUser());
        isql.setPassword(this.database.getPassword());
        isql.setAutocommit(true);
        TorqueSQLExec.OnError ea = new TorqueSQLExec.OnError();
        ea.setValue("continue");
        isql.setOnerror(ea);
        isql.setSqlDbMap(this.tempDir + "/sqldb.map");
        isql.setSrcDir(this.tempDir.toString());
        try {
            isql.execute();
        }
        catch (BuildException e) {
            throw new BuildException(e.getMessage() + " - for database: " + this.databaseAlias, e.getCause());
        }
        ea.setValue("abort");
        isql.execute();
        Connection c2 = null;
        try {
            c2 = this.database.getConnection();
            c2.setAutoCommit(true);
            c2.createStatement().execute("CREATE SEQUENCE serial");
        }
        catch (SQLException e) {
            LOG.info((Object)("Failed to create SEQUENCE: " + e));
        }
        finally {
            if (c2 != null) {
                try {
                    c2.close();
                }
                catch (SQLException e) {}
            }
        }
        c2 = null;
        try {
            c2 = this.database.getConnection();
            c2.setAutoCommit(true);
            c2.createStatement().execute("CREATE SEQUENCE objectstore_unique_integer");
        }
        catch (SQLException e) {
            LOG.info((Object)("Failed to create SEQUENCE: " + e));
        }
        finally {
            if (c2 != null) {
                try {
                    c2.close();
                }
                catch (SQLException e) {}
            }
        }
        c2 = null;
        try {
            c2 = this.database.getConnection();
            c2.setAutoCommit(true);
            c2.createStatement().execute("ALTER TABLE clob ALTER COLUMN value SET STORAGE PLAIN");
        }
        catch (SQLException e) {
            LOG.info((Object)("Failed to create SEQUENCE: " + e));
        }
        finally {
            if (c2 != null) {
                try {
                    c2.close();
                }
                catch (SQLException e) {}
            }
        }
        tempFile.delete();
        if (this.model.contains("userprofile")) {
            c2 = null;
            try {
                c2 = this.database.getConnection();
                c2.setAutoCommit(true);
                DatabaseUtil.createBagValuesTables(c2);
            }
            catch (SQLException e) {
                LOG.info((Object)("Failed to create bagvalues table: " + e));
            }
            finally {
                if (c2 != null) {
                    try {
                        c2.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
    }
}

