/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.Model;
import org.intermine.sql.Database;
import org.intermine.sql.DatabaseFactory;
import org.intermine.sql.DatabaseUtil;
import org.intermine.util.PropertiesUtil;

public class AnalyseDbTask
extends Task {
    protected String database;
    protected boolean full = false;
    protected String clsName;
    protected String model;

    public void setOsName(String osName) {
        this.database = PropertiesUtil.getProperties().getProperty(osName + ".db");
    }

    public void setClassName(String clsName) {
        this.clsName = clsName;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setFull(boolean full) {
        this.full = full;
    }

    public void execute() {
        if (this.database == null) {
            throw new BuildException("database attribute is not set");
        }
        try {
            Database db = DatabaseFactory.getDatabase(this.database);
            if (this.clsName != null && !"".equals(this.clsName)) {
                if (this.model == null) {
                    throw new BuildException("model attribute is not set");
                }
                Model m = Model.getInstanceByName(this.model);
                ClassDescriptor cld = m.getClassDescriptorByName(this.clsName);
                if (cld == null) {
                    throw new BuildException("class does not exist in model: " + this.clsName);
                }
                DatabaseUtil.analyse(db, cld, this.full);
            } else {
                DatabaseUtil.analyse(db, this.full);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

