/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.task;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.intermine.sql.Database;
import org.intermine.sql.DatabaseFactory;
import org.intermine.task.AcceptanceTest;
import org.intermine.task.AcceptanceTestResult;

public class AcceptanceTestTask
extends Task {
    private String database;
    private File outputFile;
    private File configFile;
    public static final String TRAC_TICKET_URL_PREFIX = "http://intrac.flymine.org/ticket/";

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void execute() {
        if (this.database == null) {
            throw new BuildException("database attribute is not set");
        }
        if (this.configFile == null) {
            throw new BuildException("configFile attribute is not set");
        }
        if (this.outputFile == null) {
            throw new BuildException("outputFile attribute is not set");
        }
        try {
            FileWriter fw;
            Database db = DatabaseFactory.getDatabase(this.database);
            System.err.println("Processing configuration file: " + this.configFile.getCanonicalPath());
            LineNumberReader reader = new LineNumberReader(new FileReader(this.configFile));
            List<AcceptanceTestResult> testResults = this.runAllTests(db, reader);
            try {
                fw = new FileWriter(this.outputFile);
            }
            catch (IOException e) {
                throw new BuildException("failed to open output file: " + this.outputFile, (Throwable)e);
            }
            PrintWriter pw = new PrintWriter(fw);
            this.processResults(testResults, pw);
            try {
                fw.close();
            }
            catch (IOException e) {
                throw new BuildException("couldn't close " + this.outputFile, (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected List<AcceptanceTestResult> runAllTests(Database db, LineNumberReader configReader) throws IOException, SQLException {
        Connection con = db.getConnection();
        ArrayList<AcceptanceTestResult> testResults = new ArrayList<AcceptanceTestResult>();
        try {
            AcceptanceTest test;
            while ((test = AcceptanceTestTask.readOneTestConfig(configReader)) != null) {
                AcceptanceTestResult testResult = this.runTest(con, test);
                testResults.add(testResult);
            }
        }
        catch (FileNotFoundException e) {
            throw new BuildException("problem reading file - file not found: " + this.configFile, (Throwable)e);
        }
        return testResults;
    }

    protected void processResults(List<AcceptanceTestResult> testResults, PrintWriter pw) {
        pw.println("<html>");
        pw.println("<head><title>Acceptance Test Results</title></head>");
        pw.println("<body>");
        pw.println("<h2>Acceptance Test Results</h2>");
        int testCount = 0;
        int failingTestsCount = 0;
        for (AcceptanceTestResult atr : testResults) {
            if (!atr.isSuccessful()) {
                ++failingTestsCount;
            }
            ++testCount;
        }
        pw.println("<h3>Total tests: " + testCount + "</h3>");
        if (testCount == 0) {
            pw.println("</body></html>");
            return;
        }
        pw.println("<h3>Failing tests: " + failingTestsCount + "</h3>");
        pw.println("<h3>Percentage passed: " + 100 * (testCount - failingTestsCount) / testCount + "%</h3>");
        int count = 0;
        if (failingTestsCount > 0) {
            pw.println("<hr/><h3>Failing tests:</h3>");
            pw.println("<p>");
            pw.println("<ul>");
            for (AcceptanceTestResult atr : testResults) {
                if (!atr.isSuccessful()) {
                    pw.println("<li><a href=\"#test" + count + "\">");
                    pw.println(atr.getTest().getSql());
                    pw.println("</a><p><font size='-1'>(" + atr.getTest().getNote() + ")</font></p></li>");
                }
                ++count;
            }
            pw.println("</ul>");
        }
        pw.println("</p><hr/>");
        count = 0;
        for (AcceptanceTestResult atr : testResults) {
            pw.println("<h2><a name=\"test" + count + "\">Testing: <font size=\"-1\">" + atr.getTest().getSql() + "</font></a></h2>");
            pw.println("<h3>test type: " + atr.getTest().getType() + "</h3>");
            pw.println("<p>(completed in " + (double)atr.getTime() / 1000.0 + " seconds)</p>");
            if (atr.getTest().getNote() != null) {
                String hyperlinkedDescription = AcceptanceTestTask.hyperLinkNote(atr.getTest().getNote());
                pw.println("<h3>Description: " + hyperlinkedDescription + "</h3>");
            }
            if (atr.isSuccessful()) {
                pw.println("<p>Result: <font color=\"green\">successful</font></p>");
            } else {
                pw.println("<p>Result: <font color=\"red\">FAILED</font></p>");
            }
            if (atr.getException() == null) {
                if ((atr.getTest().getType().equals("no-results") || atr.getTest().getType().equals("results-report")) && atr.getResults().size() > 0) {
                    this.outputTable(pw, atr, atr.getColumnLabels(), atr.getResults());
                    pw.println("<p>total rows: " + atr.getResultsCount() + "</p>");
                }
            } else {
                pw.println("<p>SQLException while executing SQL:</p>");
                pw.println("<pre>");
                atr.getException().printStackTrace(pw);
                pw.println("</pre>");
            }
            pw.println("<hr>");
            ++count;
        }
        ArrayList<Integer> allTrackerIds = new ArrayList<Integer>();
        for (AcceptanceTestResult atr : testResults) {
            for (Integer id : atr.getTrackerMap().keySet()) {
                if (allTrackerIds.contains(id)) continue;
                allTrackerIds.add(id);
                List<List<Object>> trackerRows = atr.getTrackerMap().get(id);
                pw.println("<h2><a name=\"object" + id + "\">Tracker entries for " + id + "</a></h2>");
                this.outputTable(pw, atr, null, trackerRows);
                pw.println("<hr>");
            }
        }
        pw.println("</ul>");
        pw.println("</body></html>");
        pw.close();
    }

    private void outputTable(PrintWriter pw, AcceptanceTestResult atr, List<String> columnHeadings, List<List<Object>> results) {
        pw.println("<table border=1>");
        if (columnHeadings != null) {
            pw.println("<tr bgcolor=#eeeeee>");
            for (String string : columnHeadings) {
                pw.println("<th>" + string + "</th>");
            }
            pw.println("</tr>");
        }
        for (List list : results) {
            pw.println("<tr>");
            for (Object o : list) {
                pw.println("<td>");
                if (o != null) {
                    if (o instanceof Integer) {
                        Integer id = (Integer)o;
                        List<List<Object>> trackerRows = atr.getTrackerMap().get(id);
                        if (trackerRows == null) {
                            pw.println(id);
                        } else {
                            pw.println("<a href=\"#object" + id + "\">" + id + "</a>");
                        }
                    } else {
                        pw.println(o);
                    }
                } else {
                    pw.println("<font color=\"grey\" size=\"-1\">null</font>");
                }
                pw.println("</td>");
            }
            pw.println("</tr>");
        }
        pw.println("</table>");
    }

    public static String hyperLinkNote(String note) {
        String replacement = "<a href=\"http://intrac.flymine.org/ticket/$1\">#$1</a>";
        return note.replaceAll("#(\\d+)", replacement);
    }

    public static AcceptanceTest readOneTestConfig(LineNumberReader configReader) throws IOException {
        String line;
        String sql = null;
        String note = null;
        String type = null;
        Integer maxResults = null;
        while ((line = configReader.readLine()) != null) {
            if (line.matches("\\s*#.*|\\s*")) continue;
            Pattern headerPattern = Pattern.compile("^\\s*(\\S+)\\s*\\{\\s*$");
            Matcher headerMatcher = headerPattern.matcher(line);
            if (headerMatcher.matches()) {
                type = headerMatcher.group(1);
                if (type.equals("no-results") || type.equals("some-results") || type.equals("assert") || type.equals("results-report")) continue;
                throw new IOException("unknown acceptance test type: " + headerMatcher.group(1) + " at line " + configReader.getLineNumber());
            }
            Pattern linePattern = Pattern.compile("^\\s*(\\S+)\\s*:\\s*(\\S.*?)(;?)\\s*$");
            Matcher lineMatcher = linePattern.matcher(line);
            if (lineMatcher.matches()) {
                if ("sql".equals(lineMatcher.group(1))) {
                    sql = lineMatcher.group(2);
                    continue;
                }
                if ("note".equals(lineMatcher.group(1))) {
                    note = lineMatcher.group(2);
                    continue;
                }
                if ("max-results".equals(lineMatcher.group(1))) {
                    try {
                        maxResults = Integer.valueOf(lineMatcher.group(2));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("cannot parse number: " + lineMatcher.group(2) + " at line " + configReader.getLineNumber());
                    }
                }
                throw new IOException("unknown field: " + lineMatcher.group(1) + " at line " + configReader.getLineNumber());
            }
            if ("}".equals(line.trim())) {
                if (sql == null) {
                    throw new IOException("no sql in test at line " + configReader.getLineNumber());
                }
                return new AcceptanceTest(type, sql, note, maxResults);
            }
            throw new IOException("cannot parse line: " + line + " at line " + configReader.getLineNumber());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AcceptanceTestResult runTest(Connection con, AcceptanceTest test) {
        Statement sm = null;
        ResultSet rs = null;
        long startTime = new Date().getTime();
        try {
            AcceptanceTestResult atr;
            con.setAutoCommit(false);
            sm = con.createStatement();
            sm.setFetchSize(1000);
            rs = sm.executeQuery(test.getSql());
            long endTime = new Date().getTime();
            long totalTime = endTime - startTime;
            AcceptanceTestResult acceptanceTestResult = atr = new AcceptanceTestResult(test, rs, totalTime, con);
            return acceptanceTestResult;
        }
        catch (SQLException e) {
            try {
                con.rollback();
            }
            catch (SQLException e2) {
                throw new RuntimeException("couldn't rollback() transaction", e);
            }
            long endTime = new Date().getTime();
            long totalTime = endTime - startTime;
            AcceptanceTestResult acceptanceTestResult = new AcceptanceTestResult(test, e, totalTime);
            return acceptanceTestResult;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (sm != null) {
                    sm.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("exception while closing Statement or ResultSet", e);
            }
        }
    }
}

