/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.task;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.intermine.task.AcceptanceTest;

class AcceptanceTestResult {
    private AcceptanceTest test;
    private SQLException sqlException = null;
    private List<List<Object>> results = null;
    private List<String> columnLabels = null;
    private int resultCount = -1;
    private Map<Integer, List<List<Object>>> trackerMap = new HashMap<Integer, List<List<Object>>>();
    private final long time;

    AcceptanceTestResult(AcceptanceTest test, ResultSet rs, long time, Connection con) {
        this.test = test;
        this.time = time;
        try {
            this.results = AcceptanceTestResult.copyResults(rs, test.getMaxResults());
            this.resultCount = this.results.size();
            while (rs.next()) {
                ++this.resultCount;
            }
            ResultSetMetaData metadata = rs.getMetaData();
            this.columnLabels = new ArrayList<String>();
            for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                this.columnLabels.add(metadata.getColumnLabel(i));
            }
            DatabaseMetaData dbMetadata = con.getMetaData();
            ResultSet trackerTableResults = dbMetadata.getTables(null, null, "tracker", null);
            if (trackerTableResults.next()) {
                for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                    if (metadata.getColumnType(i) != 4 || !"id".equals(metadata.getColumnLabel(i))) continue;
                    for (List<Object> row : this.results) {
                        Integer id = (Integer)row.get(i - 1);
                        List<List<Object>> trackerRows = this.getTrackerRows(id, con);
                        this.trackerMap.put(id, trackerRows);
                    }
                }
            }
        }
        catch (SQLException e) {
            this.sqlException = e;
        }
    }

    public Map<Integer, List<List<Object>>> getTrackerMap() {
        return this.trackerMap;
    }

    public long getTime() {
        return this.time;
    }

    public int getResultsCount() {
        return this.resultCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<Object>> getTrackerRows(Integer id, Connection con) {
        Statement sm = null;
        ResultSet rs = null;
        try {
            sm = con.createStatement();
            rs = sm.executeQuery("select * from tracker where objectid = " + id);
            List<List<Object>> list = AcceptanceTestResult.copyResults(rs, 100);
            return list;
        }
        catch (SQLException e) {
            this.sqlException = e;
            List<List<Object>> list = null;
            return list;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (sm != null) {
                    sm.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("exception while closing Statement or ResultSet", e);
            }
        }
    }

    AcceptanceTestResult(AcceptanceTest test, SQLException sqlException, long time) {
        this.test = test;
        this.sqlException = sqlException;
        this.time = time;
    }

    public boolean isSuccessful() {
        if (this.sqlException != null) {
            return false;
        }
        if (this.test.getType().equals("assert")) {
            if (this.results.size() == 1) {
                Object o = this.results.get(0).get(0);
                if (o instanceof Boolean) {
                    return (Boolean)o;
                }
                return false;
            }
            return false;
        }
        if (this.test.getType().equals("no-results")) {
            return this.results.size() == 0;
        }
        if (this.test.getType().equals("some-results")) {
            return this.results.size() != 0;
        }
        if (this.test.getType().equals("results-report")) {
            return true;
        }
        throw new RuntimeException("unkown test type: " + this.test.getType());
    }

    public List<List<Object>> getResults() {
        return this.results;
    }

    public List<String> getColumnLabels() {
        return this.columnLabels;
    }

    public SQLException getException() {
        return this.sqlException;
    }

    private static List<List<Object>> copyResults(ResultSet rs, int maxRows) throws SQLException {
        ArrayList<List<Object>> returnList = new ArrayList<List<Object>>();
        int columnCount = rs.getMetaData().getColumnCount();
        for (int rowIndex = 0; (maxRows == -1 || rowIndex < maxRows) && rs.next(); ++rowIndex) {
            ArrayList<Object> rowCopy = new ArrayList<Object>();
            for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                rowCopy.add(rs.getObject(columnIndex));
            }
            returnList.add(rowCopy);
        }
        return returnList;
    }

    public AcceptanceTest getTest() {
        return this.test;
    }
}

