/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.writebatch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.intermine.sql.writebatch.Table;
import org.intermine.util.NullFirstComparator;
import org.intermine.util.StringConstructor;

public class TableBatch
implements Table {
    private static final Logger LOG = Logger.getLogger(TableBatch.class);
    private String idField = null;
    private String[] colNames = null;
    private Set<Object> idsToDelete = null;
    private Map<Object, Object> idsToInsert = null;
    private int size = 0;

    public int addRow(Object idValue, String[] colNames, Object[] values) {
        if (this.colNames == null) {
            this.colNames = colNames;
            this.idsToInsert = new TreeMap<Object, Object>(NullFirstComparator.SINGLETON);
        } else if (colNames != this.colNames) {
            if (colNames.length != this.colNames.length) {
                throw new IllegalStateException("Cannot change colNames once it is set");
            }
            for (int i = 0; i < colNames.length; ++i) {
                if (colNames[i].equals(this.colNames[i])) continue;
                throw new IllegalStateException("Cannot change colNames once it is set");
            }
            Exception e = new Exception();
            e.fillInStackTrace();
            LOG.warn((Object)("Potential inefficiency - seen two equivalent column name arrays, and had to compare them as arrays (slowly). Try to cache the column name array so they can be compared by reference (fast). old = " + this.colNames + ", new: " + colNames + ", stack trace = "), (Throwable)e);
            this.colNames = colNames;
        }
        Object currentEntry = this.idsToInsert.get(idValue);
        if (currentEntry == null) {
            this.idsToInsert.put(idValue, values);
        } else if (currentEntry instanceof List) {
            ((List)currentEntry).add(values);
        } else {
            ArrayList<Object[]> newEntry = new ArrayList<Object[]>();
            newEntry.add((Object[])currentEntry);
            newEntry.add(values);
            this.idsToInsert.put(idValue, newEntry);
        }
        int deltaSize = TableBatch.sizeOfArray(values) + 16;
        this.size += deltaSize;
        return deltaSize;
    }

    public int deleteRow(String idField, Object idValue) {
        Object removed;
        if (this.idField == null) {
            this.idField = idField;
            this.idsToDelete = new TreeSet<Object>(NullFirstComparator.SINGLETON);
        } else if (!this.idField.equals(idField)) {
            throw new IllegalStateException("Cannot change idField once it is set");
        }
        int retval = 50;
        if (this.idsToInsert != null && (removed = this.idsToInsert.remove(idValue)) != null) {
            retval = removed instanceof Object[] ? (retval -= TableBatch.sizeOfArray((Object[])removed)) : (retval -= TableBatch.sizeOfList((List)removed));
        }
        this.idsToDelete.add(idValue);
        this.size += retval;
        return retval;
    }

    public String[] getColNames() {
        return this.colNames;
    }

    public String getIdField() {
        return this.idField;
    }

    public Map<Object, Object> getIdsToInsert() {
        return this.idsToInsert;
    }

    public Set<Object> getIdsToDelete() {
        return this.idsToDelete;
    }

    @Override
    public void clear() {
        if (this.idsToDelete != null) {
            this.idsToDelete.clear();
        }
        if (this.idsToInsert != null) {
            this.idsToInsert.clear();
        }
        this.size = 0;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    protected static int sizeOfArray(Object[] array) {
        int retval = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] instanceof String) {
                retval += ((String)array[i]).length() * 2 + 12;
                continue;
            }
            if (array[i] instanceof StringConstructor) {
                retval += ((StringConstructor)array[i]).length() * 2 + 12;
                continue;
            }
            if (array[i] instanceof Long || array[i] instanceof Double) {
                retval += 8;
                continue;
            }
            if (array[i] instanceof BigDecimal) {
                retval += 50;
                continue;
            }
            retval += 4;
        }
        return retval;
    }

    protected static int sizeOfList(List<Object[]> list) {
        int retval = 0;
        for (Object[] array : list) {
            retval += TableBatch.sizeOfArray(array);
        }
        return retval;
    }
}

