/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.writebatch;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import org.intermine.util.SensibleByteArrayOutputStream;
import org.intermine.util.StringConstructor;

public class PostgresDataOutputStream
extends DataOutputStream {
    public PostgresDataOutputStream(OutputStream out) {
        super(out);
    }

    public int writeLargeUTF(String str) throws IOException {
        return this.writeLargeUTF(Collections.singletonList(str));
    }

    public int writeLargeUTF(StringConstructor str) throws IOException {
        return this.writeLargeUTF(str.getStrings());
    }

    protected int writeLargeUTF(Collection<String> strs) throws IOException {
        char c;
        int i;
        int strlen;
        int utflen = 0;
        for (String str : strs) {
            strlen = str.length();
            for (i = 0; i < strlen; ++i) {
                c = str.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (c > '\u07ff') {
                    utflen += 3;
                    continue;
                }
                utflen += 2;
            }
        }
        if (this.out instanceof SensibleByteArrayOutputStream) {
            ((SensibleByteArrayOutputStream)this.out).assureSize(((SensibleByteArrayOutputStream)this.out).size() + 4 + utflen);
        }
        this.writeInt(utflen);
        for (String str : strs) {
            strlen = str.length();
            i = 0;
            for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
                this.writeByte((byte)c);
            }
            while (i < strlen) {
                c = str.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    this.writeByte((byte)c);
                } else if (c > '\u07ff') {
                    this.writeByte((byte)(0xE0 | c >> 12 & 0xF));
                    this.writeByte((byte)(0x80 | c >> 6 & 0x3F));
                    this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
                } else {
                    this.writeByte((byte)(0xC0 | c >> 6 & 0x1F));
                    this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
                }
                ++i;
            }
        }
        return utflen + 4;
    }
}

