/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.writebatch;

import java.util.Set;
import java.util.TreeSet;
import org.intermine.sql.writebatch.Row;
import org.intermine.sql.writebatch.Table;

public class IndirectionTableBatch
implements Table {
    private String leftColName;
    private String rightColName;
    private Set<Row> rowsToDelete;
    private Set<Row> rowsToInsert;
    private int size = 0;

    public IndirectionTableBatch(String leftColName, String rightColName) {
        this.leftColName = leftColName;
        this.rightColName = rightColName;
        this.rowsToDelete = new TreeSet<Row>();
        this.rowsToInsert = new TreeSet<Row>();
    }

    protected IndirectionTableBatch(String leftColName, String rightColName, Set<Row> toInsert) {
        this.leftColName = leftColName;
        this.rightColName = rightColName;
        this.rowsToDelete = new TreeSet<Row>();
        this.rowsToInsert = toInsert;
    }

    public int addRow(int left, int right) {
        Row row = new Row(left, right);
        boolean removedDelete = this.rowsToDelete.remove(row);
        boolean addedInsert = this.rowsToInsert.add(row);
        int deltaSize = addedInsert ? (removedDelete ? 0 : 16) : 0;
        this.size += deltaSize;
        return deltaSize;
    }

    public int deleteRow(int left, int right) {
        Row row = new Row(left, right);
        boolean removedInsert = this.rowsToInsert.remove(row);
        boolean addedDelete = this.rowsToDelete.add(row);
        int deltaSize = addedDelete ? (removedInsert ? 0 : 16) : 0;
        this.size += deltaSize;
        return deltaSize;
    }

    public String getLeftColName() {
        return this.leftColName;
    }

    public String getRightColName() {
        return this.rightColName;
    }

    public Set<Row> getRowsToDelete() {
        return this.rowsToDelete;
    }

    public Set<Row> getRowsToInsert() {
        return this.rowsToInsert;
    }

    @Override
    public void clear() {
        this.rowsToInsert.clear();
        this.rowsToDelete.clear();
        this.size = 0;
    }

    @Override
    public int getSize() {
        return this.size;
    }
}

