/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.writebatch;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.intermine.sql.writebatch.FlushJob;
import org.postgresql.copy.CopyManager;

public class FlushJobPostgresCopyImpl
implements FlushJob {
    private CopyManager copyManager;
    private String sql;
    private byte[] data;
    private int size;

    public FlushJobPostgresCopyImpl(CopyManager copyManager, String sql, byte[] data, int size) {
        this.copyManager = copyManager;
        this.sql = sql;
        this.data = data;
        this.size = size;
    }

    @Override
    public void flush() throws SQLException {
        try {
            this.copyManager.copyIn(this.sql, (InputStream)new ByteArrayInputStream(this.data, 0, this.size));
            this.copyManager = null;
            this.sql = null;
            this.data = null;
        }
        catch (SQLException e) {
            SQLException e2 = new SQLException("Error writing to database, running statement " + this.sql + ", data size = " + this.size);
            e2.initCause(e);
            throw e2;
        }
        catch (IOException e) {
            SQLException e2 = new SQLException("Error writing to database, running statement " + this.sql + ", data size = " + this.size);
            e2.initCause(e);
            throw e2;
        }
    }
}

