/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.writebatch;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.intermine.sql.DatabaseUtil;
import org.intermine.sql.writebatch.BatchWriter;
import org.intermine.sql.writebatch.FlushJob;
import org.intermine.sql.writebatch.FlushJobStatementBatchImpl;
import org.intermine.sql.writebatch.FlushJobUpdateStatistics;
import org.intermine.sql.writebatch.IndirectionTableBatch;
import org.intermine.sql.writebatch.Row;
import org.intermine.sql.writebatch.Table;
import org.intermine.sql.writebatch.TableBatch;

public class BatchWriterSimpleImpl
implements BatchWriter {
    private static final Logger LOG = Logger.getLogger(BatchWriterSimpleImpl.class);
    protected int deleteTempTableSize = 200;
    protected Connection con;
    protected Statement preDeleteBatch;
    protected List<FlushJob> deleteBatches;
    protected Statement postDeleteBatch;
    protected List<FlushJob> addBatches;
    protected Statement lastBatch;
    protected Map<String, Statistic> stats = new HashMap<String, Statistic>();

    public void setThreshold(int deleteTempTableSize) {
        this.deleteTempTableSize = deleteTempTableSize;
    }

    @Override
    public List<FlushJob> write(Connection con, Map<String, ? extends Table> tables, Set<String> filter) throws SQLException {
        this.con = con;
        this.preDeleteBatch = null;
        this.deleteBatches = new ArrayList<FlushJob>();
        this.postDeleteBatch = null;
        this.addBatches = new ArrayList<FlushJob>();
        this.lastBatch = null;
        HashMap<String, Integer> activityMap = new HashMap<String, Integer>();
        for (Map.Entry<String, ? extends Table> tableEntry : tables.entrySet()) {
            String name = tableEntry.getKey();
            if (filter != null && !filter.contains(name)) continue;
            int activity = 0;
            Table table = tableEntry.getValue();
            if (table instanceof TableBatch) {
                activity += 2 * this.doDeletes(name, (TableBatch)table);
                activity += this.doInserts(name, (TableBatch)table, this.addBatches);
            } else {
                activity += 2 * this.doIndirectionDeletes(name, (IndirectionTableBatch)table);
                activity += this.doIndirectionInserts(name, (IndirectionTableBatch)table, this.addBatches);
            }
            table.clear();
            if (activity <= 0) continue;
            activityMap.put(name, new Integer(activity));
        }
        ArrayList<FlushJob> retval = new ArrayList<FlushJob>();
        if (this.preDeleteBatch != null) {
            retval.add(new FlushJobStatementBatchImpl(this.preDeleteBatch));
        }
        retval.addAll(this.deleteBatches);
        if (this.postDeleteBatch != null) {
            retval.add(new FlushJobStatementBatchImpl(this.postDeleteBatch));
        }
        retval.addAll(this.addBatches);
        if (this.lastBatch != null) {
            retval.add(new FlushJobStatementBatchImpl(this.lastBatch));
        }
        if (!activityMap.isEmpty()) {
            retval.add(new FlushJobUpdateStatistics(activityMap, this, con));
        }
        this.preDeleteBatch = null;
        this.deleteBatches = null;
        this.postDeleteBatch = null;
        this.addBatches = null;
        this.lastBatch = null;
        return retval;
    }

    protected int doInserts(String name, TableBatch table, List<FlushJob> batches) throws SQLException {
        String[] colNames = table.getColNames();
        if (colNames != null && !table.getIdsToInsert().isEmpty()) {
            StringBuffer preambleBuffer = new StringBuffer("INSERT INTO ").append(name).append(" (");
            for (int i = 0; i < colNames.length; ++i) {
                if (i > 0) {
                    preambleBuffer.append(", ");
                }
                preambleBuffer.append(colNames[i]);
            }
            preambleBuffer.append(") VALUES (");
            String preamble = preambleBuffer.toString();
            for (Map.Entry<Object, Object> insertEntry : table.getIdsToInsert().entrySet()) {
                Object inserts = insertEntry.getValue();
                if (inserts instanceof Object[]) {
                    this.addToLastBatch(BatchWriterSimpleImpl.insertString(preamble, colNames.length, (Object[])inserts));
                    continue;
                }
                for (Object[] values : (List)inserts) {
                    this.addToLastBatch(BatchWriterSimpleImpl.insertString(preamble, colNames.length, values));
                }
            }
            return table.getIdsToInsert().size();
        }
        return 0;
    }

    private static String insertString(String preamble, int colCount, Object[] values) {
        StringBuffer sqlBuffer = new StringBuffer((int)((double)TableBatch.sizeOfArray(values) * 1.01 + 1000.0)).append(preamble);
        for (int i = 0; i < colCount; ++i) {
            if (i > 0) {
                sqlBuffer.append(", ");
            }
            sqlBuffer.append(DatabaseUtil.objectToString(values[i]));
        }
        sqlBuffer.append(")");
        return sqlBuffer.toString();
    }

    protected int doDeletes(String name, TableBatch table) throws SQLException {
        String idField = table.getIdField();
        if (idField != null && !table.getIdsToDelete().isEmpty()) {
            if (table.getIdsToDelete().size() > this.deleteTempTableSize) {
                String tempTableName = "deletes_from_" + name;
                this.addToPreDeleteBatch("CREATE TABLE " + tempTableName + " (value integer)");
                TableBatch tableBatch = new TableBatch();
                String[] colNames = new String[]{"value"};
                for (Object id : table.getIdsToDelete()) {
                    tableBatch.addRow(null, colNames, new Object[]{id});
                }
                this.doInserts(tempTableName, tableBatch, this.deleteBatches);
                this.addToPostDeleteBatch("DELETE FROM " + name + " WHERE " + idField + " IN (SELECT value FROM " + tempTableName + ")");
                this.addToPostDeleteBatch("DROP TABLE " + tempTableName);
            } else {
                StringBuffer sqlBuffer = new StringBuffer("DELETE FROM ").append(name).append(" WHERE ").append(idField).append(" IN (");
                boolean needComma = false;
                int statementSize = 0;
                for (Object idValue : table.getIdsToDelete()) {
                    if (needComma) {
                        sqlBuffer.append(", ");
                    }
                    needComma = true;
                    sqlBuffer.append(DatabaseUtil.objectToString(idValue));
                    if (++statementSize < 500) continue;
                    statementSize = 0;
                    sqlBuffer.append(")");
                    this.addToPostDeleteBatch(sqlBuffer.toString());
                    sqlBuffer = new StringBuffer("DELETE FROM ").append(name).append(" WHERE ").append(idField).append(" IN (");
                    needComma = false;
                }
                if (statementSize > 0) {
                    sqlBuffer.append(")");
                    this.addToPostDeleteBatch(sqlBuffer.toString());
                }
            }
            return table.getIdsToDelete().size();
        }
        return 0;
    }

    protected int doIndirectionDeletes(String name, IndirectionTableBatch table) throws SQLException {
        CombinedSet<Row> rows = new CombinedSet<Row>(table.getRowsToDelete(), table.getRowsToInsert());
        if (!rows.isEmpty()) {
            if (rows.size() > this.deleteTempTableSize) {
                String tempTableName = "deletes_from_" + name;
                this.addToPreDeleteBatch("CREATE TABLE " + tempTableName + " (a integer, b integer)");
                IndirectionTableBatch tableBatch = new IndirectionTableBatch("a", "b", rows);
                this.doIndirectionInserts(tempTableName, tableBatch, this.deleteBatches);
                this.addToPostDeleteBatch("DELETE FROM " + name + " WHERE (" + table.getLeftColName() + ", " + table.getRightColName() + ") IN (SELECT a, b FROM " + tempTableName + ")");
                this.addToPostDeleteBatch("DROP TABLE " + tempTableName);
            } else {
                StringBuffer sql = new StringBuffer("DELETE FROM ").append(name).append(" WHERE (");
                boolean needComma = false;
                int statementSize = 0;
                for (Row row : rows) {
                    if (needComma) {
                        sql.append(" OR ");
                    }
                    sql.append("(").append(table.getLeftColName()).append(" = ").append(row.getLeft()).append(" AND ").append(table.getRightColName()).append(" = ").append(row.getRight()).append(")");
                    needComma = true;
                    if (++statementSize < 500) continue;
                    statementSize = 0;
                    sql.append(")");
                    this.addToPostDeleteBatch(sql.toString());
                    sql = new StringBuffer("DELETE FROM ").append(name).append(" WHERE (");
                    needComma = false;
                }
                if (statementSize > 0) {
                    sql.append(")");
                    this.addToPostDeleteBatch(sql.toString());
                }
            }
        }
        return table.getRowsToDelete().size();
    }

    protected int doIndirectionInserts(String name, IndirectionTableBatch table, List<FlushJob> batches) throws SQLException {
        if (!table.getRowsToInsert().isEmpty()) {
            String preamble = "INSERT INTO " + name + " (" + table.getLeftColName() + ", " + table.getRightColName() + ") VALUES (";
            for (Row row : table.getRowsToInsert()) {
                StringBuffer sql = new StringBuffer(preamble).append(row.getLeft()).append(", ").append(row.getRight()).append(")");
                this.addToLastBatch(sql.toString());
            }
        }
        return table.getRowsToInsert().size();
    }

    protected void addToPreDeleteBatch(String sql) throws SQLException {
        if (this.preDeleteBatch == null) {
            this.preDeleteBatch = this.con.createStatement();
        }
        this.preDeleteBatch.addBatch(sql);
    }

    protected void addToPostDeleteBatch(String sql) throws SQLException {
        this.addToPreDeleteBatch(sql);
    }

    protected void addToLastBatch(String sql) throws SQLException {
        this.addToPreDeleteBatch(sql);
    }

    @Override
    public void updateStatistics(Map<String, Integer> activity, Connection conn) throws SQLException {
        for (Map.Entry<String, Integer> entry : activity.entrySet()) {
            boolean doAnalyse;
            String name = entry.getKey();
            int amount = entry.getValue();
            Statistic stat = this.stats.get(name);
            if (stat == null) {
                stat = new Statistic(name, this.getTableSize(name, conn), amount);
                this.stats.put(name, stat);
            }
            if (!(doAnalyse = stat.addActivity(amount))) continue;
            long start = System.currentTimeMillis();
            this.doAnalyse(name, conn);
            int tableSize = this.getTableSize(name, conn);
            long end = System.currentTimeMillis();
            stat.setTableSize(tableSize, end - start);
            LOG.info((Object)("Analysing table " + name + " took " + (end - start) + "ms (" + tableSize + " rows)"));
        }
    }

    protected int getTableSize(String name, Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet r = s.executeQuery("SELECT COUNT(*) FROM " + name);
        if (r.next()) {
            int returnValue = r.getInt(1);
            if (r.next()) {
                throw new SQLException("Too many results");
            }
            return returnValue;
        }
        throw new SQLException("No results");
    }

    protected void doAnalyse(String name, Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("ANALYSE VERBOSE " + name);
        for (SQLWarning e = s.getWarnings(); e != null; e = e.getNextWarning()) {
            LOG.debug((Object)("ANALYSE WARNING: " + e.toString()));
        }
    }

    private static class Statistic {
        private String name;
        private int tableSize;
        private int totalActivity;
        private long lastResizeTime = 0L;
        private long analyseTime = 0L;

        public Statistic(String name, int tableSize, int activity) {
            this.name = name;
            this.tableSize = tableSize - activity;
            this.totalActivity = 0;
            LOG.debug((Object)("Statistics: " + name + " created: tableSize = " + tableSize + " (hacked down to " + this.tableSize + " for unaccounted-for activity)"));
        }

        public boolean addActivity(int activity) {
            LOG.debug((Object)("Statistics: " + this.name + ", tableSize = " + this.tableSize + ", activity " + this.totalActivity + " --> tableSize = " + this.tableSize + ", activity = " + (this.totalActivity + activity) + "    - Activity of " + activity + " rows"));
            this.totalActivity += activity;
            return this.totalActivity > this.tableSize / 2 + 1000 || this.totalActivity > 100000 && System.currentTimeMillis() - this.lastResizeTime > 600000L + this.analyseTime * 20L;
        }

        public void setTableSize(int tableSize, long analyseTime) {
            LOG.debug((Object)("Statistics: " + this.name + ", tableSize = " + this.tableSize + ", activity " + this.totalActivity + " --> tableSize = " + tableSize + ", activity = 0   - New table size"));
            this.tableSize = tableSize;
            this.totalActivity = 0;
            this.lastResizeTime = System.currentTimeMillis();
            this.analyseTime = analyseTime;
        }
    }

    private static class CombinedSet<T>
    extends AbstractSet<T> {
        private Set<T> setA;
        private Set<T> setB;

        public CombinedSet(Set<T> setA, Set<T> setB) {
            this.setA = setA;
            this.setB = setB;
        }

        @Override
        public int size() {
            return this.setA.size() + this.setB.size();
        }

        @Override
        public Iterator<T> iterator() {
            return new CombinedIterator();
        }

        static /* synthetic */ Set access$100(CombinedSet x0) {
            return x0.setA;
        }

        private class CombinedIterator
        implements Iterator<T> {
            private boolean state = true;
            private Iterator<T> iter = CombinedSet.access$100(CombinedSet.this).iterator();

            private CombinedIterator() {
            }

            @Override
            public boolean hasNext() {
                if (this.state) {
                    if (this.iter.hasNext()) {
                        return true;
                    }
                    this.state = false;
                    this.iter = CombinedSet.this.setB.iterator();
                    return this.iter.hasNext();
                }
                return this.iter.hasNext();
            }

            @Override
            public T next() {
                if (this.state && !this.iter.hasNext()) {
                    this.iter = CombinedSet.this.setB.iterator();
                }
                return this.iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

