/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.writebatch;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.intermine.sql.writebatch.BatchWriterSimpleImpl;
import org.intermine.sql.writebatch.FlushJob;
import org.intermine.sql.writebatch.FlushJobStatementBatchImpl;
import org.intermine.sql.writebatch.IndirectionTableBatch;
import org.intermine.sql.writebatch.Row;
import org.intermine.sql.writebatch.TableBatch;

public class BatchWriterPreparedStatementImpl
extends BatchWriterSimpleImpl {
    @Override
    protected int doInserts(String name, TableBatch table, List<FlushJob> batches) throws SQLException {
        String[] colNames = table.getColNames();
        if (colNames != null && !table.getIdsToInsert().isEmpty()) {
            int i;
            StringBuffer sqlBuffer = new StringBuffer("INSERT INTO ").append(name).append(" (");
            for (i = 0; i < colNames.length; ++i) {
                if (i > 0) {
                    sqlBuffer.append(", ");
                }
                sqlBuffer.append(colNames[i]);
            }
            sqlBuffer.append(") VALUES (");
            for (i = 0; i < colNames.length; ++i) {
                if (i > 0) {
                    sqlBuffer.append(", ");
                }
                sqlBuffer.append("?");
            }
            sqlBuffer.append(")");
            String sql = sqlBuffer.toString();
            PreparedStatement prepS = this.con.prepareStatement(sql);
            for (Map.Entry<Object, Object> insertEntry : table.getIdsToInsert().entrySet()) {
                Object inserts = insertEntry.getValue();
                if (inserts instanceof Object[]) {
                    Object[] values = (Object[])inserts;
                    for (int i2 = 0; i2 < colNames.length; ++i2) {
                        Object value = values[i2];
                        if (value instanceof CharSequence) {
                            value = ((Object)((CharSequence)value)).toString();
                        }
                        prepS.setObject(i2 + 1, value);
                    }
                    prepS.addBatch();
                    continue;
                }
                for (Object[] values : (List)inserts) {
                    for (int i3 = 0; i3 < colNames.length; ++i3) {
                        Object value = values[i3];
                        if (value instanceof CharSequence) {
                            value = ((Object)((CharSequence)value)).toString();
                        }
                        prepS.setObject(i3 + 1, value);
                    }
                    prepS.addBatch();
                }
            }
            batches.add(new FlushJobStatementBatchImpl(prepS));
            return table.getIdsToInsert().size();
        }
        return 0;
    }

    @Override
    protected int doIndirectionInserts(String name, IndirectionTableBatch table, List<FlushJob> batches) throws SQLException {
        if (!table.getRowsToInsert().isEmpty()) {
            String sql = "INSERT INTO " + name + " (" + table.getLeftColName() + ", " + table.getRightColName() + ") VALUES (?, ?)";
            PreparedStatement prepS = this.con.prepareStatement(sql);
            for (Row row : table.getRowsToInsert()) {
                prepS.setInt(1, row.getLeft());
                prepS.setInt(2, row.getRight());
                prepS.addBatch();
            }
            batches.add(new FlushJobStatementBatchImpl(prepS));
        }
        return table.getRowsToInsert().size();
    }

    @Override
    protected void addToPostDeleteBatch(String sql) throws SQLException {
        if (this.postDeleteBatch == null) {
            this.postDeleteBatch = this.con.createStatement();
        }
        this.postDeleteBatch.addBatch(sql);
    }

    @Override
    protected void addToLastBatch(String sql) throws SQLException {
        if (this.lastBatch == null) {
            this.lastBatch = this.con.createStatement();
        }
        this.lastBatch.addBatch(sql);
    }
}

