/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.writebatch;

import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.intermine.sql.writebatch.BatchWriterPreparedStatementImpl;
import org.intermine.sql.writebatch.FlushJob;
import org.intermine.sql.writebatch.FlushJobPostgresCopyImpl;
import org.intermine.sql.writebatch.IndirectionTableBatch;
import org.intermine.sql.writebatch.PostgresByteArrayOutputStream;
import org.intermine.sql.writebatch.PostgresDataOutputStream;
import org.intermine.sql.writebatch.Row;
import org.intermine.sql.writebatch.TableBatch;
import org.intermine.util.StringConstructor;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyManager;

public class BatchWriterPostgresCopyImpl
extends BatchWriterPreparedStatementImpl {
    private static final Logger LOG = Logger.getLogger(BatchWriterPostgresCopyImpl.class);
    protected static final BigInteger TEN = new BigInteger("10");
    protected static final BigInteger HUNDRED = new BigInteger("100");
    protected static final BigInteger THOUSAND = new BigInteger("1000");
    protected static final BigInteger TEN_THOUSAND = new BigInteger("10000");

    @Override
    protected int doInserts(String name, TableBatch table, List<FlushJob> batches) throws SQLException {
        String[] colNames = table.getColNames();
        if (colNames != null && !table.getIdsToInsert().isEmpty()) {
            block12: {
                try {
                    CopyManager copyManager = null;
                    if (this.con instanceof PGConnection) {
                        copyManager = ((PGConnection)this.con).getCopyAPI();
                    }
                    if (copyManager == null) {
                        LOG.warn((Object)("Database with Connection " + this.con.getClass().getName() + " is incompatible with the PostgreSQL COPY command - falling" + " back to prepared statements"));
                        super.doInserts(name, table, batches);
                        break block12;
                    }
                    PostgresByteArrayOutputStream baos = new PostgresByteArrayOutputStream();
                    PostgresDataOutputStream dos = new PostgresDataOutputStream(baos);
                    dos.writeBytes("PGCOPY\n");
                    dos.writeByte(255);
                    dos.writeBytes("\r\n");
                    dos.writeByte(0);
                    dos.writeInt(0);
                    dos.writeInt(0);
                    for (Map.Entry<Object, Object> insertEntry : table.getIdsToInsert().entrySet()) {
                        Object inserts = insertEntry.getValue();
                        if (inserts instanceof Object[]) {
                            Object[] values = (Object[])inserts;
                            dos.writeShort(colNames.length);
                            for (int i = 0; i < colNames.length; ++i) {
                                BatchWriterPostgresCopyImpl.writeObject(dos, values[i]);
                            }
                            continue;
                        }
                        for (Object[] values : (List)inserts) {
                            dos.writeShort(colNames.length);
                            for (int i = 0; i < colNames.length; ++i) {
                                BatchWriterPostgresCopyImpl.writeObject(dos, values[i]);
                            }
                        }
                    }
                    StringBuffer sqlBuffer = new StringBuffer("COPY ").append(name).append(" (");
                    for (int i = 0; i < colNames.length; ++i) {
                        if (i > 0) {
                            sqlBuffer.append(", ");
                        }
                        sqlBuffer.append(colNames[i]);
                    }
                    sqlBuffer.append(") FROM STDIN BINARY");
                    String sql = sqlBuffer.toString();
                    dos.writeShort(-1);
                    dos.flush();
                    batches.add(new FlushJobPostgresCopyImpl(copyManager, sql, baos.getBuffer(), baos.size()));
                }
                catch (IOException e) {
                    throw new SQLException(e.toString());
                }
            }
            return table.getIdsToInsert().size();
        }
        return 0;
    }

    private static void writeObject(PostgresDataOutputStream dos, Object o) throws IOException {
        if (o == null) {
            dos.writeInt(-1);
        } else if (o instanceof Integer) {
            dos.writeInt(4);
            dos.writeInt((Integer)o);
        } else if (o instanceof Short) {
            dos.writeInt(2);
            dos.writeShort(((Short)o).intValue());
        } else if (o instanceof Boolean) {
            dos.writeInt(1);
            dos.writeByte((Boolean)o != false ? 1 : 0);
        } else if (o instanceof Float) {
            dos.writeInt(4);
            dos.writeFloat(((Float)o).floatValue());
        } else if (o instanceof Double) {
            dos.writeInt(8);
            dos.writeDouble((Double)o);
        } else if (o instanceof Long) {
            dos.writeInt(8);
            dos.writeLong((Long)o);
        } else if (o instanceof String) {
            dos.writeLargeUTF((String)o);
        } else if (o instanceof StringConstructor) {
            dos.writeLargeUTF((StringConstructor)o);
        } else if (o instanceof BigDecimal) {
            int digit;
            BigInteger[] res;
            BigInteger unscaledValue = ((BigDecimal)o).unscaledValue();
            int signum = ((BigDecimal)o).signum();
            if (signum == -1) {
                unscaledValue = unscaledValue.negate();
            }
            int scale = ((BigDecimal)o).scale();
            int nBaseScale = (scale + 3) / 4;
            int nBaseScaleRemainder = scale % 4;
            ArrayList<Integer> digits = new ArrayList<Integer>();
            if (nBaseScaleRemainder == 1) {
                res = unscaledValue.divideAndRemainder(TEN);
                digit = res[1].intValue() * 1000;
                digits.add(new Integer(digit));
                unscaledValue = res[0];
            } else if (nBaseScaleRemainder == 2) {
                res = unscaledValue.divideAndRemainder(HUNDRED);
                digit = res[1].intValue() * 100;
                digits.add(new Integer(digit));
                unscaledValue = res[0];
            } else if (nBaseScaleRemainder == 3) {
                res = unscaledValue.divideAndRemainder(THOUSAND);
                digit = res[1].intValue() * 10;
                digits.add(new Integer(digit));
                unscaledValue = res[0];
            }
            while (!unscaledValue.equals(BigInteger.ZERO)) {
                res = unscaledValue.divideAndRemainder(TEN_THOUSAND);
                digits.add(new Integer(res[1].intValue()));
                unscaledValue = res[0];
            }
            dos.writeInt(8 + 2 * digits.size());
            dos.writeShort(digits.size());
            dos.writeShort(digits.size() - nBaseScale - 1);
            dos.writeShort(signum == 1 ? 0 : 16384);
            dos.writeShort(scale);
            for (int i = digits.size() - 1; i >= 0; --i) {
                digit = (Integer)digits.get(i);
                dos.writeShort(digit);
            }
        } else {
            throw new IllegalArgumentException("Cannot store values of type " + o.getClass());
        }
    }

    @Override
    protected int doIndirectionInserts(String name, IndirectionTableBatch table, List<FlushJob> batches) throws SQLException {
        if (!table.getRowsToInsert().isEmpty()) {
            try {
                CopyManager copyManager = null;
                if (this.con instanceof PGConnection) {
                    copyManager = ((PGConnection)this.con).getCopyAPI();
                }
                if (copyManager == null) {
                    LOG.warn((Object)"Database is incompatible with the PostgreSQL COPY command - falling back to prepared statements");
                    super.doIndirectionInserts(name, table, batches);
                } else {
                    PostgresByteArrayOutputStream baos = new PostgresByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(baos);
                    dos.writeBytes("PGCOPY\n");
                    dos.writeByte(255);
                    dos.writeBytes("\r\n");
                    dos.writeByte(0);
                    dos.writeInt(0);
                    dos.writeInt(0);
                    for (Row row : table.getRowsToInsert()) {
                        dos.writeShort(2);
                        dos.writeInt(4);
                        dos.writeInt(row.getLeft());
                        dos.writeInt(4);
                        dos.writeInt(row.getRight());
                    }
                    String sql = "COPY " + name + " (" + table.getLeftColName() + ", " + table.getRightColName() + ") FROM STDIN BINARY";
                    dos.writeShort(-1);
                    dos.flush();
                    batches.add(new FlushJobPostgresCopyImpl(copyManager, sql, baos.getBuffer(), baos.size()));
                }
            }
            catch (IOException e) {
                throw new SQLException(e.toString());
            }
        }
        return table.getRowsToInsert().size();
    }

    @Override
    protected int getTableSize(String name, Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet r = s.executeQuery("SELECT reltuples FROM pg_class WHERE relname = '" + name.toLowerCase() + "'");
        if (r.next()) {
            int returnValue = (int)r.getFloat(1);
            if (r.next()) {
                throw new SQLException("Too many results for table " + name.toLowerCase());
            }
            return returnValue;
        }
        throw new SQLException("No results");
    }
}

