/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.writebatch;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.intermine.sql.writebatch.BatchWriter;
import org.intermine.sql.writebatch.FlushJob;
import org.intermine.sql.writebatch.FlushJobBatchCommit;
import org.intermine.sql.writebatch.IndirectionTableBatch;
import org.intermine.sql.writebatch.Table;
import org.intermine.sql.writebatch.TableBatch;

public class Batch {
    private static final Logger LOG = Logger.getLogger(Batch.class);
    private static final int OPP_BATCH_SIZE = 10000000;
    private static final int MAX_BATCH_SIZE = 100000000;
    private Map<String, Table> tables = new HashMap<String, Table>();
    private BatchWriter batchWriter;
    private int batchSize = 0;
    private int lastCheckBatchSize = 0;
    private List<FlushJob> flushJobs = Collections.emptyList();
    private SQLException problem = null;
    private volatile int lastDutyCycle = 100;
    private boolean closed = false;
    private static final List<FlushJob> CLOSE_DOWN_COMMAND = new ArrayList<FlushJob>();

    public Batch(BatchWriter batchWriter) {
        this.batchWriter = batchWriter;
        BatchFlusher flusher = new BatchFlusher();
        Thread thread = new Thread(flusher);
        thread.setDaemon(true);
        thread.setName("WriteBatch Flusher");
        thread.start();
    }

    public void addRow(Connection con, String name, Object idValue, String[] colNames, Object[] values) throws SQLException {
        if (this.closed) {
            throw new SQLException("Batch is closed");
        }
        TableBatch table = (TableBatch)this.tables.get(name);
        if (table == null) {
            table = new TableBatch();
            this.tables.put(name, table);
        }
        this.batchSize += table.addRow(idValue, colNames, values);
        this.maybeBackgroundFlush(con);
    }

    public void addRow(Connection con, String name, String leftColName, String rightColName, int left, int right) throws SQLException {
        if (this.closed) {
            throw new SQLException("Batch is closed");
        }
        IndirectionTableBatch table = (IndirectionTableBatch)this.tables.get(name);
        if (table == null) {
            table = new IndirectionTableBatch(leftColName, rightColName);
            this.tables.put(name, table);
        }
        this.batchSize += table.addRow(left, right);
        this.maybeBackgroundFlush(con);
    }

    public void deleteRow(Connection con, String name, String idField, Object idValue) throws SQLException {
        if (this.closed) {
            throw new SQLException("Batch is closed");
        }
        TableBatch table = (TableBatch)this.tables.get(name);
        if (table == null) {
            table = new TableBatch();
            this.tables.put(name, table);
        }
        this.batchSize += table.deleteRow(idField, idValue);
        this.maybeBackgroundFlush(con);
    }

    public void deleteRow(Connection con, String name, String leftColName, String rightColName, int left, int right) throws SQLException {
        if (this.closed) {
            throw new SQLException("Batch is closed");
        }
        IndirectionTableBatch table = (IndirectionTableBatch)this.tables.get(name);
        if (table == null) {
            table = new IndirectionTableBatch(leftColName, rightColName);
            this.tables.put(name, table);
        }
        this.batchSize += table.deleteRow(left, right);
        this.maybeBackgroundFlush(con);
    }

    private void maybeBackgroundFlush(Connection con) throws SQLException {
        if (this.batchSize > 100000000) {
            this.backgroundFlush(con, null);
        } else if (this.batchSize - this.lastCheckBatchSize > 10000000) {
            if (this.isFreeConnection()) {
                this.backgroundFlush(con, null);
            } else {
                this.lastCheckBatchSize = this.batchSize;
            }
        }
    }

    public void flush(Connection con) throws SQLException {
        this.flush(con, null);
    }

    public void flush(Connection con, Set<String> filter) throws SQLException {
        this.backgroundFlush(con, filter);
        List<FlushJob> empty = Collections.emptyList();
        this.putFlushJobs(empty);
    }

    public void batchCommit(Connection con) throws SQLException {
        this.backgroundFlush(con, null, true);
    }

    public void backgroundFlush(Connection con, Set<String> filter) throws SQLException {
        this.backgroundFlush(con, filter, false);
    }

    public void backgroundFlush(Connection con, Set<String> filter, boolean needBatchCommit) throws SQLException {
        if (this.closed) {
            throw new SQLException("Batch is closed");
        }
        List<FlushJob> jobs = this.batchWriter.write(con, this.tables, filter);
        int oldBatchSize = this.batchSize;
        this.batchSize = 0;
        for (Map.Entry<String, Table> tableEntry : this.tables.entrySet()) {
            Table table = tableEntry.getValue();
            this.batchSize += table.getSize();
        }
        this.lastCheckBatchSize = this.batchSize;
        if (needBatchCommit) {
            jobs.add(new FlushJobBatchCommit(con));
            needBatchCommit = false;
        }
        this.putFlushJobs(jobs);
        if (oldBatchSize - this.batchSize > 5000000) {
            LOG.info((Object)("Enqueued " + (oldBatchSize - this.batchSize) + " of " + oldBatchSize + " byte batch."));
        }
    }

    public void close(Connection con) throws SQLException {
        if (this.closed) {
            throw new SQLException("Batch is already closed");
        }
        try {
            this.backgroundFlush(con, null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.closed = true;
        this.putFlushJobs(CLOSE_DOWN_COMMAND);
    }

    public void clear() {
        if (this.closed) {
            throw new IllegalStateException("Batch is closed");
        }
        for (Map.Entry<String, Table> entry : this.tables.entrySet()) {
            Table table = entry.getValue();
            table.clear();
        }
        this.batchSize = 0;
        this.lastCheckBatchSize = 0;
        this.waitForFreeConnection();
        this.clearProblem();
    }

    public void setBatchWriter(BatchWriter batchWriter) {
        if (this.closed) {
            throw new IllegalStateException("Batch is closed");
        }
        this.waitForFreeConnection();
        this.batchWriter = batchWriter;
    }

    private synchronized List<FlushJob> getFlushJobs() {
        this.flushJobs = null;
        this.notifyAll();
        while (this.flushJobs == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.problem = null;
        return this.flushJobs;
    }

    private synchronized void waitForFreeConnection() {
        while (this.flushJobs != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized boolean isFreeConnection() {
        return this.flushJobs == null;
    }

    private synchronized void putFlushJobs(List<FlushJob> jobs) throws SQLException {
        long startTime = System.currentTimeMillis();
        while (this.flushJobs != null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        long endTime = System.currentTimeMillis();
        if (endTime > startTime + 100L) {
            LOG.info((Object)("Waited " + (endTime - startTime) + " ms for batch flusher"));
        }
        if (!jobs.isEmpty() || jobs == CLOSE_DOWN_COMMAND) {
            this.flushJobs = jobs;
            this.notifyAll();
        }
        if (this.problem != null) {
            throw this.problem;
        }
    }

    private synchronized void reportProblem(SQLException problem) {
        this.problem = problem;
    }

    public synchronized void clearProblem() {
        this.problem = null;
    }

    private class BatchFlusher
    implements Runnable {
        @Override
        public void run() {
            long flusherStart = System.currentTimeMillis();
            long totalSpent = 0L;
            long timeAtLastMessage = flusherStart;
            long spentAtLastMessage = totalSpent;
            List jobs = null;
            while (jobs != CLOSE_DOWN_COMMAND) {
                try {
                    jobs = Batch.this.getFlushJobs();
                    long start = System.currentTimeMillis();
                    for (FlushJob job : jobs) {
                        job.flush();
                    }
                    long end = System.currentTimeMillis();
                    totalSpent += end - start;
                    if (end / 100000L > timeAtLastMessage / 100000L) {
                        int totalDutyCycle = (int)((100L * totalSpent + (end - flusherStart) / 2L) / (end - flusherStart));
                        Batch.this.lastDutyCycle = (int)((100L * (totalSpent - spentAtLastMessage) + (end - timeAtLastMessage) / 2L) / (end - timeAtLastMessage));
                        LOG.info((Object)("Batch flusher has spent " + totalSpent + " ms waiting for the" + " database (duty cycle " + totalDutyCycle + "%) (current duty cycle " + Batch.this.lastDutyCycle + "%)"));
                        timeAtLastMessage = end;
                        spentAtLastMessage = totalSpent;
                    }
                }
                catch (SQLException e) {
                    Batch.this.reportProblem(e);
                }
                catch (Throwable t) {
                    SQLException e = new SQLException("Caught a Throwable in the Batch Flusher");
                    e.initCause(t);
                    Batch.this.reportProblem(e);
                }
                if (jobs == CLOSE_DOWN_COMMAND) continue;
                jobs = null;
            }
        }
    }
}

