/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.query;

import org.intermine.sql.query.AbstractTable;

public class Table
extends AbstractTable {
    protected String name;

    public Table(String name, String alias) {
        if (name == null) {
            throw new NullPointerException("Table names cannot be null");
        }
        this.name = name;
        if (alias == null) {
            alias = name;
        }
        this.alias = alias;
    }

    public Table(String name) {
        this(name, null);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getSQLString() {
        return this.alias == null || this.alias.equals(this.name) ? this.name : this.name + " AS " + this.alias;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Table) {
            Table objTable = (Table)obj;
            return this.name.equals(objTable.name) && (this.alias == null && objTable.alias == null || this.alias != null && this.alias.equals(objTable.alias));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() + (this.alias == null ? 0 : this.alias.hashCode());
    }

    @Override
    public boolean equalsIgnoreAlias(AbstractTable obj) {
        if (obj instanceof Table) {
            return this.name.equals(((Table)obj).name);
        }
        return false;
    }

    public String toString() {
        return this.getSQLString();
    }
}

