/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.query;

import java.util.Map;
import org.intermine.sql.query.AbstractConstraint;
import org.intermine.sql.query.AbstractTable;
import org.intermine.sql.query.AbstractValue;
import org.intermine.sql.query.NotConstraint;
import org.intermine.sql.query.Query;

public class SubQueryConstraint
extends AbstractConstraint {
    protected AbstractValue left;
    protected Query right;

    public SubQueryConstraint(AbstractValue left, Query right) {
        if (left == null) {
            throw new NullPointerException("left cannot be null");
        }
        if (right == null) {
            throw new NullPointerException("right cannot be null");
        }
        if (right.getSelect().size() != 1) {
            throw new IllegalArgumentException("right must have one result column only");
        }
        this.left = left;
        this.right = right;
    }

    @Override
    public String getSQLString() {
        if (this.right.getSelect().size() != 1) {
            throw new IllegalStateException("Right must have one result column only");
        }
        return this.left.getSQLString() + " IN (" + this.right.getSQLString() + ")";
    }

    @Override
    public int compare(AbstractConstraint obj, Map<AbstractTable, AbstractTable> tableMap, Map<AbstractTable, AbstractTable> reverseTableMap) {
        if (obj instanceof SubQueryConstraint) {
            SubQueryConstraint objC = (SubQueryConstraint)obj;
            return this.left.valueEquals(objC.left, tableMap, reverseTableMap) && this.right.equals(objC.right) ? 9 : 15;
        }
        if (obj instanceof NotConstraint) {
            NotConstraint objNC = (NotConstraint)obj;
            return SubQueryConstraint.alterComparisonNotObj(this.compare(objNC.con, tableMap, reverseTableMap));
        }
        return 15;
    }

    @Override
    public int hashCode() {
        return 3 * this.left.hashCode() + 5 * this.right.hashCode();
    }
}

