/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.query;

import org.intermine.sql.query.AbstractValue;
import org.intermine.sql.query.Field;
import org.intermine.sql.query.SQLStringable;

public class SelectValue
implements SQLStringable {
    protected AbstractValue v;
    protected String alias;

    public SelectValue(AbstractValue v, String alias) {
        if (v == null) {
            throw new NullPointerException("v cannot be null");
        }
        if (alias == null) {
            if (v instanceof Field) {
                alias = ((Field)v).name;
            } else {
                throw new NullPointerException("alias cannot be null unless v is a Field");
            }
        }
        this.alias = alias;
        this.v = v;
    }

    @Override
    public String getSQLString() {
        if (this.v instanceof Field && ((Field)this.v).name.equals(this.alias)) {
            return this.v.getSQLString();
        }
        return this.v.getSQLString() + " AS " + this.alias;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SelectValue) {
            SelectValue objSV = (SelectValue)obj;
            return this.v.equals(objSV.v) && this.alias.equals(objSV.alias);
        }
        return false;
    }

    public int hashCode() {
        return 3 * this.v.hashCode() + 5 * this.alias.hashCode();
    }

    public AbstractValue getValue() {
        return this.v;
    }

    public String getAlias() {
        return this.alias;
    }
}

