/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.query;

import antlr.DumpASTVisitor;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.ByteArrayInputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intermine.sql.query.AbstractConstraint;
import org.intermine.sql.query.AbstractTable;
import org.intermine.sql.query.AbstractValue;
import org.intermine.sql.query.Constant;
import org.intermine.sql.query.Constraint;
import org.intermine.sql.query.ConstraintSet;
import org.intermine.sql.query.Field;
import org.intermine.sql.query.Function;
import org.intermine.sql.query.InListConstraint;
import org.intermine.sql.query.NotConstraint;
import org.intermine.sql.query.OrderDescending;
import org.intermine.sql.query.SQLStringable;
import org.intermine.sql.query.SelectValue;
import org.intermine.sql.query.SqlLexer;
import org.intermine.sql.query.SqlParser;
import org.intermine.sql.query.SqlTreeParser;
import org.intermine.sql.query.SubQuery;
import org.intermine.sql.query.SubQueryConstraint;
import org.intermine.sql.query.Table;
import org.intermine.util.ConsistentSet;

public class Query
implements SQLStringable {
    protected List<SelectValue> select = new ArrayList<SelectValue>();
    protected Set<AbstractTable> from = new ConsistentSet<AbstractTable>();
    protected Set<AbstractConstraint> where = new ConsistentSet<AbstractConstraint>();
    protected Set<AbstractValue> groupBy = new ConsistentSet<AbstractValue>();
    protected Set<AbstractConstraint> having = new ConsistentSet<AbstractConstraint>();
    protected List<AbstractValue> orderBy = new ArrayList<AbstractValue>();
    protected int limit = 0;
    protected int offset = 0;
    protected boolean explain = false;
    protected boolean distinct = false;
    protected List<Query> queriesInUnion = new ArrayList<Query>();
    private Map<String, AbstractTable> aliasToTable;
    private Map<String, AbstractTable> originalAliasToTable;
    private AbstractTable onlyTable;

    public Query() {
        this.queriesInUnion.add(this);
        this.onlyTable = null;
        this.aliasToTable = null;
        this.originalAliasToTable = null;
    }

    public Query(Map<String, AbstractTable> aliasToTable) {
        this();
        this.aliasToTable = new HashMap<String, AbstractTable>();
        this.aliasToTable.putAll(aliasToTable);
        this.originalAliasToTable = aliasToTable;
    }

    public Query(Map<String, AbstractTable> aliasToTable, List<Query> queriesInUnion) {
        this();
        this.aliasToTable = new HashMap<String, AbstractTable>(aliasToTable);
        this.originalAliasToTable = aliasToTable;
        queriesInUnion.add(this);
        this.queriesInUnion = queriesInUnion;
    }

    public Query(String sql) {
        this(sql, true);
    }

    public Query(String sql, boolean treeParse) {
        this();
        this.aliasToTable = new HashMap<String, AbstractTable>();
        this.originalAliasToTable = new HashMap<String, AbstractTable>();
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(sql.getBytes());
            SqlLexer lexer = new SqlLexer(is);
            SqlParser parser = new SqlParser(lexer);
            parser.start_rule();
            AST ast = parser.getAST();
            if (ast == null) {
                throw new IllegalArgumentException("Invalid SQL string " + sql);
            }
            if (treeParse) {
                AST oldAst;
                do {
                    oldAst = ast;
                    SqlTreeParser treeparser = new SqlTreeParser();
                    treeparser.start_rule(ast);
                    ast = treeparser.getAST();
                    if (ast != null) continue;
                    throw new IllegalArgumentException("Invalid SQL string " + sql);
                } while (!oldAst.equalsList(ast));
            }
            this.processSqlStatementAST(ast);
        }
        catch (RecognitionException e) {
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(sql.getBytes());
                SqlLexer lexer = new SqlLexer(is);
                StringBuilder lex = new StringBuilder();
                boolean needComma = false;
                Token nextToken = lexer.nextToken();
                while (nextToken.getType() != 1) {
                    if (needComma) {
                        lex.append(", ");
                    }
                    needComma = true;
                    lex.append("[" + nextToken.getType() + ", " + nextToken.getText() + "]");
                    nextToken = lexer.nextToken();
                }
                IllegalArgumentException e2 = new IllegalArgumentException(lex.toString());
                e2.initCause(e);
                throw e2;
            }
            catch (TokenStreamException e3) {
                throw new IllegalArgumentException(e);
            }
        }
        catch (TokenStreamException e) {
            IllegalArgumentException e2 = new IllegalArgumentException();
            e2.initCause(e);
            throw e2;
        }
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isExplain() {
        return this.explain;
    }

    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    public List<SelectValue> getSelect() {
        return this.select;
    }

    public void addSelect(SelectValue obj) {
        this.select.add(obj);
    }

    public Set<AbstractTable> getFrom() {
        return this.from;
    }

    public void addFrom(AbstractTable obj) {
        this.from.add(obj);
        if (this.aliasToTable != null) {
            this.aliasToTable.put(obj.getAlias(), obj);
        }
        this.onlyTable = obj;
    }

    public Set<AbstractConstraint> getWhere() {
        return this.where;
    }

    public void addWhere(AbstractConstraint obj) {
        this.where.add(obj);
    }

    public Set<AbstractValue> getGroupBy() {
        return this.groupBy;
    }

    public void addGroupBy(AbstractValue obj) {
        this.groupBy.add(obj);
    }

    public Set<AbstractConstraint> getHaving() {
        return this.having;
    }

    public void addHaving(AbstractConstraint obj) {
        this.having.add(obj);
    }

    public List<AbstractValue> getOrderBy() {
        return this.orderBy;
    }

    public void addOrderBy(AbstractValue obj) {
        this.orderBy.add(obj);
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setLimitOffset(int limit, int offset) {
        this.limit = limit;
        this.offset = offset;
    }

    public void addToUnion(Query query) {
        this.queriesInUnion.addAll(query.queriesInUnion);
    }

    public List<Query> getUnion() {
        return this.queriesInUnion;
    }

    @Override
    public String getSQLString() {
        boolean needComma = false;
        String retval = "";
        for (Query q : this.queriesInUnion) {
            if (needComma) {
                retval = retval + " UNION ";
            }
            needComma = true;
            retval = retval + q.getSQLStringNoUnion();
        }
        return retval;
    }

    public String getSQLStringNoUnion() {
        return (this.explain ? "EXPLAIN " : "") + "SELECT " + (this.distinct ? "DISTINCT " : "") + Query.collectionToSQLString(this.select, ", ") + (this.from.isEmpty() ? "" : " FROM " + Query.collectionToSQLString(this.from, ", ")) + (this.where.isEmpty() ? "" : " WHERE " + Query.collectionToSQLString(this.where, " AND ")) + (this.groupBy.isEmpty() ? "" : " GROUP BY " + Query.collectionToSQLString(this.groupBy, ", ") + (this.having.isEmpty() ? "" : " HAVING " + Query.collectionToSQLString(this.having, " AND "))) + (this.orderBy.isEmpty() ? "" : " ORDER BY " + Query.collectionToSQLString(this.orderBy, ", ")) + (this.limit == 0 ? "" : " LIMIT " + this.limit + (this.offset == 0 ? "" : " OFFSET " + this.offset));
    }

    public String getSQLStringForPrecomputedTable(String extraSelect) {
        return (this.explain ? "EXPLAIN " : "") + "SELECT " + (this.distinct ? "DISTINCT " : "") + Query.collectionToSQLString(this.select, Collections.singleton(extraSelect), ", ") + (this.from.isEmpty() ? "" : " FROM " + Query.collectionToSQLString(this.from, ", ")) + (this.where.isEmpty() ? "" : " WHERE " + Query.collectionToSQLString(this.where, " AND ")) + (this.groupBy.isEmpty() ? "" : " GROUP BY " + Query.collectionToSQLString(this.groupBy, ", ") + (this.having.isEmpty() ? "" : " HAVING " + Query.collectionToSQLString(this.having, " AND "))) + (this.orderBy.isEmpty() ? "" : " ORDER BY " + Query.collectionToSQLString(this.orderBy, ", ")) + (this.limit == 0 ? "" : " LIMIT " + this.limit + (this.offset == 0 ? "" : " OFFSET " + this.offset));
    }

    protected static String collectionToSQLString(Collection<? extends SQLStringable> c, String comma) {
        return Query.collectionToSQLString(c, null, comma);
    }

    protected static String collectionToSQLString(Collection<? extends SQLStringable> c, Collection<String> extraValues, String comma) {
        StringBuilder sb = new StringBuilder();
        boolean needComma = false;
        for (SQLStringable sQLStringable : c) {
            if (needComma) {
                sb.append(comma);
            }
            needComma = true;
            sb.append(sQLStringable.getSQLString());
        }
        if (extraValues != null) {
            for (String string : extraValues) {
                if (needComma) {
                    sb.append(comma);
                }
                needComma = true;
                sb.append(string);
            }
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Query) {
            int i;
            Query q = (Query)obj;
            if (this.queriesInUnion.size() != q.queriesInUnion.size()) {
                return false;
            }
            boolean[] used = new boolean[this.queriesInUnion.size()];
            for (i = 0; i < this.queriesInUnion.size(); ++i) {
                used[i] = false;
            }
            for (i = 0; i < this.queriesInUnion.size(); ++i) {
                Query thisQ = this.queriesInUnion.get(i);
                boolean notFound = true;
                for (int o = 0; o < this.queriesInUnion.size() && notFound; ++o) {
                    Query thatQ = q.queriesInUnion.get(o);
                    if (!thisQ.equalsNoUnion(thatQ) || used[o]) continue;
                    notFound = false;
                    used[o] = true;
                }
                if (!notFound) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equalsNoUnion(Object obj) {
        if (obj instanceof Query) {
            Query q = (Query)obj;
            return ((Object)this.select).equals(q.select) && ((Object)this.from).equals(q.from) && ((Object)this.where).equals(q.where) && ((Object)this.groupBy).equals(q.groupBy) && ((Object)this.having).equals(q.having) && ((Object)this.orderBy).equals(q.orderBy) && this.limit == q.limit && this.offset == q.offset && this.explain == q.explain && this.distinct == q.distinct;
        }
        return false;
    }

    public int hashCode() {
        int retval = 0;
        for (int i = 0; i < this.queriesInUnion.size(); ++i) {
            retval += this.queriesInUnion.get(i).hashCodeNoUnion();
        }
        return retval;
    }

    public int hashCodeNoUnion() {
        return 3 * ((Object)this.select).hashCode() + 5 * ((Object)this.from).hashCode() + 7 * ((Object)this.where).hashCode() + 11 * ((Object)this.groupBy).hashCode() + 13 * ((Object)this.having).hashCode() + 17 * ((Object)this.orderBy).hashCode() + 19 * this.limit + 23 * this.offset + (this.explain ? 29 : 0) + (this.distinct ? 31 : 0);
    }

    public String toString() {
        return this.getSQLString();
    }

    private void processSqlStatementAST(AST ast) {
        if (ast.getType() != 4) {
            throw new IllegalArgumentException("Expected: a SQL SELECT statement");
        }
        this.processAST(ast.getFirstChild());
        ast = ast.getNextSibling();
        if (ast != null && ast.getType() == 4) {
            new Query(this.originalAliasToTable, this.queriesInUnion).processSqlStatementAST(ast);
        }
    }

    private void processAST(AST ast) {
        boolean processSelect = false;
        switch (ast.getType()) {
            case 32: {
                this.explain = true;
                break;
            }
            case 33: {
                this.distinct = true;
                break;
            }
            case 5: {
                processSelect = true;
                break;
            }
            case 6: {
                this.processFromList(ast.getFirstChild());
                break;
            }
            case 7: {
                this.processWhereClause(ast.getFirstChild());
                break;
            }
            case 8: {
                this.processGroupClause(ast.getFirstChild());
                break;
            }
            case 9: {
                this.processHavingClause(ast.getFirstChild());
                break;
            }
            case 10: {
                this.processOrderClause(ast.getFirstChild());
                break;
            }
            case 11: {
                this.processLimitClause(ast.getFirstChild());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
            }
        }
        if (ast.getNextSibling() != null) {
            this.processAST(ast.getNextSibling());
        }
        if (processSelect) {
            this.processSelectList(ast.getFirstChild());
        }
    }

    private void processFromList(AST ast) {
        boolean processSubQuery = false;
        switch (ast.getType()) {
            case 15: {
                this.processNewTable(ast.getFirstChild());
                break;
            }
            case 17: {
                processSubQuery = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
            }
        }
        if (ast.getNextSibling() != null) {
            this.processFromList(ast.getNextSibling());
        }
        if (processSubQuery) {
            this.processNewSubQuery(ast.getFirstChild());
        }
    }

    private void processNewTable(AST ast) {
        String tableName = null;
        String tableAlias = null;
        do {
            switch (ast.getType()) {
                case 16: {
                    tableName = ast.getFirstChild().getText();
                    break;
                }
                case 13: {
                    tableAlias = ast.getFirstChild().getText();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
        this.addFrom(new Table(tableName, tableAlias));
    }

    private void processNewSubQuery(AST ast) {
        AST subquery = null;
        String alias = null;
        block4: do {
            switch (ast.getType()) {
                case 4: {
                    if (subquery != null) continue block4;
                    subquery = ast;
                    break;
                }
                case 13: {
                    alias = ast.getFirstChild().getText();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
        Query q = new Query(this.aliasToTable);
        q.processSqlStatementAST(subquery);
        this.addFrom(new SubQuery(q, alias));
    }

    public void processSelectList(AST ast) {
        do {
            switch (ast.getType()) {
                case 12: {
                    this.processNewSelect(ast.getFirstChild());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
    }

    public void processNewSelect(AST ast) {
        AbstractValue v = null;
        String alias = null;
        do {
            switch (ast.getType()) {
                case 14: {
                    alias = ast.getFirstChild().getText();
                    break;
                }
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 43: {
                    v = this.processNewAbstractValue(ast);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
        SelectValue sv = new SelectValue(v, alias);
        this.addSelect(sv);
    }

    public void processGroupClause(AST ast) {
        do {
            this.addGroupBy(this.processNewAbstractValue(ast));
        } while ((ast = ast.getNextSibling()) != null);
    }

    public void processOrderClause(AST ast) {
        do {
            this.addOrderBy(this.processNewAbstractValue(ast));
        } while ((ast = ast.getNextSibling()) != null);
    }

    public AbstractValue processNewAbstractValue(AST ast) {
        switch (ast.getType()) {
            case 19: {
                return this.processNewField(ast.getFirstChild());
            }
            case 43: {
                return this.processNewTypecast(ast.getFirstChild());
            }
            case 18: {
                return new Constant(ast.getFirstChild().getText());
            }
            case 22: {
                return this.processNewUnsafeFunction(ast.getFirstChild());
            }
            case 21: {
                return this.processNewSafeFunction(ast.getFirstChild());
            }
            case 30: {
                return new OrderDescending(this.processNewAbstractValue(ast.getFirstChild()));
            }
        }
        throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
    }

    public Field processNewField(AST ast) {
        String table = null;
        String field = null;
        do {
            switch (ast.getType()) {
                case 13: {
                    table = ast.getFirstChild().getText();
                    break;
                }
                case 20: {
                    field = ast.getFirstChild().getText();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
        AbstractTable t = null;
        t = table == null ? this.onlyTable : this.aliasToTable.get(table);
        return new Field(field, t);
    }

    public Function processNewTypecast(AST ast) {
        AbstractValue obj = null;
        Function retval = null;
        do {
            switch (ast.getType()) {
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 43: {
                    if (obj != null) {
                        throw new IllegalArgumentException("Already have value in typecast " + ast.getText() + " [" + ast.getType() + "]");
                    }
                    obj = this.processNewAbstractValue(ast);
                    break;
                }
                case 44: {
                    retval = new Function(12);
                    retval.add(obj);
                    retval.add(new Constant("boolean"));
                    obj = retval;
                    break;
                }
                case 45: {
                    retval = new Function(12);
                    retval.add(obj);
                    retval.add(new Constant("real"));
                    obj = retval;
                    break;
                }
                case 46: {
                    retval = new Function(12);
                    retval.add(obj);
                    retval.add(new Constant("double precision"));
                    obj = retval;
                    break;
                }
                case 47: {
                    retval = new Function(12);
                    retval.add(obj);
                    retval.add(new Constant("smallint"));
                    obj = retval;
                    break;
                }
                case 48: {
                    retval = new Function(12);
                    retval.add(obj);
                    retval.add(new Constant("integer"));
                    obj = retval;
                    break;
                }
                case 49: {
                    retval = new Function(12);
                    retval.add(obj);
                    retval.add(new Constant("bigint"));
                    obj = retval;
                    break;
                }
                case 50: {
                    retval = new Function(12);
                    retval.add(obj);
                    retval.add(new Constant("numeric"));
                    obj = retval;
                    break;
                }
                case 51: {
                    retval = new Function(12);
                    retval.add(obj);
                    retval.add(new Constant("text"));
                    obj = retval;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
        return retval;
    }

    public Function processNewUnsafeFunction(AST ast) {
        AbstractValue firstObj = null;
        Function retval = null;
        boolean gotType = false;
        block9: do {
            switch (ast.getType()) {
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 43: {
                    if (!gotType) {
                        firstObj = this.processNewAbstractValue(ast);
                        break;
                    }
                    retval.add(this.processNewAbstractValue(ast));
                    break;
                }
                case 63: {
                    if (gotType) continue block9;
                    retval = new Function(6);
                    retval.add(firstObj);
                    gotType = true;
                    break;
                }
                case 68: {
                    if (gotType) continue block9;
                    retval = new Function(7);
                    retval.add(firstObj);
                    gotType = true;
                    break;
                }
                case 65: {
                    if (gotType) continue block9;
                    retval = new Function(8);
                    retval.add(firstObj);
                    gotType = true;
                    break;
                }
                case 66: {
                    if (gotType) continue block9;
                    retval = new Function(9);
                    retval.add(firstObj);
                    gotType = true;
                    break;
                }
                case 67: {
                    if (gotType) continue block9;
                    retval = new Function(10);
                    retval.add(firstObj);
                    gotType = true;
                    break;
                }
                case 64: {
                    if (gotType) continue block9;
                    retval = new Function(11);
                    retval.add(firstObj);
                    gotType = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
        return retval;
    }

    public Function processNewSafeFunction(AST ast) {
        Function retval = null;
        boolean gotType = false;
        block14: do {
            switch (ast.getType()) {
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 43: {
                    retval.add(this.processNewAbstractValue(ast));
                    break;
                }
                case 52: {
                    if (gotType) continue block14;
                    retval = new Function(1);
                    gotType = true;
                    break;
                }
                case 53: {
                    if (gotType) continue block14;
                    retval = new Function(2);
                    gotType = true;
                    break;
                }
                case 54: {
                    if (gotType) continue block14;
                    retval = new Function(3);
                    gotType = true;
                    break;
                }
                case 55: {
                    if (gotType) continue block14;
                    retval = new Function(4);
                    gotType = true;
                    break;
                }
                case 56: {
                    if (gotType) continue block14;
                    retval = new Function(5);
                    gotType = true;
                    break;
                }
                case 59: {
                    if (gotType) continue block14;
                    retval = new Function(13);
                    gotType = true;
                    break;
                }
                case 57: {
                    if (gotType) continue block14;
                    retval = new Function(16);
                    gotType = true;
                    break;
                }
                case 58: {
                    if (gotType) continue block14;
                    retval = new Function(17);
                    gotType = true;
                    break;
                }
                case 60: {
                    if (gotType) continue block14;
                    retval = new Function(14);
                    gotType = true;
                    break;
                }
                case 61: {
                    if (gotType) continue block14;
                    retval = new Function(15);
                    gotType = true;
                    break;
                }
                case 62: {
                    if (gotType) continue block14;
                    retval = new Function(18);
                    gotType = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
        return retval;
    }

    private void processWhereClause(AST ast) {
        do {
            switch (ast.getType()) {
                case 26: {
                    this.processWhereClause(ast.getFirstChild());
                    break;
                }
                case 23: 
                case 24: 
                case 25: 
                case 27: 
                case 28: 
                case 29: {
                    this.addWhere(this.processNewAbstractConstraint(ast));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
    }

    private void processHavingClause(AST ast) {
        do {
            switch (ast.getType()) {
                case 26: {
                    this.processHavingClause(ast.getFirstChild());
                    break;
                }
                case 23: 
                case 24: 
                case 25: 
                case 27: 
                case 28: 
                case 29: {
                    this.addHaving(this.processNewAbstractConstraint(ast));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
    }

    public AbstractConstraint processNewAbstractConstraint(AST ast) {
        switch (ast.getType()) {
            case 23: {
                AST subAST = ast.getFirstChild();
                AbstractValue left = this.processNewAbstractValue(subAST);
                subAST = subAST.getNextSibling();
                int op = 0;
                switch (subAST.getType()) {
                    case 76: {
                        op = 2;
                        break;
                    }
                    case 75: {
                        op = 1;
                        break;
                    }
                    case 74: {
                        op = 3;
                        break;
                    }
                    case 77: {
                        op = 4;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown AST node: " + subAST.getText() + " [" + subAST.getType() + "]");
                    }
                }
                subAST = subAST.getNextSibling();
                AbstractValue right = this.processNewAbstractValue(subAST);
                return new Constraint(left, op, right);
            }
            case 24: {
                AST subAST = ast.getFirstChild();
                AbstractValue bleft = this.processNewAbstractValue(subAST);
                return new Constraint(bleft, 1, new Constant("null"));
            }
            case 25: {
                AST subAST = ast.getFirstChild();
                AbstractConstraint a = this.processNewAbstractConstraint(subAST);
                return new NotConstraint(a);
            }
            case 27: {
                ConstraintSet b = new ConstraintSet();
                AST subAST = ast.getFirstChild();
                do {
                    b.add(this.processNewAbstractConstraint(subAST));
                } while ((subAST = subAST.getNextSibling()) != null);
                return b;
            }
            case 28: {
                AST subAST = ast.getFirstChild();
                AbstractValue leftb = this.processNewAbstractValue(subAST);
                subAST = subAST.getNextSibling();
                if (subAST.getType() != 4) {
                    throw new IllegalArgumentException("Expected: a SQL SELECT statement");
                }
                Query rightb = new Query(this.aliasToTable);
                rightb.processSqlStatementAST(subAST);
                return new SubQueryConstraint(leftb, rightb);
            }
            case 29: {
                AST subAST = ast.getFirstChild();
                AbstractValue leftc = this.processNewAbstractValue(subAST);
                InListConstraint retval = new InListConstraint(leftc);
                for (subAST = subAST.getNextSibling(); subAST != null; subAST = subAST.getNextSibling()) {
                    AbstractValue rightc = this.processNewAbstractValue(subAST);
                    retval.add((Constant)rightc);
                }
                return retval;
            }
        }
        throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
    }

    public void processLimitClause(AST ast) {
        this.limit = Integer.parseInt(ast.getText());
        if (ast.getNextSibling() != null) {
            this.offset = Integer.parseInt(ast.getNextSibling().getText());
        }
    }

    public static void main(String[] args) throws Exception {
        AST oldAst;
        Date startTime = new Date();
        PrintStream out = System.out;
        ByteArrayInputStream is = new ByteArrayInputStream(args[0].getBytes());
        SqlLexer lexer = new SqlLexer(is);
        SqlParser parser = new SqlParser(lexer);
        parser.start_rule();
        AST ast = parser.getAST();
        DumpASTVisitor visitor = new DumpASTVisitor();
        int iters = 0;
        do {
            out.println("\nTime taken so far: " + (new Date().getTime() - startTime.getTime()) + " milliseconds.");
            out.println("\n==> Dump of AST <==");
            visitor.visit(ast);
            oldAst = ast;
            SqlTreeParser treeparser = new SqlTreeParser();
            treeparser.start_rule(ast);
            ast = treeparser.getAST();
            ++iters;
        } while (!oldAst.equalsList(ast));
        if (ast.getType() != 4) {
            throw new IllegalArgumentException("Expected: a SQL SELECT statement");
        }
        Query q = new Query(new HashMap<String, AbstractTable>());
        q.processSqlStatementAST(ast);
        out.println("\n" + q.getSQLString());
        out.println("\nTime taken so far: " + (new Date().getTime() - startTime.getTime()) + " milliseconds.");
        out.println("Iterations required: " + iters);
    }
}

