/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.intermine.sql.query.ExplainResult;
import org.intermine.sql.query.Query;

public class PostgresExplainResult
extends ExplainResult {
    private String explainText = null;

    protected PostgresExplainResult() {
    }

    public PostgresExplainResult(Query query, Connection database) throws SQLException {
        this(query.getSQLString(), database);
    }

    public PostgresExplainResult(String query, Connection database) throws SQLException {
        if (query == null || database == null) {
            throw new NullPointerException("Arguments cannot be null");
        }
        Statement s = database.createStatement();
        if (!query.toUpperCase().startsWith("EXPLAIN ")) {
            query = "explain " + query;
        }
        try {
            s.execute(query);
            this.retrieveExplainString(s);
            s.close();
        }
        catch (SQLException e) {
            SQLException e2 = new SQLException("Error running query \"" + query + "\"");
            e2.initCause(e);
            throw e2;
        }
    }

    public PostgresExplainResult(PreparedStatement stmt) throws SQLException {
        if (stmt == null) {
            throw new NullPointerException("PreparedStatement argument cannot be null");
        }
        Connection database = stmt.getConnection();
        if (database == null) {
            throw new NullPointerException("Failed to retrieve Connection from PreparedStatement");
        }
        stmt.execute();
        this.retrieveExplainString(stmt);
        stmt.close();
    }

    public String getExplainText() {
        return this.explainText;
    }

    protected void retrieveExplainString(Statement stmt) throws SQLException {
        ResultSet results = stmt.getResultSet();
        if (results == null || !results.next()) {
            throw new SQLException("Failed to get a valid explain string from database");
        }
        String text = results.getString(1);
        try {
            this.parseWarningString(text);
        }
        catch (RuntimeException e) {
            throw new SQLException("Error parsing EXPLAIN string: " + e);
        }
        StringBuffer explainTextBuffer = new StringBuffer(text).append("\n");
        while (results.next()) {
            explainTextBuffer.append(results.getString(1)).append("\n");
        }
        this.explainText = explainTextBuffer.toString();
        if (stmt.getMoreResults()) {
            throw new SQLException("Database returned more than ResultSet while EXPLAINing");
        }
    }

    void parseWarningString(String text) {
        int nextToken = text.indexOf("(cost=") + 6;
        if (nextToken < 6) {
            throw new IllegalArgumentException("Invalid EXPLAIN string: no \"(cost=\" bad string: " + text);
        }
        int endOfString = text.indexOf(41, nextToken);
        if (endOfString < 0) {
            throw new IllegalArgumentException("Invalid EXPLAIN string: no \")\" bad string " + text);
        }
        if ((nextToken = (text = text.substring(nextToken, endOfString)).indexOf("..")) < 0) {
            throw new IllegalArgumentException("Invalid EXPLAIN string: no \"..\" bad string: " + text);
        }
        String toParse = text.substring(0, text.indexOf(46)) + text.substring(text.indexOf(46) + 1, text.indexOf(46) + 2);
        try {
            this.start = Long.parseLong(toParse);
        }
        catch (NumberFormatException e) {
            this.start = Long.MAX_VALUE;
        }
        text = text.substring(nextToken + 2);
        nextToken = text.indexOf(" rows=");
        if (nextToken < 0) {
            throw new IllegalArgumentException("Invalid EXPLAIN string: no \" rows=\"");
        }
        toParse = text.substring(0, text.indexOf(46)) + text.substring(text.indexOf(46) + 1, text.indexOf(46) + 2);
        try {
            this.complete = Long.parseLong(toParse);
        }
        catch (NumberFormatException e) {
            this.complete = Long.MAX_VALUE;
        }
        text = text.substring(nextToken + 6);
        nextToken = text.indexOf(" width=");
        if (nextToken < 0) {
            throw new IllegalArgumentException("Invalid EXPLAIN string: no \" width=\" bad string:" + text);
        }
        try {
            this.rows = Long.parseLong(text.substring(0, nextToken));
        }
        catch (NumberFormatException e) {
            this.rows = Long.MAX_VALUE;
        }
        this.estimatedRows = this.rows;
        text = text.substring(nextToken + 7);
        try {
            this.width = Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            this.width = Long.MAX_VALUE;
        }
    }
}

